c# cginv1.f
      SUBROUTINE CGINV1(CGLAT,CGLON,GGLAT,GGLON)
C***********************************************************************
C* SUBROUTINE NAME :  CGINV1            CPC:  SS/MOD/RTN/CGINV1        *
C*          VERSION:  88-II            DATE:  16 MAR 88                *
C*                                                                     *
C*          PURPOSE:  THIS SUBROUTINE CONVERTS CORRECTED GEOMAG COORDS *
C*                    BACK TO GEOGRAPHIC COORDINATES, BECAUSE SOME OF  *
C*                    THE ICED MODEL APPLICATIONS SOFTWARE REQUIRES THE*
C*                    COORDINATES IN THAT FRAME.  THE SUBROUTINE WAS   *
C*                    DEVELOPED BY LOGICON,INC. IN JULY 1973 AND LATER *
C*                    MODIFIED BY MS. HAUSMAN OF NOAA/NGDC, BOULDER,CO *
C*                    AND ROD CREGIER, USAF ACADEMY, DO.  CGINV IS THE *
C*                    DRIVER OF THE CONVERSION, AND CALLS CGLAL1.      *
C*                                                                     *
C*          CALLING                                                    *
C*        ARGUMENTS:  CGLAT, CGLON, GGLAT, GGLON                       *
C*                                                                     *
C*    ABBREVIATIONS:  NONE                                             *
C*                                                                     *
C*    COMMON BLOCKS:  NONE ACCESSED                                    *
C*                                                                     *
C*   FILES ACCESSED:  NONE                                             *
C*                                                                     *
C*           METHOD:  1. SELECTS POLAR OR MID-LATITUDE ALGORITHMS      *
C*                    2. IF POLAR GRIDPOINT, CONVERTS THE GRIDPOINT    *
C*                       USING POLAR STEREOGRAPHIC COORDINATES TO      *
C*                       GEOGRAPHIC                                    *
C*                    3. IF MID-LATITUDE GRIDPOINT, CONVERTS THE GRID- *
C*                       POINT USING RECTANGULAR COORDINATES TO        *
C*                       GEOGRAPHIC.                                   *
C*                                                                     *
C*          REMARKS:  NONE                                             *
C*                                                                     *
C*       REFERENCES:  1.  ICED-III SYSTEM DOCUMENTATION                *
C*                    2.  SPERRY FORTRAN-77 (ASCII) PRM                *
C*                    3.  AFGWC FORM 10 DX-50194                       *
C*                    4.  AFGWC FORM 10 DX-60096                       *
C*                                                                     *
C*  LOCAL VARIABLES:  N        IS NORTH/SOUTH FLAG (N=1,S=2)           *
C*                    BA       RS DIFFERENCE BETWEEN GRIDPOINT LONG-   *
C*                                ITUDE AND THE GEOMAG LONGITUDE OF    *
C*                                POLE IN RADIANS                      *
C*                    BL       RS GEOMAG LONGITUDE OF POLE IN RADIANS  *
C*                    CGLAT    RS INPUT GEOMAG LATITUDE                *
C*                    CGLON    RS INPUT GEOMAG LONGITUDE               *
C*                    ELAT     RS INCREMENTAL DIFFERENCE IN LATITUDE   *
C*                    ELON     RS INCREMENTAL DIFFERENCE IN LONGITUDE  *
C*                    GGLAT    RS RETURNED GEOGRAPHIC LATITUDE         *
C*                    GGLON    RS RETURNED GEOGRAPHIC LONGITUDE        *
C*                    PLAT(2)  RV GEOGRAPHIC LATITUDE OF POLES         *
C*                    PLONG(2) RV GEOGRAPHIC LONGITUDE OF POLES        *
C*                    PMAT(2)  RV GEOMAGNETIC LATITUDE OF POLES        *
C*                    PMONG(2) RV GEOMAGNETIC LONGITUDE OF POLES       *
C*                    QLAT     RS TEMPORARY LATITUDE INCREMENT VALUE   *
C*                    QLONG    RS TEMPORARY LONGITUDE INCREMENT VALUE  *
C*                    RAD      RS RADIAN TO DEGREE CONVERSION FACTOR   *
C*                    RLAT(2)  RV RATIO OF DIFFERENCES BETWEEN GEOGRA- *
C*                                PHIC AND GEOMAGNETIC LATITUDE AT POLE*
C*                    RLONG(2) RV RATIO OF DEFFERENCE BETWEEN GEOGRAP- *
C*                                HIC AND GEOMAGNETIC LONGITUDE AT POLE*
C*                    SB       RS RATIO OF (90-LAT) TO (90-POLE)       *
C*                    SC       RS (90-POLE) IN GEOMAGNETIC COORDINATES *
C*                    SGN      RS SIGN OF LATITUDE (N=1,S=-1)          *
C*                    X        RS FIRST GUESS GEOGRAPHIC LATITUDE      *
C*                    Y        RS FIRST GUESS GEOGRAPHIC LONGITUDE     *
C*  (I=INTEGER, R=REAL, C=CHARACTER, S=SCALAR, V=VECTOR, A=ARRAY)      *
C*                                                                     *
C*     SETC OPTIONS:  NONE USED                                        *
C*                                                                     *
C*       SUBPROGRAMS                                                   *
C*           CALLED:  CGLAL1 - CONVERTS GEOGRAPHIC TO GEOMAGNETIC      *
C*                                                                     *
C*       SUBPROGRAM                                                    *
C*       CALLED BY :  F2LAYR                                           *
C*                                                                     *
C* PROGRAM WRITTEN:  JAN 86 - NATIONAL GEOPHYSICAL DATA CENTER         *
C*                   MAY 86 - AFGWC/SDDE - UPGRADED DOCUMENTATION      *
C*                   AUG 87 - NATIONAL GEOPHYSICAL DATA CENTER (87-I)  *
C*                   MAR 88 - NGDC (88-II) REPLACE CORGM1 WITH CGLAL1  *
C*                                                                     *
C***********************************************************************
      INTEGER N
      REAL BA
      REAL BL
      REAL CGLAT
      REAL CGLON
      REAL ELAT
      REAL ELONG
      REAL GGLAT
      REAL GGLON
      REAL PLAT(2)
      REAL PLONG(2)
      REAL PMAT(2)
      REAL PMONG(2)
      REAL QLAT
      REAL QLONG
      REAL RAD
      REAL RLAT(2)
      REAL RLONG(2)
      REAL SB
      REAL SC
      REAL SGN
      REAL X
      REAL Y
      DATA RAD/57.2957795/
      DATA PLAT/80.,75./,PLONG/280.,127./
      DATA PMAT/81.6,74.5/,PMONG/169.8,17.3/
 
C......................................................................
C     BEGIN EXECUTION BY CHOOSING POLAR OR MID-LATITUDE               .
C......................................................................
      IF(ABS(CGLAT).LT.40.) GO TO 140
C......................................................................
C     POLAR CASE -- SEARCH USING POLAR COORDINATES.                   .
C......................................................................
      DO 20 I = 1,2
        RLONG(I)=PLONG(I)+180.-PMONG(I)
        RLAT(I)=(90.-PMAT(I))/(90.-PLAT(I))
20    CONTINUE
      N=1
      IF(CGLAT.LT.0.) N=2
      SGN=3.-2.*N
      SC=90.-PLAT(N)
      SB=(90.-ABS(CGLAT))/RLAT(N)
      BA=(CGLON+RLONG(N))/RAD
      BL=PLONG(N)/RAD
      DO 130 I = 1,50
        X=SC*COS(BL)+SB*COS(BA)
        Y=SC*SIN(BL)+SB*SIN(BA)
        GGLAT=(90.-SQRT(X*X+Y*Y))*SGN
        GGLON=ATAN2(Y,X)*RAD
        IF(GGLON.LT.0.) GGLON=GGLON+360.
        CALL CGLAL1(GGLAT,GGLON,QLAT,QLONG)
        ELAT=(CGLAT-QLAT)*SGN
        ELONG=CGLON-QLONG
        IF(ABS( ELAT).GT.0.05.AND.ABS( ELAT).LT.359.95) GO TO 120
        IF(ABS(ELONG).GT.0.05.AND.ABS(ELONG).LT.359.95) GO TO 120
        RETURN
120     SB=SB-ELAT
        BA=BA+ELONG/RAD
130   CONTINUE
      RETURN
C......................................................................
C     MID-LATITUDE CASE -- SEARCH USING RECTANGULAR COORDINATES.      .
C......................................................................
140   GGLAT=CGLAT
      GGLON=AMOD(CGLON+290.,360.)
      DO 160 I = 1,20
        CALL CGLAL1(GGLAT,GGLON,QLAT,QLONG)
        ELAT=CGLAT-QLAT
        ELONG=CGLON-QLONG
        IF(ABS( ELAT).GT.0.05.AND.ABS( ELAT).LT.359.95) GO TO 150
        IF(ABS(ELONG).GT.0.05.AND.ABS(ELONG).LT.359.95) GO TO 150
        RETURN
150     GGLAT=GGLAT+ELAT
        GGLON=AMOD(GGLON+ELONG+360.,360.)
160   CONTINUE
      RETURN
      END
 
 
