c# cglal1.f
      SUBROUTINE CGLAL1( GGLAT,GGLON, CGLAT,CGLON )
C***********************************************************************
C* SUBROUTINE NAME :  CGLAL1            CPC:  SS/MOD/RTN/CGLAL1        *
C*          VERSION:  88-II            DATE:  16 MAR 88                *
C*                                                                     *
C*          PURPOSE:  THIS SUBROUTINE IS THE HAKURA-GUSTOFSSON COORD-  *
C*                    INATE TRANSFORMATION OF GEOGRAPHICS LAT AND LONG *
C*                    TO CORRECTED GEOMAGNETIC LAT AND LONG.  THE      *
C*                    ROUTINE HAS BEEN CHANGED MANY TIMES.             *
C*                                                                     *
C*                    1. 23 FEB 79 - CORRECTED TO ALLOW CALCULATION OF *
C*                    CGM UP TO BOTH POLES (R.K. ROSICH)               *
C*                    2. XX AUG 83 - MODIFIED TO USE ARGUMENTS BASED ON*
C*                    IGRF80 AND DISCONTINUITIES IN TABLE REMOVED BY   *
C*                    CURVE FITTING. (F.J.RICH)                        *
C*                    3. XX JUL 85 - CORRECTED AND UPDATED BY HERBERT  *
C*                    KROEHL AND BONNIE HAUSMAN OF USDOC/NOAA/NGDC/DSD *
C*                                                                     *
C*          CALLING                                                    *
C*        ARGUMENTS:  GGLAT, GGLON, CGLAT, CGLON                       *
C*                                                                     *
C*    ABBREVIATIONS:  NONE                                             *
C*                                                                     *
C*    COMMON BLOCKS:  COORDS                                           *
C*                                                                     *
C*   FILES ACCESSED:  NONE                                             *
C*                                                                     *
C*           METHOD:  1.  INSURE LAT & LON ARE WITHIN PROPER LIMITS    *
C*                    2.  FIND THE FOUR CORNERS OF A RECTANGLE CON-    *
C*                        TAINING THE REQUESTED GRIDPOINT.             *
C*                    3.  CHECK THE NORTH, SOUTH, EAST AND WEST BOUND- *
C*                        ARIES OF THE BOX TO INSURE THEY ARE WITHIN   *
C*                        THE TRANSFORMATION ARRAY.                    *
C*                    4.  CONVERT THE GRIDPOINT TO GEOMAG LAT AND LON. *
C*                                                                     *
C*          REMARKS:  NONE                                             *
C*                                                                     *
C*       REFERENCES:  1.  ICED-III SYSTEM DOCUMENTATION                *
C*                    2.  SPERRY FORTRAN-77 (ASCII) PRM                *
C*                    3.  AFGWC FORM 10 DX-50194                       *
C*                    4.  AFGWC FORM 10 DX-60096                       *
C*                                                                     *
C* GLOBAL VARIABLES:                                                   *
C*  COMMON /COORDS/ XCG(2,36,89)                                        *
C*     CG     RA   GEOMAGNETIC COORDINATES OF GRIDPOINTS               *
C*                                                                     *
C*  LOCAL VARIABLES:  I        IS  QUALITY CONTROL VARIABLE            *
C*                    J        IS  INDEX INTO LONGITUDE / 10           *
C*                    K        IS  INDEX INTO DATA ARRAY               *
C*                    ALPHA    RS  COEFFICIENT OF INTERPOLATION        *
C*                    BETA     RS  COEFFICIENT OF INTERPOLATION        *
C*                    CGLAT    RS  CORRECTED GEOMAG LATITUDE           *
C*                    CGLON    RS  CORRECTED GEOMAG LONGITUDE          *
C*                    CGMNLA   RS  MAG LATITUDE FOR NORTH POLE         *
C*                    CGMNLO   RS  MAG LONGITUDE FOR NORTH POLE        *
C*                    CGMSLA   RS  MAG LATITUDE FOR SOUTH POLE         *
C*                    CGMSLO   RS  MAG LONGITUDE FOR SOUTH POLE        *
C*                    EGGLA    RS  SOUTHERN GEOGRAPHIC LATITUDE        *
C*                    GGLAT    RS  GEOGRAPHIC LATITUDE in Deg.         *
C*                    GGLAT1   RS  TEMP. GEOGRAPHIC LATITUDE           *
C*                    GGLON    RS  GEOGRAPHIC LONGITUDE in Deg.       *
C*                    GGLON1   RS  TEMP. GEOGRAPHIC LATITUDE           *
C*                    TEMP     RS  LOCAL CALCULATION VARIABLE          *
C*                    WGGLO    RS  WESTERN BOUNDARY OF GRID            *
C*                    X1LAT    RS  NORTHEAST LATITUDE OF BOX           *
C*                    X1LON    RS  NORTHEAST LONGITUDE OF BOX          *
C*                    X2LAT    RS  NORTHWEST LATITUDE OF BOX           *
C*                    X2LON    RS  NORTHWEST LONGITUDE OF BOX          *
C*                    X3LAT    RS  SOUTHWEST LATITUDE OF BOX           *
C*                    X3LON    RS  SOUTHWEST LONGITUDE OF BOX          *
C*                    X4LAT    RS  SOUTHEAST LATITUDE OF BOX           *
C*                    X4LON    RS  SOUTHEAST LONGITUDE OF BOX          *
C*  (I=INTEGER, R=REAL, C=CHARACTER, S=SCALAR, V=VECTOR, A=ARRAY)      *
C*                                                                     *
C*     SETC OPTIONS:  NONE USED                                        *
C*                                                                     *
C*       SUBPROGRAMS                                                   *
C*           CALLED:  NONE                                             *
C*                                                                     *
C*       SUBPROGRAM                                                    *
C*       CALLED BY :  CGINV1                                           *
C*                                                                     *
C*                                                                     *
C* PROGRAM WRITTEN:  JAN 86 - NATIONAL GEOPHYSICAL DATA CENTER         *
C*                   MAY 86 - AFGWC/SDDE - UPGRADED DOCUMENTATION      *
C*                   AUG 87 - NGDC (87-I)                              *
C*                   MAR 88 - NGDC (88-II) DOCUMENTATION REQUIREMENTS  *
C*                                                                     *
C***********************************************************************
      INTEGER I
      INTEGER J
      INTEGER K
ccc      INTEGER*2 ICG
      REAL ALPHA
      REAL BETA
      REAL CGLAT
      REAL CGLON
      REAL CGMNLA
      REAL CGMNLO
      REAL CGMSLA
      REAL CGMSLO
      REAL EGGLA
      REAL GGLAT
      REAL GGLAT1
      REAL GGLON
      REAL GGLON1
      REAL TEMP
      REAL WGGLO
      REAL X1LAT
      REAL X1LON
      REAL X2LAT
      REAL X2LON
      REAL X3LAT
      REAL X3LON
      REAL X4LAT
      REAL X4LON
      REAL Y
      COMMON /COORDS/ XCG(2,36,89)
      DATA CGMNLA,CGMNLO/82.1,170.8/,  CGMSLA,CGMSLO/-74.0,19.5/
 
C.....................................................................
C     SAVE ORIGINAL INPUTS                                           .
C.....................................................................
      GGLAT1 = GGLAT
      GGLON1 = GGLON
C.....................................................................
C     REDUCE GGLAT TO THE RANGE -90 TO +90 DEGREES                   .
C.....................................................................
 10   IF(GGLAT1.LE.90.) GO TO 20
      GGLAT1=180.-GGLAT1
      GGLON1=GGLON1+180.
      GO TO 10
 20   IF(GGLAT1.GE.-90.) GO TO 30
      GGLAT1=-180.-GGLAT1
      GGLON1=GGLON1+180.
      GO TO 10
 30   CONTINUE
C.......................................................................
C     REDUCE GGLON TO .LT. 360 DEGREES (POSITIVE OR NEGATIVE)          .
C.......................................................................
      GGLON1 = AMOD(GGLON1,360.)
C.......................................................................
C     CHECK TO SEE IF GGLON .GT.0, IF NOT CORRECT TO BE .GT. ZERO      .
C.......................................................................
      IF(GGLON1 .LT. 0.0)GGLON1 = GGLON1 + 360.0
      I = IFIX((90.0 - GGLAT1)/2.0)
      J = IFIX(GGLON1/10.) + 1
C.......................................................................
C     CHECK TO SEE IF I IS WITHIN BOUNDS                               .
C.......................................................................
      IF(I.GT.0.AND.I.LT.89)GO TO 60
C.......................................................................
C     SET TO INTERPOLATE TO THE POLES (N OR S GEOGRAPHIC)              .
C.......................................................................
      IF (J .GT. 36) J=J-36
      IF (J .LT.  1) J=J+36
      K=J+1
      IF (K .GT. 36) K=K-36
      IF (I .GT.  0) GO TO 50
      I=0
      X1LAT=CGMNLA
      X1LON=CGMNLO
      X2LAT=XCG(1,J,I+1)
      X2LON=XCG(2,J,I+1)
      X3LAT=XCG(1,K,I+1)
      X3LON=XCG(2,K,I+1)
      X4LAT=CGMNLA
      X4LON=CGMNLO
      GO TO 70
 50   I=89
      X1LAT=XCG(1,J,I)
      X1LON=XCG(2,J,I)
      X2LAT=CGMSLA
      X2LON=CGMSLO
      X3LAT=CGMSLA
      X3LON=CGMSLO
      X4LAT=XCG(1,K,I)
      X4LON=XCG(2,K,I)
      GO TO 70
C.......................................................................
C     STATEMENT 60.. CHECK TO SEE IF J IS WITHIN BOUNDS.  IF OUT OF    .
C     BOUNDS, RESTORE TO IN BOUNDS                                     .
C.......................................................................
 60   IF(J.GT.36)J = J - 36
      IF(J.LT.1)J = J + 36
C.......................................................................
C     FIND CGLAT AND CGLON OF THE FOUR CORNERS OF RECTANGLE WITHIN     .
C     WHICH GGLAT AND GGLON FALL.  THE CORNERS OF THE RECTANGLE ARE X1,.
C     X2,X3 AND X4.  X1 REFERS TO NORTHWEST CORNER OF THE RECTANGLE.   .
C     THE LABELING GOES IN A COUNTERCLOCKWISE MANNER.                  .
C.......................................................................
      X1LAT = XCG(1,J,I)
      X1LON = XCG(2,J,I)
      X2LAT = XCG(1,J,I+1)
      X2LON = XCG(2,J,I+1)
C.......................................................................
C     CHECK TO SEE IF THE EASTERLY EDGE OF THE RECTANGLE IS WITHIN THE .
C     LIMITS OF THE ARGUMENT BOUNDS OF ARRAY CG                        .
C.......................................................................
      K = J + 1
      IF(K.GT.36)K = K - 36
      X3LAT = XCG(1,K,I+1)
      X3LON = XCG(2,K,I+1)
      X4LAT = XCG(1,K,I)
      X4LON = XCG(2,K,I)
C.......................................................................
C     ELIMINATE THE DISCONTINUITIES IN THE X1, X2, X3, AND X4 LON WHICH.
C     WOULD OCCUR IF THE PRIME MERIDIAN OF THE CORRECTED GEOMAGNETIC   .
C     COORDINATE SYSTEM PASSED THROUGH RECTANGLE X1,X2,X3,X4.          .
C.......................................................................
 70   Y = AMAX1(X1LON,X2LON,X3LON,X4LON)
      IF(ABS(Y-X1LON).GT.180.0)X1LON = X1LON + 360.0
      IF(ABS(Y-X2LON).GT.180.0)X2LON = X2LON + 360.0
      IF(ABS(Y-X3LON).GT.180.0)X3LON = X3LON + 360.0
      IF(ABS(Y-X4LON).GT.180.0)X4LON = X4LON + 360.0
C.......................................................................
C     CALCULATE THE SOUTHERN AND THE WESTWARD BOUNDARIES (GEOGRAPHIC   .
C     LATITUDE AND LONGITUDE) OF THE RECTANGLE.                        .
C.......................................................................
      EGGLA = FLOAT(-2*I + 88)
      WGGLO = FLOAT(10*J - 10)
C.......................................................................
C     CALCULATE THE COEFFICIENTS OF THE INTERPOLATION EQUATION.  THESE .
C     COEFFICIENTS REPRESENT THE FRACTIONAL PART OF THE BOX THE POINT  .
C     GGLAT-GGLON IS FROM THE SOUTHERN AND THE WESTWARD BOUNDARIES     .
C     OF THE RECTANGLE.                                                .
C.......................................................................
      ALPHA = (GGLAT1 - EGGLA)/2.0
      BETA = (GGLON1 - WGGLO)/10.
C.......................................................................
C     NOW CALCULATE THE CORRECTED GEOMAGNETIC COORDINATES THAT CORRESP-.
C     POND TO GEOGRAPHIC COORDINATES OF THE INPUT POINT (GGLAT,GGLON)  .
C.......................................................................
      TEMP = (ALPHA*BETA)*(X4LAT+X2LAT-X1LAT-X3LAT)
      CGLAT = X2LAT + ALPHA*(X1LAT-X2LAT) + BETA*(X3LAT-X2LAT) + TEMP
      TEMP = (ALPHA*BETA)*(X4LON+X2LON-X1LON-X3LON)
      CGLON = X2LON + ALPHA*(X1LON-X2LON) + BETA*(X3LON-X2LON) + TEMP
C.......................................................................
C     CHECK TO DETERMINE IF THE CORRECTED GEOMAGNETIC LONGITUDE IS LESS.
C     THAN 360 DEGREES.  IF IT IS NOT, REDUCE THE CALCULATED VALUE BY  .
C     360 DEGREES                                                      .
C.......................................................................
      IF(CGLON.GT.360.0)CGLON = CGLON - 360.0
      RETURN
      END
