c# chapmn.f
      FUNCTION CHAPMN(FN,HM,YM,ALPHA,H)
C***********************************************************************
C*   FUNCTION NAME:  CHAPMN            CPC:  SS/MOD/RTN/CHAPMN         *
C*         PURPOSE:  THIS FUNCTION COMPUTES A CHAPMAN ELECTRON DENSITY *
C*                   PROFILE.                                          *
C*                                                                     *
C*         METHOD:  1. DETERMINE THICKNESS FACTOR.                     *
C*                  2. DETERMINE CHAPMAN ELECTRON DENSITY VALUE.       *
C*                                                                     *
C*                  3. SET VALUE TO .100 IF THICKNESS FACTOR NOT VALID.*
C*      VARIABLES:  ALPHA  - RS - CORRECTION FACTOR                    *
C*                  CHAPMN - RS - THE CHAPMAN ELECTRON DENSITY         *
C*                  EVAL   - RS - EXPONENT OF THICKNESS VALUE          *
C*                  FN     - RS - DENSITY AT PERTINENT LEVEL           *
C*                  H      - RS - HEIGHT AT SIGNIFICANT LEVEL          *
C*                  HM     - RS - HEIGHT AT SIGNIFICANT LEVEL          *
C*                  S1     - RS - THICKNESS FACTOR                     *
C*                  YM     - RS - SEMI-THICKNESS OF LAYER OF IONOSPHERE*
C*                                                                     *
C***********************************************************************
C
      S1=(H-HM)/YM
      IF (S1.LT.-3.0) GO TO 20
      EVAL=dexp(dble(-S1))
      CHAPMN=FN*dexp(dble(ALPHA*(1.-S1-EVAL)))
      RETURN
   20 CONTINUE
      CHAPMN=.100
      RETURN
      END
