* -------------------------------------------------------------------- *
      SUBROUTINE col_FMT(lu,card,color,cityname)
c          read the COLORS & CITYNAME
c          handle both OLD & NEW formats
c          NEW format is compatible with HP UNIX format
      CHARACTER color(6)*6,cityname*12
      character card*80,ich*1,color_new(5)*6,shading*20
      character cities(6)*6,shads(7)*20
      character col_DOS*6
      data cities/'BLACK ','black ','RED   ','red   ','BLUE  ','blue  '/
      data shads/'Black with shading  ',
     +           'Red   with shading  ',
     +           'Black  NO  shading  ',
     +           'Red    NO  shading  ',
     +           'Shading, no contours',
     +           'Bin color shading   ',
     +           'Bin  B/W  shading   '/

      if(card(10:10).eq.':') then              !  new format
         read(card,2) color_new,shading
2        format(5(a6,4x),a20)
         color(1)=col_DOS(icolDOS(color_new(1)),1)    !  GRID
         color(2)=col_DOS(icolDOS(color_new(2)),1)    !  COUNTRIES
         color(3)=col_DOS(icolDOS(color_new(3)),1)    !  ZONES
         color(5)=col_DOS(icolDOS(color_new(5)),1)    !  MAINBEAM
c***********************************
c          CITIES (4) is different
      color(4)='Ignore'
      do 10 i=1,6
      if(color_new(4).eq.cities(i)) write(color(4),'(i1)') i-1
10    continue
      call colortab(4,color(4))
c***********************************
c          SHADING (6) is different
      color(6)='Ignore'
      do 20 i=1,7
      if(shading.eq.shads(i)) write(color(6),'(i1)') i-1
20    continue
      call colortab(6,color(6))
c***********************************
         read(lu,'(a)') card                   !  read cities file name
         nchc=lcount(card,80)
         do 30 i=nchc,1,-1
         ich=card(i:i)
         if(ich.eq.'/' .or. ich.eq.'\' .or. ich.eq.':') then
            cityname=card(i+1:nchc)
            go to 800
         end if
30       continue
      else                                     !  old format
         read (card,1) color,cityname
1        format(6(a6,3x),a)
      end if
800   if(cityname(1:1).eq.' ') cityname='receive.cty'
      return
      end
c-----------------------------------------------------------------
      subroutine colortab(idx,color)    !  set color from color table
      character color*6,colors(16)*6,ich*1,contours(7)*6,cities(6)*6
      data colors/'0=Blck','1=Red ','2=Grn ','3=Yell','4=Blue','5=Magn',
     +            '6=Cyan','7=Grey','8=DGry','9=Orng','A=Lgrn','B=Brwn',
     +            'C=Lblu','D=Pink','E=LLbl','F=Whit'/
      data contours/'0=BLCK','1=RED ','2=blck','3=red ','4=Shad',
     +              '5=Bin ','6=bin '/
      data cities/'0=BLCK','1=blck','2=RED ','3=red ','4=BLUE','5=blue'/
      ich=color(1:1)
      if(idx.eq.4) go to 50       !  Cities   are different
      if(idx.eq.6) go to 100      !  Contours are different
      do 10 i=1,16
      if(ich.ne.colors(i)(1:1)) go to 10
         color=colors(i)
         return
10    continue
      color='Ignore'
      return
50    do 60 i=1,6
      if(ich.ne.cities(i)(1:1)) go to 60
         color=cities(i)
         return
60    continue
      color='Ignore'
      return
100   do 110 i=1,7
      if(ich.ne.contours(i)(1:1)) go to 110
         color=contours(i)
         return
110   continue
      color='Ignore'
      return
      end
c-----------------------------------------------------------------
