c# decred.f
      SUBROUTINE DECRED
C
C     THIS ROUTINE CALLS FUNCTION MONITR TO READ THE CONTROL COMMANDS.
C
      common /Cnsa_noise/ noise_type,iband_width,Enoise(6),Fa_nsa(6) !  NSA noise entry
c          noise_type = 1 = man-made noise
c                     = 2 = total noise
c          iband_width= bandwidth (KHz) of measurement antenna
c          En = noise field strength (really En + Gr)
c          Fa_nsa = En - 20LogF - 10Logb +96.8   (En is really En + Gr)
      common /c_S_to_I/ i_S_to_I    !  = 1 = S/I calculation
      common /crun_directory/ run_directory
         character run_directory*50
      common /ccoeff/ coeff
      character coeff*4
      common /cdaily/ idaily
      character gainfile*50
      common /cantenna/ numants,iats(20),anttype(20),antname(20),
     +                  xfqs(20),xfqe(20),designfreq(20),antfile(20),
     +                  beammain(20),offazim(20),cond(20),diel(20),
     +                  array(30,91,20),dumant(60,91),aeff(30,20)
      character anttype*10,antname*70,antfile*24
      integer*2 iarray360(360,91,2)
      equivalence (array,iarray360)        !  for area coverage

      dimension array91(91)
      common /pantenna/ pwrkw(20),pwrdba(20)
      COMMON /RGRID/ IPROJ,PLAT,PLON,XMIN,XMAX,YYMIN,YMAX,NX,NY
      common /chours/ nhours,ihours(24)       !  which hours are active
      COMMON / ALPHA / IMON(12), IRCVR(2), ITRAN(2), MODE(13),
     A MODER(13)
      COMMON /CON /D2R, DCL, GAMA, PI, PI2, PIO2, R2D, RO, VOFL
      COMMON / CONTRL /  KTOUT(12), MONTHS(12), SUNSP(12),
     A IANTOU, INTEG, ISOUT, JDASH, JFREQ, JLONG, MAXNAM, MAXMET
      COMMON / DON /  AMIND, DMP, PMP, RSN, ATMNO,
     1                D90R, D50R, D10R, D90S, D50S, D10S
      COMMON /USERP/ IELECT(3), UHI(54,3), UFQ(54,3)
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
C SOLAR PARAMETERS
      COMMON /SOLAR/IYR,IMO,IDA,SSN,EFFQ,EFFKP,JUDAY,CHI(5),
     A TCGMT(5),PBT(5),CENT(5),EBT(5)
      COMMON /FRQ /FREL (29), FREQ,JMODE
      COMMON / ION /  IEA, IFQB, IFQE, IGRAPH, IHRE, IHRO, IHRS, JO,
     A LUFP, METHOD, MONPR, NDAY, NES, NOISE, NPAT, NPSL, NRSP, NUMO
      COMMON / METSET /  ITRUN, ITOUT, JTRUN(40), JTOUT(40)
      COMMON / OUTLAB / LABEL(11), LAYTYP(5),LABLI, LABLJ, LABLK
      COMMON / OUTPRT / LINBOT(30), LINBD(14), LINTOP(15), LINTP(14),
     A JOUT, LINBYP, LINES, LINMAX, LINTYP, LPAGES
      COMMON / TIME / IT, GMT, UTIME(24), GMTR, XLMT(24), ITIM
      COMMON /TON /ADJ, ADS, ATMO, GNOS, RCNSE, REL, SL, SLS
     1, SU, SUS, XEFF, XNOISE, XTLOS, ZNOISE, NF
      COMMON / FILES / LUO, LUI,LU25,LU26
      COMMON / PSCA / PSC(4), PSCB(4)
      COMMON /REC_DEG/ RLATD,RLONGD,TLATD,TLONGD
      common /Cmspec/ mspec      !  for Short/Long path smoothing
      dimension freqs(6)
      DIMENSION IWCRD(30)
      DIMENSION JDAY(12)
      CHARACTER NAMES(30)*10,IBUFF*75
      CHARACTER   IOFF*3,ITEMP*3 ,AOUTPT*20
      CHARACTER IRLAT*1, IRLONG*1, ITLAT*1, ITLONG*1, IRCVR*10,
     A ITRAN*10
      CHARACTER IMON*3, MODE*2, MODER*2, LABEL*5,
     A LAYTYP*2, LABLI*5, LABLJ*5, LABLK*5
      DATA JDAY/1,32,60,91,121,152,182,213,244,274,305,335/
      DATA NAMES /  'METHOD    ','MONTH     ','SUNSPOT   ',
     A 'CIRCUIT   ','SYSTEM    ','TIME      ','ANTENNA   ',
     B 'FREQUENCY ','LABEL     ','INTEGRATE ','EXECUTE   ',
     C 'ANTOUT    ','EDP       ','QUIT      ','FPROB     ',
     D 'TOPLINES  ','BOTLINES  ','OUTGRAPH  ','COMMENT   ',
     H 'COEFFS    ','AREA      ','LINEMAX   ','NOISE     ',
     + 7*'          '/
      DATA IWCRD/30*-1/,IOFF/'OFF'/
*     data numants/0/
      data freqs/2.5,5.,7.5,10.,20.,30./    !  frequencies for NSA noise input
C***********************************************************************
C
C     SUBROUTINE AERIAL MAY READ THE OPTIONAL ANTENNA PATTERN FILE (LU26
C     IF INDICATED BY THE USER ON A "ANTENNA" CONTROL LINE
C     THE PROGRAM WILL TERMINATE IF AN ERROR OCCURS (SET ITRUN = 0)
C
C     SUBROUTINE REDMAP MAY READ THE IONOSPHERIC LONG TERM DATA BASE
C     FILE (LU2) DEPENDENT ON TASK OPTION AND USER DEFINED INPUT
C     THE PROGRAM WILL TERMINATE IF AN ERROR OCCURS (SET ITRUN = 0)
C
C     ON THE FIRST CALL TO THIS SUBROUTINE CONTROL PASSES TO STATEMENT
C     LABEL 100 TO READ THE FIRST CONTROL LINE FROM LUI WHICH INITIALLY
C     IS SET TO LU5.  CONTROL THEN PASSES TO STATEMENT LABEL 105 TO
C     BRANCH AND PROCESS THE CONTROL LINE.
C
C***********************************************************************
ccc      call read_nsa_noise
      nch_run=lcount(run_directory,50)
   90 CONTINUE
C
C
      GO TO(100,150,200,250,300,350,400,450,500,550,600,650,700,750,
     A      800,850,900,950,1000,1030,1040,1045,1050,1060,
     B      9000,9050,9100), MONITOR(MAXNAM,NAMES,IBUFF,LUI)
C***********************************************************************
C     METHOD Command                                          Iline = 1
C***********************************************************************
C.....THE METHOD Command IS USED FOR PROGRAM CONTROL
  100 READ(IBUFF,1500) METHOD
      IWCRD(1)= 1
C.....TERMINATE EXECUTION IF METHOD .LE. 0 OR .GT. MAXIMUM METHOD
C.....HOWEVER, A "QUIT" Command IS REQUIRED AS THE LAST CONTROL line
      if(METHOD.gt.200) then
         i_S_to_I=1             !  S/I calculations
         METHOD=METHOD-200
      else if(METHOD.gt.100) then
         iarea=1                !  area coverage
         METHOD=METHOD-100
      end if
      mspec=0
      if(method.eq.30) then     !  Short/Long path smoothing
         mspec=1
         method=20              !  run Short path first
      end if
      if(METHOD.gt.0 .and. METHOD.le.MAXMET) go to 125
      ITRUN = 0
      GO TO 920
C.....SET RUN AND OUTPUT INDICATORS DEPENDING ON METHOD
  125 ITRUN = JTRUN(METHOD)
      ITOUT = JTOUT(METHOD)
      GO TO 90
C***********************************************************************
C     MONTH Command                                           Iline = 2
C***********************************************************************
  150 READ(IBUFF,1502) NYEAR, XMONTH
 1502 FORMAT(I5,f5.2)
      if(XMONTH.lt.1.) XMONTH=XMONTH*100.
      MONTH=XMONTH
      IDA=15
      IDA=NINT((XMONTH-FLOAT(MONTH))*100.)
      idaily=0
      if(IDA.ne.0) idaily=IDA           !  daily (use 'ccir_f2.day')
      if(IDA.le.0) IDA=15               !  default = 15th
      IMO=MONTH
      IYR=NYEAR-1900
      JUDAY=JDAY(MONTH)+IDA-1
      IWCRD(2)= 1
      GO TO 90
C***********************************************************************
C     SUNSPOT Command                                         Iline = 3
C***********************************************************************
  200 READ(IBUFF,1508) SSN,EFFQ
      EFFKP=EFFQ-2.0
      IF (EFFQ .LT. 3.0) EFFKP=EFFQ/3.0
      IWCRD(3)= 1
      GO TO 90
C***********************************************************************
C     CIRCUIT Command                                         Iline = 4
C***********************************************************************
  250 READ(IBUFF,1506) TLATD,ITLAT, TLONGD, ITLONG, RLATD, IRLAT,
     A RLONGD, IRLONG, NPSL
 1506 FORMAT(F5.2,a1,3(F9.2,A1),4X,I5)
      IWCRD(4)= 1
      IF(ITLAT .EQ. 'S') TLATD=-TLATD
      TLAT=TLATD*D2R
      IF(ITLONG .EQ. 'W') TLONGD=360.0-TLONGD
      TLONG=TLONGD*D2R
      IF(IRLAT .EQ. 'S') RLATD=-RLATD
      RLAT=RLATD*D2R
      IF(IRLONG .EQ. 'W') RLONGD=360.0-RLONGD
      RLONG=RLONGD*D2R
      if(abs(rlatd).gt.89.9) rlong=0.     !  at pole, force long=0
      if(abs(tlatd).gt.89.9) tlong=0.     !  at pole, force long=0
      GO TO 90
C***********************************************************************
C     SYSTEM Command                                          Iline = 5
C***********************************************************************
  300 READ(IBUFF,1507) PWX, XNOISE, AMIND, XLUFP, RSNX, PMPX, DMPX
 1507 FORMAT(F5.2,F5.0,F5.3,F5.0,3F5.2)
C.....SET VARIABLES TO DEFAULT VALUES IF NOT SET ON SYSTEM Command
      IWCRD(5) = 1
      IF(XNOISE.NE.0.) NOISE = XNOISE
      LUFP = XLUFP
      IF(AMIND.LE.0.0) AMIND = 3.0
      IF(LUFP.LE.0) LUFP = 90.
ccc      IF(RSNX.GT.0.) RSN = RSNX
ccc      IF(PMPX.NE.0.) PMP = PMPX
ccc      IF(DMPX.NE.0.) DMP = DMPX
      RSN = RSNX
      PMP = PMPX
      DMP = DMPX
      GO TO 90
C***********************************************************************
C     TIME Command                                            Iline = 6
C***********************************************************************
  350 READ(IBUFF,1500) IHRO, IHRE, IHRS, ITIM
      IWCRD(6)= 1
C.....SET HOUR INCREMENT TO THE DEFAULT VALUE OF ONE (IF .LE. 0)
      IF(IHRS.LE.0) IHRS = 1
c          New TIME concept by Greg Hand 5/17/93
c          Time may now run around midnight (e.g. 22 to 04)
      istart=IHRO
      if(istart.eq.0) istart=24
      iend=IHRE
      if(IHRE.lt.istart) iend=iend+24
      nhours=0
      do 351 ihr=istart,iend,IHRS
      jhr=ihr
      if(jhr.gt.24) jhr=jhr-24
      nhours=nhours+1
351   ihours(nhours)=jhr
      GO TO 90
C***********************************************************************
C     ANTENNA Command                                         Iline = 7
C***********************************************************************
  400 CONTINUE
      READ(IBUFF,1510) IAT,iantr,minfreq,maxfreq,designfreq(iantr),
     +                 antfile(iantr),beammain(iantr),pwrkw(iantr)
 1510 FORMAT(4I5,f10.3,1x,a21,1x,f5.1,f10.4)
      iats(iantr)=iat
      if(iat.eq.1) then        !  transmitter
         if(pwrkw(iantr).le.0.) pwrkw(iantr)=1.
         pwrdba(iantr)=30. + 10.*alog10(pwrkw(iantr))  !  convert to dB
      end if
      if(iantr.gt.numants) numants=iantr
      write(gainfile,'(4hGAIN,i2.2,4h.DAT)') iantr
      open(lu26,file=run_directory(1:nch_run)//'\'//gainfile,
     +     status='old',form='formatted',err=9900)
      rewind(lu26)
      read(lu26,401) anttype(iantr),antname(iantr)
401   format(a10,a70)
      read(lu26,402) xfqs(iantr),xfqe(iantr),
     +           beammain(iantr),offazim(iantr),cond(iantr),diel(iantr)
402   format(2f5.0,2f7.2,2f10.5)
      if(offazim(iantr).eq.-999.) then      !  area coverage
c          change made 8/31/95 for Windows version because gains are
c          stored in the correct arrays in antcalc
ccc         read(lu26,'(25x,f10.3)') aeff(1,iantr)
ccc         do 405 iazim=1,360
ccc         read(lu26,403) (array91(ielev),ielev=1,91)
ccc403      format(9x,10f7.3)
ccc         do 405 ielev=1,91              !  store in INTEGER*2 to save space
ccc         gain=array91(ielev)
ccc         if(gain.gt. 300.) gain= 300.
ccc         if(gain.lt.-300.) gain=-300.
ccc405      iarray360(iazim,ielev,iantr)=gain*100.
      else
         do 410 ifreq=1,30
410      read(lu26,411) AEFF(ifreq,iantr),(array(ifreq,j,iantr),j=1,91)
411      format(2x,f6.2,(t10,10f7.3))
      end if
      close(lu26)
      GO TO 90
C***********************************************************************
C     FREQUENCY Command                                       Iline = 8
C***********************************************************************
  450 continue
      do 451 i=1,29
  451 frel(i) = 0.0
      READ(IBUFF,1508) (FREL(IFK),IFK=1,11)
      IWCRD(8)= 1
C.....SET FREL(14) AS A FLAG
      IF(FREL(1).eq.0.) then
         IF(FREL(2).le.0.) then
            FREL(14) = -1.    !  calc freq complement in FRQCOM each hour
         else
            FREL(14) = -10.   !  use FOT as first freq for each hour
         end if
      else
         FREL(14) = 1.        !  set flag to use input data
      end if
      GO TO 90
C***********************************************************************
C     LABEL Command                                           Iline = 9
C***********************************************************************
  500 READ(IBUFF,1504) ITRAN(1), ITRAN(2), IRCVR(1), IRCVR(2)
      IWCRD(9)= 1
      GO TO 90
C***********************************************************************
C     INTEGRATE Command                                       Iline = 10
C***********************************************************************
C.....THE "INTEGRATE" Command INDICATES WHAT KIND OF INTEGRATION IS USED
C.....INTEG = -1 FOR ALWAYS GAUSSIAN,
C.....INTEG .GE. 0 FOR MODEL SEGMENT WHEN NO F1 LAYER
  550 READ(IBUFF,1509) ITEMP
      INTEG = 1
      IF(ITEMP .EQ. IOFF) GO TO 90
      READ(IBUFF,1500) INTEG
      GO TO 90
C***********************************************************************
C     EXECUTE Command                                         Iline = 11
C***********************************************************************
C.....THE "EXECUTE" Command CAUSES PROGRAM EXECUTION
  600 continue
      IF((IWCRD(2).EQ.0).AND.(IWCRD(3).EQ.0)) GO TO 610
      CALL REDMAP(SSN,IMO)
      if(idaily.ne.0) CALL REDAILY(SSN,IMO,IDA)    !  read daily F2 coeff
  610 IRED = 1
ccc      WRITE(*,'(2X,A17,I2)') 'EXECUTING METHOD ',METHOD
      IWCRD(2)=0
      IWCRD(3)=0
      GO TO 920
C***********************************************************************
C     ANTOUT Command                                          Iline = 12
C***********************************************************************
C.....THE "ANTOUT" Command INDICATES THE ANTENNA PATTERNS CREATED
C.....ARE TO BE WRITTEN ON A FILE FOR LATER USE
  650 CONTINUE
ccc      READ(IBUFF,1509) ITEMP,AOUTPT
ccc      IF(ITEMP .EQ. IOFF) GO TO 660
ccc      IANTOU = 1
ccc      OPEN(LU25,FILE=AOUTPT,STATUS='OLD',ACCESS='SEQUENTIAL',
ccc     A FORM='UNFORMATTED')
ccc      GO TO 90
ccc  660 CLOSE(25)
ccc      IANTOU = 0
      GO TO 90
C***********************************************************************
C     EDP Command                                             Iline = 13
C***********************************************************************
C.....THE "EDP" Command ALLOWS THE USER TO READ IN AND USE AN EXTERNAL
C.....ELECTRON DENSITY PROFILE FOR A SPECIFIED SAMPLE AREA
  700 CONTINUE
      READ(IBUFF,1530) JSAMP, ITEMP
C.....ASSUME THE DEFAULT SAMPLE AREA = 1
C.....IF THE SPECIFIED SAMPLE AREA ISN"T 1, 2 OR 3
      IF(JSAMP .lt. 1 .or. JSAMP .gt. 3 )  JSAMP = 1
      IF(ITEMP .NE. IOFF) GO TO 740
C.....USE THE INTERNAL ELECTRON DENSITY PROFILE INSTEAD OF THE ONE READ
      IELECT(JSAMP) = 0
      GO TO 90
C.....READ THE EXTERNAL ELECTRON DENSITY PROFILE
  740 IELECT(JSAMP) = 1
      READ(LUI,1528) (UHI(I,JSAMP),I=1,54)
      READ(LUI,1528) (UFQ(I,JSAMP),I=1,54)
 1528 FORMAT(8F10.2)
      GO TO 90
C***********************************************************************
C     QUIT Command                                            Iline = 14
C***********************************************************************
C.....THE "QUIT" Command IS USED TO TERMINATE PROGRAM EXECUTION
  750 CONTINUE
      ITRUN = 0
      GO TO 920
C***********************************************************************
C     FPROB Command                                           Iline = 15
C***********************************************************************
C.....THE "FPROB" Command ALLOWS THE USER TO ALTER THE PREDICTED CRITICAL
C.....FREQUENCIES. EACH CRITICAL FREQUENCY IS MULTIPLIED BY PSC(N),
C.....WHERE N = 1 IS E, N=2 IS F1, N=3 IS F2 AND N=4 IS ES.
C.....(N O T E -  E AND F2 ARE NECESSARY)
  800 CONTINUE
      READ(IBUFF,1509) ITEMP
      IF(ITEMP .NE. IOFF) THEN
      do 801 i=1,4
  801 psc(i) = 0.0
      READ(IBUFF,1508) PSC
      IF(PSC(1).LE.0.) PSC(1) = PSCB(1)
      IF(PSC(2).LT.0.) PSC(2) = PSCB(2)
      IF(PSC(3).LE.0.) PSC(3) = PSCB(3)
      IF(PSC(4).LT.0.) PSC(4) = PSCB(4)
      ELSE
      DO 830 I = 1,4
  830 PSC(I) = PSCB(I)
      END IF
      GO TO 90
C***********************************************************************
C     TOPLINES Command                                        Iline = 16
C***********************************************************************
C.....THE "TOPLINES" Command ALLOWS THE USER TO SPECIFY THE LINES PRINTED
C     IN SUBROUTINE OUTTOP (WHENEVER METHOD = 23)
  850 CONTINUE
      READ(IBUFF,1509) ITEMP
      LINTYP = 0
      do 851 i =1,14
  851 lintp(i)=0
      IF(ITEMP .EQ. IOFF) GO TO 90
      LINTYP = 1
      READ(IBUFF,1500) LINTP
      GO TO 90
C***********************************************************************
C     BOTLINES Command                                        Iline = 17
C***********************************************************************
C.....THE "BOTLINES" Command ALLOWS THE USER TO SPECIFY THE LINES PRINTED
C     IN SUBROUTINE OUTBOD (WHENEVER METHOD = 23)
  900 CONTINUE
      READ(IBUFF,1509) ITEMP
      LINBYP = 0
      do 901 i=1,14
  901 linbd(i)=0
      IF(ITEMP .EQ. IOFF) GO TO 90
      LINBYP = 1
      READ(IBUFF,1500) LINBD
      GO TO 90
C***********************************************************************
C     OUTGRAPH Command                                          Iline=18
C***********************************************************************
C.....THE "OUTGRAPH" Command ALLOWS THE USER TO REQUEST OUTPUT OF SEVERAL
C.....DIFFERENT METHODS THAT HEVE OUTPUT OPTIONS 3 OR 4
  950 CONTINUE
      ISOUT=0
      READ(IBUFF,1509) ITEMP
      do 951 i=1,12
  951 ktout(i)=0
      IF(ITEMP .EQ. IOFF) GO TO 90
      ISOUT=1
      READ(IBUFF,1500) (KTOUT(I),I=1,12)
      GO TO 90
C***********************************************************************
C     COMMENT Command                                           Iline=19
C***********************************************************************
C.....COMMENT Command IS A DO NOTHING Command
 1000 CONTINUE
ccc      write(LUO,'(11h COMMENT   ,a)') IBUFF
      if(IBUFF(1:4).eq.'FREQ') write(LUO,'(11h COMMENT   ,a)') IBUFF
      if(IBUFF(1:4).eq.'GROU') write(LUO,'(11h COMMENT   ,a)') IBUFF
      GO TO 90
C***********************************************************************
C     COEFFS  CARD                                              Iline=21
C***********************************************************************
C.....COEFFS card allows either CCIR or URSI coefficients
 1030 coeff=IBUFF(1:4)
      if(coeff.ne.'URSI') coeff='CCIR'
      GO TO 90
C***********************************************************************
C     AREA    CARD                                              Iline=22
C***********************************************************************
C.....AREA    card reads area coverage center and limits
1040  nx=0
      ny=0
      READ(IBUFF,1041) plat,plon,xmin,xmax,yymin,ymax,nx,ny,itype
1041  format(6F10.0,3i5)
      if(nx.eq.0) nx=5
      if(ny.eq.0) ny=5
      iproj=7                 !  great circle projection
      if(itype.ne.0) iproj=8  !  lat/lon for GRIB format
      iarea=1
      GO TO 90
C***********************************************************************
C     LINEMAX CARD                                              Iline=23
C***********************************************************************
C.....LINEMAX card reads LINMAX which is maximum lines per page
1045  READ(IBUFF,'(i5)') LINMAX
      if(LINMAX.lt.30) LINMAX=55
      GO TO 90
C***********************************************************************
C***********************************************************************
C     NOISE   card  (new 8/20/2007)                             Iline=24
C***********************************************************************
c         Ability to add noise measurements was done 8/20/2007 for NSA
1050  READ(IBUFF,1051) noise_type,iband_width,Enoise   !  band_width and En
1051  format(2i5,6f10.2)
      if(iband_width.eq.0) iband_width=1    !  default to 1 KHz
      b=float(iband_width)*1000.            !  convert KHz to Hz
      do 2050 i=1,6
2050  Fa_nsa(i)=Enoise(i) - 20.*alog10(freqs(i)) - 10.*alog10(b) +96.8
      GO TO 90
C***********************************************************************
 1060 CONTINUE
      GO TO 90
C  ERROR  IN THE INPUT - Command NAME NOT FOUND IN THE Command NAME LIST
 9000 WRITE(LUO,1520)
      ITRUN = 0
      RETURN
 9050 ITRUN = 0
      RETURN
 9100 WRITE(LUO,1532)IBUFF
      ITRUN = 0
  920 RETURN
9900  write(*,9901) gainfile
9901  format(' Could not OPEN file=',a)
      stop 'OPEN error in decred at 9900'
C.....FORMAT SPECIFICATIONS
 1401 FORMAT(8A10)
 1402 FORMAT(' ','MONTH =',I5,5X,'MONTH INDEX =',I5)
 1403 FORMAT(' ',8A10,5X,'Line = ',I5)
 1406 FORMAT(' ','SSN = ',F7.2)
 1500 FORMAT(14I5)
 1504 FORMAT(4A10)
 1508 FORMAT(13F5.2)
 1509 FORMAT(A3,1X,A20)
 1514 FORMAT(I5,3(F5.2,A1,4X),F5.0,6F5.2)
 1516 FORMAT(I5,3(F5.2,2F5.1))
 1518 FORMAT(I5,3F5.2,F5.1)
 1520 FORMAT(///,' NAME IDENTIFIER ERRORS DETECTED ON INPUT FILE')
 1530 FORMAT(I5,A10)
 1532 FORMAT(2X,'ERROR ON INPUT',/,70A1)
 1540 FORMAT(2I5,1X,A20,34X,I5)
      END
c-------------------------------------------------------
