c# dens.f
      subroutine DENS(TINF,HEIGHT,TEMP,AVH)
C***********************************************************************
C*         PURPOSE: COMPUTES THE DENSITY AT A CERTAIN ALTITUDE AND     *
C*                  INPUT TINF.  IT IS USED IN CALCULATING SCALE       *
C*                  HEIGHT.                                            *
C*     SUBPROGRAMS                                                     *
C*         CALLED:  TATR - TO CALCULATE A FIRST ESTIMATE OF THE F2     *
C*                         LAYER THICKNESS                             *
C***********************************************************************
C
      DIMENSION DEN(5),DENB(5),H(5),QO(4),RMASS(5)
      SAVE
C
      DATA XMIL/1.E-3/
      DATA HKM/1000./
      DATA RTM90/21.965E-6/
      DATA Z100/100./
      DATA RMASS/28.0134,31.9988,15.9994,4.00260,39.9480/
      DATA Z90,B0,B1,B2,B3,B4,B5,B6/90.,28.82678,-7.40066E-2,-1.19407E-2
     &   ,+4.51103E-4,-8.21895E-6,+1.07561E-5,-6.97444E-7/
      DATA AN,AVM0,QO/6.02257E+26,28.960,0.7811,0.20955,
     &   0.0093432,6.1471E-6/
      DATA RO,RB/6356766.,6481766./
      DATA GMB/1.134449/
      DATA FOF90/0.1806478/
      DATA ALPHA/-0.38/
      DATA AMU/1.6605313E-27/
      DATA H1,DZA/125.,6.25/
      DATA HGHT,TEX,FB,DENB/8*0.0/
C
C......................................................................
C     BEGIN EXECUTION
C......................................................................
C
      F2=0.0
      TB=0.0
      IEXIT=0
      DZX=5.
      IF(HEIGHT.LE.Z100) THEN
         DZX=0.5*(HEIGHT-Z90)
         IEXIT=1
      ENDIF
C
      F0=FOF90
      F1=FOF90
      F2=FOF90
      FB=0
      HGHT=Z90
C
C
      DO 40 J=1,2
         F1=F2
         HGHT=HGHT+DZX
         DZI=HGHT-Z90
         RBR=RB/(HKM*HGHT+RO)
         TEMP=TATR(TINF,HGHT,DTDR)
         F2=GMB*RBR*RBR/TEMP
         IF(HGHT.GE.Z90)  then
            AVM=B0+DZI*(B1+DZI*(B2+DZI*(B3+DZI*(B4+DZI*(B5+DZI*B6)))))
         else
C
            AVM=B0+DZI*B1
            IF(AVM.GT.AVM0) AVM=AVM0
         endif
C
         F2=AVM*F2
40    CONTINUE
C
      FB=FB+(((F0+(4.*F1)+F2)*DZX)/3.)
      AVH=DZI/FB
      AV2=1./F2
      DENM=(RTM90*AVM/TEMP)*dexp(dble(-FB))
      XNM=AN*DENM
      DENT=XNM/AVM
      DEN0=XNM/AVM0
      XNM=DENT-DEN0
      DMDR=B1+DZI*(2.*B2+DZI*(3.*B3+DZI*(4.*B4+DZI*(5.*B5+DZI*6.*B6))))
      DNDR=-XMIL*DENM*(F2+(DTDR/TEMP)+(DMDR/AVM))
C
      DO 50 J=1,4
         DEN(J)=QO(J)*DEN0
50    CONTINUE
C
      DEN(5)=DEN(3)
      DEN(3)=XNM+XNM
      DEN(2)=DEN(2)-XNM
C
      DO 60 J=1,5
         H(J)=AVM*AV2/RMASS(J)
         DENB(J)=DEN(J)*TEMP
60    CONTINUE
C
      TB=TEMP
      FB=0
      F2=F2/AVM
      IF(IEXIT.EQ.1) return
C
      DZX=DZA
      IF (HEIGHT.LT.HGHT) DZX=-DZA
80    CONTINUE
C
      DZZ=0.5*(HEIGHT-HGHT)
      IF((DZX*DZX).GE.(DZZ*DZZ)) then
         DZX=DZZ
         IEXIT=1
      endif
C
      F0=F2
C
      DO 100 J=1,2
         F1=F2
         HGHT=HGHT+DZX
         RBR=RB/(HKM*HGHT+RO)
         TEMP=TATR(TINF,HGHT,DTDR)
         F2=GMB*RBR*RBR/TEMP
100   CONTINUE
C
      FB=FB+(((F0+(4.*F1)+F2)*DZX)/3.)
      RAT=((100.*TEMP)/TINF)-50.
      IF((RAT.LE.DZA).OR.(HGHT.LE.H1)) RAT=DZA
      IF(DZZ.LT.0.) RAT=-RAT
      DZX=RAT
      IF(IEXIT.EQ.0) GO TO 80
      DENT=0
      DENM=0
      DNDR=0
C
      DO 110 J=1,5
         FI=FB*RMASS(J)
         H(J)=1./(F2*RMASS(J))
         DEN(J)=(DENB(J)/TEMP)*dexp(dble(-FI))
         IF(J.EQ.4 .AND. TB.NE.0.0) DEN(J)=DEN(J)*((TB/TEMP)**ALPHA)
         DENT=DENT+DEN(J)
         DENM=DENM+DEN(J)*RMASS(J)
         DNDR=DNDR-DEN(J)*RMASS(J)/H(J)
110   CONTINUE
C
      AVM=DENM/DENT
      DZI=HGHT-Z100
      AVH=DZI/(FB*AVM)
C
      RETURN
      END
