c# elayer.f
      SUBROUTINE ELAYER(IFLAG,FOE,HE)
C***********************************************************************
C* SUBROUTINE NAME:  ELAYER            CPC:  SS/MOD/RTN/ELAYER         *
C*         VERSION:  88-II            DATE:  16 MAR 88                 *
C*                                                                     *
C*         PURPOSE:  THIS SUBROUTINE CALCULATES THE FREQUENCY OF THE   *
C*                   ORDINARY RAY AND THE HEIGHT OF THE ELECTRON DEN-  *
C*                   SITY MAXIMUM IN THE E LAYER.                      *
C*                                                                     *
C*         CALLING                                                     *
C*       ARGUMENTS:  IFLAG,FOE,HE                                      *
C*                                                                     *
C*  ABBREVIATIONS:  NONE                                               *
C*                                                                     *
C*  COMMON BLOCKS:  F6PARM                                             *
C*                                                                     *
C* FILES ACCESSED:  NONE                                               *
C*                                                                     *
C*         METHOD:  1.  DETERMINE WHETHER A SOLAR-DRIVEN OR AN AURORAL-*
C*                      DRIVEN OR A SOLAR/AURORAL-DRIVEN E LAYER EXISTS*
C*                  2.  IF AURORAL,                                    *
C*                    - COMPUTE AURORAL ZONE BOUNDARIES                *
C*                    - COMPUTE LOCATION OF MAX IONIZATION IN AUR. ZONE*
C*                      BASED ON Q INDEX AND MAGNETIC LOCAL TIME.      *
C*                    - COMPUTE IONIZATION AT EDGES OF AUR. ZONE       *
C*                    - LINEARLY INTERPOLATE IONIZATION AT GRIDPOINT   *
C*                    - COMPUTE HEIGHT AT GRIDPOINT BY INTERPOLATION   *
C*                  3.  IF SOLAR,                                      *
C*                    - COMPUTE FREQUENCY AND HEIGHT USING THE CCIR    *
C*                      METHOD                                         *
C*                  4.  IF AURORAL AND SOLAR, COMBINE AURORAL AND SOLAR*
C*                      CONTRIBUTIONS BASED ON HEIGHTS                 *
C*                                                                     *
C*        REMARKS:  NONE                                               *
C*                                                                     *
C*     REFERENCES:  1.  ICED-III SYSTEM DOCUMENTATION                  *
C*                  2.  SPERRY FORTRAN-77(ASCII) PRM                   *
C*                  3.  AFGWC FORM 10 DX-50194                         *
C*                  4.  AFGWC FORM 10 DX-60096                         *
C*                                                                     *
C* COMMON /F6PARM/IYR,IMO,IDA,TIME,DAYJUL,EFFSSN,EFFQ,EFFKP,     *
C*                GGLAT,GGLON,CGLAT,CGLON,TCGM                         *
C*    IYR    IS  YEAR OF DATA SET                                      *
C*    IMO    IS  MONTH OF DATA SET                                     *
C*    IDA    IS  DAY OF DATA SET                                       *
C*    TIME   RS  UNIVERSAL TIME IN HH.HH OF DATA SET                   *
C*    DAYJUL RS  JULIAN DATE OF DATA SET (REAL)                        *
C*    EFFSSN RS  EFFECTIVE SUNSPOT NUMBER                              *
C*    EFFQ   RS  EFFECTIVE AURORAL Q VALUE                             *
C*    EFFKP  RS  EFFECTIVE PLANETARY K INDEX                           *
C*    GGLAT  RS  GEOGRAPHIC LATITUDE OF A GRIDPOINT                    *
C*    GGLON  RS  GEOGRAPHIC LONGITUDE OF A GRIDPOINT                   *
C*    CGLAT  RS  CORRECTED GEOMAGNETIC LATITUDE OF A GRIDPOINT         *
C*    CGLON  RS  CORRECTED GEOMAGNETIC LONGITUDE OF A GRIDPOINT        *
C*    TCGM   RS  CORRECTED GEOMAGNETIC TIME OF A GRIDPOINT             *
C*                                                                     *
C*LOCAL VARIABLES:  IFLAG  - IS - FLAG QUALIFIER USED TO SELECT THE    *
C*                                PROCESSING ALGORITHM                 *
C*                  BASHGT - RS - BASE HEIGHT OF E LAYER               *
C*                  CGEQAT - RS - AURORAL ZONE EQUATORIAL CG LATITUDE  *
C*                  CGMIDL - RS - AURORAL ZONE MID POINT  CG LATITUDE  *
C*                  CGOVAL - RS - AURORAL ZONE AVERAGE LOCATION        *
C*                  CGPOLR - RS - AURORAL ZONE POLEWARD BOUNDARY       *
C*                  DR     - RS - DEG-RADIAN CONVERSION CONSTANT       *
C*                  FOE    - RS - FOE FOR AURORAL ZONE - AURORAL E ONLY*
C*                  FOE1   - RS - FOE FOR AURORAL ZONE - SOLAR/AURORAL *
C*                  FOE2   - RS - FOE FOR MID LATITUDE - SOLAR/AURORAL *
C*                  FOEA   - RS - APPROXIMATION VALUE OF FOE -1ST GUESS*
C*                  FOEE   - RS - INTERMEDIATE PRODUCT IN FOE CALC.    *
C*                  FOEP   - RS - 1ST GUESS FOR POLAR LOCATION         *
C*                  HE     - RS - HEIGHT OF THE E LAYER                *
C*                  HE1    - RS - TEMPORARY VALUE OF HE                *
C*                  HE2    - RS - TEMPORARY VALUE OF HE                *
C*                  HGTEGE - RS - TEMPORARY VALUE OF HEIGHT OF E LAYER *
C*                  HGTMAX - RS - TEMPORARY VALUE OF MAXIMUM HEIGHT    *
C*                  RATIO  - RS - RATIO OF AURORAL TO SOLAR  HEIGHTS   *
C*                  SLOPEE - RS - SLOPE OF EQUATORIAL SIDE OF E LAYER  *
C*                  SLOPEP - RS - SLOPE OF POLAR SIDE OF E LAYER       *
C*                  SLOPOP - RS - SLOPE OF HE MAX TO HE EDGE           *
C* (I=INTEGER, R=REAL, C=CHARACTER, S=SCALAR, V=VECTOR, A=ARRAY)       *
C*                                                                     *
C*   SETC OPTIONS:  NONE USED                                          *
C*                                                                     *
C*     SUBPROGRAMS                                                     *
C*         CALLED:  QOVAL1 - COMPUTES AURORAL OVAL POSITION            *
C*                  FECCIR - COMPUTES SOLAR E LAYER USING CCIR METHOD  *
C*                                                                     *
C*     SUBPROGRAM                                                      *
C*      CALLED BY:  FIELD6                                             *
C*                                                                     *
C*PROGRAM WRITTEN:  JAN 86 - NATIONAL GEOPHYSICAL DATA CENTER          *
C*        UPDATES:  JUN 86 - AFGWC/SDDE - UPDATED DOCUMENTATION        *
C*                  AUG 87 - NATIONAL GEOPHYSICAL DATA CENTER (87-I)   *
C*                  MAR 88 - NGDC (88-II) CCIR SOLAR E LAYER           *
C*                                                                     *
C***********************************************************************
      INTEGER IDA
      INTEGER IMO
      INTEGER IYR
      REAL CGLAT
      REAL CGLON
      REAL DAYJUL
      REAL EFFKP
      REAL EFFQ
      REAL EFFSSN
      REAL GGLAT
      REAL GGLON
      REAL TCGM
      REAL TIME
      COMMON/F6PARM/IYR,IMO,IDA,TIME,DAYJUL,EFFSSN,EFFQ,EFFKP,
     +            GGLAT,GGLON,CGLAT,CGLON,TCGM
      INTEGER IFLAG
      REAL BASHGT
      REAL CGEQAT
      REAL CGMIDL
      REAL CGOVAL
      REAL CGPOLR
      REAL DR
      REAL FOE
      REAL FOE1
      REAL FOE2
      REAL FOEA
      REAL FOEE
      REAL FOEP
      REAL HE
      REAL HE1
      REAL HE2
      REAL HGTEGE
      REAL HGTMAX
      REAL RATIO
      REAL SLOPEE
      REAL SLOPEP
      REAL SLOPOP
      DATA DR/0.0174532/
 
C......................................................................
C     SOLAR E ONLY?                                                   .
C......................................................................
      IF ( IFLAG.EQ.6 ) GO TO 200
 
C**********************************************************************
C**********************************************************************
C     BEGIN AURORAL E-LAYER ANALYSIS                                  *
C**********************************************************************
C**********************************************************************
C......................................................................
C     AURORAL ZONE BOUNDARIES                                         .
C......................................................................
      CALL QOVAL1(EFFQ,TCGM,CGPOLR,CGMIDL,CGEQAT)
 
C......................................................................
C     FOEA IS MAX IONIZATION                                          .
C......................................................................
      FOEA=1.4*EFFQ-1.0
      IF(EFFQ.GT.4.2) FOEA = 3.2 + (0.4*EFFQ)
      IF(EFFQ.LE.2.7) FOEA = 2.5 + (0.11111111*EFFQ)
C......................................................................
C     FIRST CUT AT REPLACING MAGNETIC LOCAL TIME VARIATIONS (BASED    .
C     ON LIMITED CHATANIKA)                                           .
C......................................................................
      IF (TCGM.LT.22.0.AND.TCGM.GT.18.0) FOEA=(1.-(TCGM-18.)/10.)*FOEA
      IF (TCGM.GT.22.0) FOEA=0.8*FOEA
      IF (TCGM.LT.2.0) FOEA=0.8*FOEA
C......................................................................
C     CGOVAL = LOCATION OF MAX IONIZATION                             .
C......................................................................
      CGOVAL = CGMIDL
      IF ( EFFQ.GT.3.0 ) THEN
        IF ( (TCGM.GT.00.0).AND.(TCGM.LE.06.0) )
     +    CGOVAL = CGMIDL + (-2.0*SIN(30.0*TCGM*DR))*(EFFQ/4.0)
        IF ( (TCGM.GE.21.0).AND.(TCGM.LT.24.0) )
     +    CGOVAL = CGMIDL + SIN( (TCGM-21.0)*60.0*DR )
      ENDIF
 
C.......................................................................
C     COMPUTE FOE IF AURORAL, FOE1 IF BOTH AURORA AND SOLAR,           .
C     BASED ON GRIDPOINT POSITION RELATIVE TO MAX IONIZATION LOCATION  .
C.......................................................................
      IF ( CGLAT.LE.CGOVAL ) THEN
        FOEE=.6*FOEA
        IF(TCGM.LT.22.0.AND.TCGM.GT.18.0)FOEE=(0.6-(TCGM-18.0)/10.)*FOEA
        IF (TCGM.GT.22.0) FOEE=(.2+(TCGM-22.0)/10.)*FOEA
        IF (TCGM.LT.2.0) FOEE=(.4+TCGM/10.)*FOEA
        SLOPEE = (FOEA-FOEE)/(CGOVAL-CGEQAT)
        FOE1 = FOEA + SLOPEE*(CGLAT-CGOVAL)
      ELSE
        FOEP=.6*FOEA
        SLOPEP = (FOEA-FOEP)/(CGOVAL-CGPOLR)
        FOE1 = FOEA + SLOPEP*(CGLAT-CGOVAL)
      ENDIF
 
C......................................................................
C     COMPUTE HE IF AURORA ONLY,                                      .
C     COMPUTE HE1 IF BOTH AURORAL AND SOLAR                           .
C......................................................................
      IF(FOEA.LT.2.) BASHGT=160.
      IF(FOEA.GE.2.0.AND.FOEA.LT.3.5) BASHGT=160.-(FOEA-2.0)*35.
      IF(FOEA.GE.3.5.AND.FOEA.LE.9.0) BASHGT=120.-(FOEA-3.0)*10.
      HGTMAX=BASHGT+25.
      HGTEGE=HGTMAX+10.
      IF ( CGLAT.GT.CGOVAL ) THEN
        SLOPOP = (HGTMAX-HGTEGE) / (CGOVAL-CGPOLR)
        HE1 = HGTMAX + SLOPOP*(CGLAT-CGOVAL)
      ELSE
        SLOPOE = (HGTMAX-HGTEGE) / (CGOVAL-CGEQAT)
        HE1 = HGTMAX + SLOPOE*(CGLAT-CGOVAL)
      ENDIF
C......................................................................
C     IF AURORAL E ONLY, RETURN. IF NOT, PLOD ON.                     .
C......................................................................
      IF(IFLAG.EQ.1.OR.IFLAG.EQ.5) THEN
        FOE = FOE1
        HE = HE1
        RETURN
      ENDIF
 
C......................................................................
C......................................................................
C     COMPUTE SOLAR E LAYER USING THE CCIR METHOD                     .
C......................................................................
C......................................................................
200   CONTINUE
      CALL FECCIR( IYR,IMO,IDA,TIME,GGLAT,GGLON,EFFSSN,FOE2,HE2 )
 
C......................................................................
C     IF SOLAR ONLY, RETURN. IF NOT, CONTINUE ON                      .
C......................................................................
      IF ( IFLAG.EQ.6 ) THEN
        FOE = FOE2
        HE = HE2
        RETURN
      ENDIF
 
C......................................................................
C......................................................................
C     AURORAL AND SOLAR SECTION                                       *
C     COMPUTE AVERAGE E-LAYER HEIGHT IF WITHIN 10 KM.  IF NOT,        *
C     USE AURORAL (IF AT LEAST 10% HIGHER THAN SOLAR).                *
C     OTHERWISE, USE SOLAR CALCULATIONS                               *
C......................................................................
C......................................................................
      IF (ABS(HE1-HE2).LE.10.) THEN
        HE=(HE1+HE2)*0.5
        FOE=( (1.5*(FOE1**4)) + (FOE2**4) )**.25
      ELSE
        RATIO=FOE2/FOE1
        IF (RATIO.GE.1.1) THEN
          HE=HE2
          FOE=FOE2
        ELSE
          HE=HE1
          FOE=FOE1
        ENDIF
      ENDIF
      RETURN
      END
 
