c# eqboun.f
      SUBROUTINE EQBOUN(TPC,PHIA,EQBN)
C***********************************************************************
C* SUBROUTINE NAME:  EQBOUN            CPC:  SS/MOD/RTN/EQBOUN         *
C*         VERSION:  88-II            DATE:  31 AUG 86                 *
C*                                                                     *
C*         PURPOSE:  THIS SUBROUTINE CALCULATES THE EQUATORWARD BOUN-  *
C*                   DARY OF THE AURORAL TROUGH.                       *
C*                                                                     *
C*         CALLING                                                     *
C*       ARGUMENTS:  TPC, PHIA, EQBN                                   *
C*                                                                     *
C*  ABBREVIATIONS:  NONE                                               *
C*                                                                     *
C*  COMMON BLOCKS:  F6PARM                                             *
C*                                                                     *
C* FILES ACCESSED:  NONE                                               *
C*                                                                     *
C*         METHOD:  1. CALCULATES THE NUMBER OF HOURS BETWEEN 0300LT   *
C*                     AND THE GRIDPOINT                               *
C*                  2. CALCULATES THE WIDTH OF THE TROUGH              *
C*                  3. DETERMINES THE POSITION OF THE TROUGH WALL      *
C*                                                                     *
C*        REMARKS:  NONE                                               *
C*                                                                     *
C*     REFERENCES:  1.  ICED-III SYSTEM DOCUMENTATION                  *
C*                  2.  SPERRY FORTRAN-77(ASCII) PRM                   *
C*                  3.  AFGWC FORM 10 DX-50194                         *
C*                  3.  AFGWC FORM 10 DX-60096                         *
C*                                                                     *
C* GLOBAL VARIABLES :                                                  *
C*  COMMON /F6PARM/ IYR,IMO,IDA,TIME,DAYJUL,EFFSSN,EFFQ,EFFKP,   *
C*                  GGLAT,GGLON,CGLAT,CGLON,TCGM                       *
C*     IYR    IS    YEAR OF THE DATA SET                               *
C*     IMO    IS    MONTH OF DATA SET                                  *
C*     IDA    IS    DAY OF DATA SET                                    *
C*     DAYJUL RS    JULIAN DAY OF DATA SET                             *
C*     TCGM   RS    CORRECTED GEOMAGNETIC TIME OF A GRIDPOINT          *
C*     TIME   RS    UNIVERSAL TIME IN HH.HH OF DATA SET                *
C*     EFFSSN RS    EFFECTIVE SUNSPOT NUMBER                           *
C*     EFFQ   RS    EFFECTIVE AURORAL Q VALUE                          *
C*     EFFKP  RS    EFFECTIVE PLANETARY K INDEX                        *
C*     GGLAT  RS    GEOGRAPHIC LATITUDE OF A GRIDPOINT                 *
C*     GGLON  RS    GEOGRAPHIC LONGITUDE OF A GRIDPOINT                *
C*     CGLAT  RS    CORRECTED GEOMAGNETIC LATITUDE OF A GRIDPOINT      *
C*     CGLON  RS    CORRECTED GEOMAGNETIC LONGITUDE OF A GRIDPOINT     *
C*                                                                     *
C*LOCAL VARIABLES:  DELTAT - RS - DIFFERENCE BETWEEN 0300LT AND TPC    *
C*                  EQBN   - RS - LOCATION OF THE EQUATORWARD BOUNDARY *
C*                  PHIA   - RS - LOCATION OF THE TROUGH WALL          *
C*                  PI     - RS - 3.14159265 CONSTANT                  *
C*                  R      - RS - INTERMEDIATE CALCULATION VARIABLE    *
C*                  TPC    - RS - TIME OF THE RUN
C*                  WIDTH  - RS - WIDTH OF THE TROUGH                  *
C* (I=INTEGER, R=REAL, C=CHARACTER, S=SCALAR, V=VECTOR, A=ARRAY)       *
C*                                                                     *
C*   SETC OPTIONS:  NONE USED                                          *
C*                                                                     *
C*     SUBPROGRAMS                                                     *
C*         CALLED:  NONE                                               *
C*                                                                     *
C*     SUBPROGRAM                                                      *
C*      CALLED BY:  F2LAYR                                             *
C*                                                                     *
C*PROGRAM WRITTEN:  JAN 86 - NATIONAL GEOPHYSICAL DATA CENTER          *
C*        UPDATES:  JUL 86 - AFGWC/SDDE - UPGRADED DOCUMENTATION       *
C*                  AUG 87 - NATIONAL GEOPHYSICAL DATA CENTER (87-I)   *
C*                  MAR 88 - NATIONAL GEOPHYSICAL DATA CENTER (88-II)  *
C*                                                                     *
C***********************************************************************
      INTEGER IDA
      INTEGER IMO
      INTEGER IYR
      REAL CGLAT
      REAL CGLON
      REAL DAYJUL
      REAL EFFKP
      REAL EFFQ
      REAL EFFSSN
      REAL GGLAT
      REAL GGLON
      REAL TCGM
      REAL TIME
      COMMON/F6PARM/IYR,IMO,IDA,TIME,DAYJUL,EFFSSN,EFFQ,EFFKP,
     +              GGLAT,GGLON,CGLAT,CGLON,TCGM
      REAL DELTAT
      REAL EQBN
      REAL PHIA
      REAL PI
      REAL R
      REAL WIDTH
      DATA PI/3.14159265/
C.......................................................................
C     BEGIN EXECUTION                                                  .
C.......................................................................
      DELTAT=TPC
      IF(DELTAT.LT.0)DELTAT=-DELTAT
      IF(DELTAT.GT.12)DELTAT=27.-TPC
      R=16.2-4*(DELTAT**2/6.-2*ALOG(1.+COS(2*PI*(DAYJUL+11.)/365.)))
      WIDTH = (3.7+1.3*EFFKP)/2.0
      IF ( R.GE.1.0 ) WIDTH = WIDTH * ( -1.0 * SQRT(R) )
      EQBN=PHIA-WIDTH
      RETURN
      END
 
