c# esmod.f
      SUBROUTINE ESMOD
C
C     THIS ROUTINE FINDS SPORADIC E MODE AND LOSS INFORMATION
C     (SAME AS SUBROUTINE REGMOD FOR THE OTHER LAYERS)
C
C AC(3) IS ABSORPTION LOSS FACTOR, SEE LUFF(1).
C BC(3) IS DENOMINATOR OF LOSS FACTOR.
C
      COMMON/FILES/LUO,LUI,LU25,LU26
      COMMON/SIGD/ DSL,ASM,DSU,AGLAT,DSLF,ASMF,DSUF,ACAV,FEAV,AFE,BFE
     A ,XVE
      COMMON/MUFS/EMUF(24),F1MUF(24),F2MUF(24),ESMUF(24),ALLMUF(24),FOT
     A(24),XLUF(24),HPF(24),ANGMUF(24),MODMUF,SIGL(4),SIGU(4),DELMUF(4)
     B ,HPMUF(4),HTMUF(4),FVMUF(4),AFMUF(4),NHOPMF(4),YFOT(4),YHPF(4)
     C ,YMUF(4)
      COMMON /CON /D2R, DCL, GAMA, PI, PI2, PIO2, R2D, RZ, VOFL
      COMMON / DON /  AMIND, DMP, PMP, RSN, ATMNO,
     1                D90R, D50R, D10R, D90S, D50S, D10S
      COMMON /RON /RAT(5),CLCK(5),ABIY(5),ARTIC(5),SIGPAT(5),EPSPAT(5),
     1 FI(3,5),YI(3,5),HI(3,5),FX(3,5),HPRIM(30,3),HTRUE(30,3),
     2 FVERT(30,3),KFX,AFAC(30,3),HTR(54),FNSQ(54)
      COMMON /RTANT /TEFF,REFF,KASANT(2)
      COMMON / ZON / ABPS(7), CREL(7), EFF(7), FLDST(7), GRLOS(7),
     1HN (7), HP (7), PROB (7), RELY (7), RGAIN (7), SIGPOW (7), SN (7),
     2 SPRO (7), TGAIN (7), TIMED (7), TLOSS (7), B (7), FSLOS (7), ADV
     C (7),OBF(7),NMODE(7),NREL,TLLOW(7),TLHGH(7)
      COMMON /TON /ADJ, ADS, ATMO, GNOS, RCNSE, REL, SL, SLS
     1, SU, SUS, XEFF, XNOISE, XTLOS, ZNOISE, NF
      COMMON / FRQ / FREL(29), FREQ, JMODE
      COMMON /ES /FS (3, 5), HS (5)
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
      COMMON / RAYS / ANG(40), IFOB(40,30,3), NANG
      COMMON /TIME /IT, GMT, UTIME (24),GMTR,XLMT(24),ITIM
C ES MODES
C     ONE SAMPLE MODEL
      K=1
C.....SELECT SAMPLE AREA - ALL MODES WILL BE AT LEAST THIS GOOD
      DO 95 IS = 2,KM
      IF( FS(2,K).gt.FS(2,IS) ) K=IS
   95 CONTINUE
C.....MAPS ARE ES OR E - DO NOT USE AT LOW END
      FSDEAD = IFOB(1,3,JMODE)
      FSDEAD = FSDEAD /1000.
      FSDEAD = AMIN1(FSDEAD,3.)
C.....ONLY 2 ES MODES - PRESET ARRAYS
      DO 97 IHT = 4,5
      OBF(IHT)  = 1000.
      ADV(IHT)  = 1000.
      FSLOS(IHT)  = 1000.
      TLOSS(IHT)  = 1000.
      ABPS (IHT)  = 1000.
      EFF  (IHT)  = 0.0
      GRLOS(IHT)  = 1000.
      RGAIN(IHT)  = 0.0
      TGAIN(IHT)  = 0.0
      HN   (IHT)  = -1.
      PROB (IHT)  = 0.001
      CREL (IHT)  = -1000.
      RELY (IHT)  = .001
      SPRO (IHT)  = 0.001
      FLDST(IHT)  = -1000.
      SIGPOW(IHT)  = -1000.
      SN(IHT)     = -1000.
      HP(IHT)     =  -1.
      B (IHT)     =  -1.
      NMODE(IHT)  =   5
      TLLOW(IHT)  =  10.
      TIMED(IHT) = -1.
      TLHGH(IHT)  = 10.
   97 CONTINUE
      IF(FREQ.le.FSDEAD) RETURN
      IF(FS(2,K).le.0) RETURN
C.....VIRTUAL HEIGHTS SAME AS TRUE HEIGHTS
      SDMAX = 2.*RZ*(PIO2 - ASIN(1./(1.+ HS(K)/RZ) ) )
      IHSRT = GCDKM/SDMAX + 1.
      IHSTP = 2
C.....DO ONLY 2 ES HOPS
      IF(IHSRT.gt.2)  RETURN
      IH =3
C.....ABSORPTION LOSS - F2 MODE
      AC = 677.2 * ACAV/ ( (FREQ + GYZ(K)) ** 1.98  + 10.2 )
      DO 150 IHOP = IHSRT, IHSTP
      IH = IH + 1
      GP = IHOP
      GHOP = GCD / GP
      THET = 0.5 * GHOP
      TANS=SIN(THET)/(1.-COS(THET)+HS(K)/RZ)
      PSI=ATAN(TANS)
      SECS=1./COS(PSI)
      SFVMOD = FREQ/SECS
C.....MUF AT THIS HOP DISTANCE
      ESD=FS(2,K)*SECS
      DEL=PIO2-THET-PSI
      CDEL = COS (DEL)
      ADEL = DEL * R2D
      IF (ADEL.lt.AMIND)  go to 150
C.....GROUP PATH
      PATH = 2. * SIN (.5 * GHOP) * (RZ + HS (K)) / CDEL
      HOP = IHOP
      PATH = HOP * PATH
C.....FREE SPACE LOSS
      SFLOS = 32.45 + 20.* ALOG10(PATH*FREQ)
      SINP = RZ * CDEL / (RZ + 100.)
      COSP = SQRT(1. - SINP * SINP)
      SABPS = AC/COSP
      ADX =0.0
C.....CHECK IF ES LAYER IS LESS THAN E LAYER (IF YES REMOVE E LAYER
C.....BENDING ABOVE HS)
      IF(FI(1,K).gt.SFVMOD) ADX = AFE + BFE * ALOG(SFVMOD/FI(1,K) )
      SABPS = SABPS + ADX
C.....PROBABILITY OF REFLECTION
      DUMMY = YMUF(4)
      PROS = PRBMUF(FREQ,ESD,DUMMY,4)
C.....LIMIT LOSS
      PROS = AMIN1(PROS,.90)
      REF = 8.9136 * PROS ** (-0.7)
C.....LOWER DECILE FOR LOSS USE FOT
      ESD  = FS(1,K) * SECS
      DUMMY = YFOT(4)
      PS = PRBMUF(FREQ,ESD,DUMMY,4)
      PS = AMIN1(PS,.9)
      REFL = 8.9136 * PS ** (-0.7)
C.....UPPER DECILE - HPF
      ESD =  FS(3,K)* SECS
      DUMMY = YHPF(4)
      PS = PRBMUF(FREQ,ESD,DUMMY,4)
      PS  = AMIN1(PS,.9)
      REFU = 8.9136 * PS ** (-0.7)
C.....LOWER DECILE WITH AURORAL
      TLLOW(IH) = DSL + HOP * (REFL - REF)
C.....UPPER DECILE WITH AURORAL
      TLHGH(IH) = DSU + HOP * (REF - REFU)
C.....MAXIMUM OBSERVED IS 25.
      TLLOW(IH) = AMIN1(TLLOW(IH),25.)
      TLHGH(IH) = AMIN1(TLHGH(IH),25.)
      Y = 0.0
C.....GROUND LOSS
      DO 130 IG = 1,KM
      IGX = -IG
      CALL GAIN(IGX,1,DEL,FREQ,YG,GEFF)
  130 Y = Y + YG
      XKM = KM
      SGRLOS = Y / XKM
C.....ANTENNAS
      CALL GAIN(1,KASANT(1),DEL,FREQ,STGAIN,STEFF)
      CALL GAIN(2,KASANT(2),DEL,FREQ,SRGAIN,DUMMY)
      EFF(IH) = DUMMY
      XTLOS = SFLOS + HOP*(SABPS + REF + ADX ) + (HOP -1.) * SGRLOS
     A    - SRGAIN  - STGAIN  + ASM
C.....FIELD STRENGTH
      FLDST(IH) = 107.2 + PWRDB(FREQ) + 20.*ALOG10(FREQ)-XTLOS-SRGAIN
C.....MEDIAN SIGNAL POWER
      SIGPOW(IH) = PWRDB(FREQ) - XTLOS
      DUMMY = YMUF(4)
      PROS = PRBMUF(FREQ,DUMMY,DUMMY,4)
      IHT = IH
C.....OBSCURATION FOR F LAYER NOT USED
      OBF(IHT)    =  + 8.9136*PROS ** (-0.7)
C.....DEVIATION LOSS
      ADV(IHT)    = 0.0
C.....FREE SPACE
      FSLOS(IHT)  =  SFLOS
C.....MEDIAN TRANSMISSION LOSS
      TLOSS(IHT)  =  XTLOS
C.....ABSORPTION LOSS
      ABPS (IHT)  =  AC/COSP + ADX
C.....GROUND LOSS
      GRLOS(IHT)  =  SGRLOS
C.....ANTENNA GAINS
      RGAIN(IHT)  = SRGAIN
      TGAIN(IHT)  = STGAIN
      HN(  IHT)  = HOP
C.....SIGNAL POWER
      SIGPOW(IHT) = PWRDB(FREQ) - XTLOS
C.....SIGNAL-TO-NOISE RATIO
      SN    (IHT) = SIGPOW(IHT) - RCNSE
ccc      write(luo,1) iht,sn(iht),sigpow(iht),rcnse
ccc1     format('in esmod, sn(',i2,')=',3f10.3)
C.....HEIGHT
      HP    (IHT) = HS(K)
C.....RADIATION ANGLE
      B     (IHT) =  ADEL
C.....MODE
      NMODE (IHT) =  4
C.....F. DAYS
      PROB  (IHT) =  PROS ** IHOP
C.....TIME DELAY
      TIMED (IHT) =  PATH/VOFL
  150 continue
      RETURN
      END
