c# exot.f
      FUNCTION EXOT(F,EFFKP,DEC,GLAT,HA)
C***********************************************************************
C*         PURPOSE: THIS FUNCTION ESTIMATES THE TOTAL ELECTRON CONTENT.*
C*         METHOD:  1. DETERMINE LOCATION.                             *
C*                  2. USE 10-CM FLUX TO CALCULATE TOTAL ELECTRON      *
C*                     CONTENT.                                        *
C***********************************************************************
C
C
      DATA R,XM,XN,B,P,G/0.30,1.10,1.50,-0.6487,+0.1047,+0.7504/
      DATA TC1,TC2,DT1,DT0/379.,3.24,28.,0.03/
      T0=TC1+(TC2*F)
      T0R=T0*R
      CSD=COS(DEC)
      SSD=SIN(DEC)
      CGL=COS(GLAT)
      SGL=SIN(GLAT)
      SN2THE=0.5*(1.-(csd*cgl)+(ssd*sgl))
      if(SN2THE.lt.0.) SN2THE=0.           !  avoid math error (3/26/93)
      CS2ETA=0.5*(1.+(csd*cgl)+(ssd*sgl))
      T2=T0R*(CS2ETA**XM)
      T1=T0R*(SN2THE**XM)
C
      DT3=0.5*P*SIN(HA+G)
      TAU=0.5*(HA+B)+DT3
      COSTAU=COS(TAU)
      XTAU=(COSTAU*COSTAU)**XN
      EXOT=(T0+T1+(T2-T1)*XTAU) + (DT1*EFFKP+DT0*dexp(dble(EFFKP)))
      RETURN
      END
