c# f2dis.f
      SUBROUTINE F2DIS (FMUF, SSN, CLAT, FREQ, AB, SIG)
C
C     THIS ROUTINE OBTAINS THE UPPER AND LOWER DECILE FOR THE F2 MUF
C
C     USES TABLES OF F2 MUF(3000)  (IE MUF FOR A DISTANCE OF 3000 KM)
C
C FMUF IS F2 MUF,MHZ.
C SSN  IS SUNSPOT NUMBER.
C CLAT IS GEOGRAPHIC LATITUDE, RADIANS.
C FREQ IS OPERATING FREQUENCY,MHZ.
C     AB IS LOCAL MEAN TIME (HOURS)   SEE CLCK(K)
C SIG  IS STANDARD DEVIATION OF F2 MUF (NORMAL)
C
      COMMON / TWO / F2D(16,6,6),DUD(5,12,5),FAM(14,12),
     1 SYS(9,16,6),PERR(9,4,6),P(29,16,8),ABP(2,9)
C.....IF NO IONOSPHERIC LONG TERM DATA BASE FILE USE CLASSICAL VALUES
      IF(F2D(1,1,1) ) 90,90,95
   90 SIG=0.15*FMUF/1.28155
      SIG=AMAX1(SIG,0.001)
      RETURN
   95 CONTINUE
      CL = CLAT * 57.29577
      ICC = AB / 4.0 + 1.55
      if(icc .gt. 6) ICC = 1
      I = 0
      if (freq .le. fmuf) I = 8
 120  ICL = 9.5 - ABS (CL) / 10.
      IC = ICL
      if(ic .le. 0 ) ic = 1
      if(ic .gt. 8 ) ic = 8
 145  IZ = IC + I
      J = 2
      if(ssn .le. 50) J = 1
      if(ssn .gt. 100) J = 3
      K = 0
      if(cl .le. 0.0) K = 3
 185  JK = K + J
      SIG = ABS(FMUF - F2D(IZ,JK,ICC) * FMUF) / 1.28
      IF (SIG .LE. 0.001) SIG = 0.001
      RETURN
      END
