c# f2layr.f
      SUBROUTINE F2LAYR(NFLAG,FOF2,HMAX,FOE)
C***********************************************************************
C* SUBROUTINE NAME :  F2LAYR            CPC:  SS/MOD/RTN/F2LAYR        *
C*          VERSION:  88-II            DATE:  16 MAR 88                *
C*                                                                     *
C*          PURPOSE:  THIS SUBROUTINE IS THE ELKINS-RUSH MODIFICATION  *
C*                    TO THE URSI MODEL.  GIVEN A SSN AND A KP/QE AS   *
C*                    INPUT, IT WILL CALCULATE THE POSITION OF THE     *
C*                    POLEWARD TROUGH AND MAKE APPROPRIATE MODIFIC-    *
C*                    ATIONS OF THE TROUGH AND AURORAL FOF2 VALUES.    *
C*                                                                     *
C*          CALLING                                                    *
C*        ARGUMENTS:  NFLAG,FOF2,HMAX,FOE                              *
C*                                                                     *
C*    ABBREVIATIONS:  NONE                                             *
C*                                                                     *
C*    COMMON BLOCKS:  F6PARM, GWC1                                     *
C*                                                                     *
C*   FILES ACCESSED:  NONE                                             *
C*                                                                     *
C*           METHOD:  1.  CALCULATE THE LOCAL TIME AND THE POSITION    *
C*                        OF THE TROUGH WALL.                          *
C*                    2.  DETERMINE THE CORRECTION FACTORS FOR THE     *
C*                        POLAR CAVITY,AURORAL ZONE, AND AURORAL TROUGH*
C*                    3.  CALCULATE THE FOF2 AND HMAX AT THE GRIDPOINT *
C*                                                                     *
C*          REMARKS:  NONE                                             *
C*                                                                     *
C*       REFERENCES:  1.  ICED-III SYSTEM DOCUMENTATION                *
C*                    2.  SPERRY FORTRAN-77 (ASCII) PRM                *
C*                    3.  AFGWC FORM 10 DX-50194                       *
C*                    4.  AFGWC FORM 10 DX-60096                       *
C*                                                                     *
C* GLOBAL VARIABLES:                                                   *
C*  COMMON /F6PARM/IYR,IMO,IDA,TIME,DAYJUL,EFFSSN,EFFQ,EFFKP,    *
C*                 GGLAT,GGLON,CGLAT,CGLON,TCGM                        *
C*     IYR    IS  YEAR OF DATA SET                                     *
C*     IMO    IS  MONTH OF DATA SET                                    *
C*     IDA    IS  DAY OF DATA SET                                      *
C*     TCGM   RS  CORRECTED GEOMAGNETIC TIME OF A GRIDPOINT            *
C*     TIME   RS  UNIVERSAL TIME IN HH.HH OF DATA SET                  *
C*     DAYJUL RS  JULIAN DATE OF DATA SET                              *
C*     EFFSSN RS  EFFECTIVE SUNSPOT NUMBER                             *
C*     EFFQ   RS  EFFECTIVE AURORAL Q VALUE                            *
C*     EFFKP  RS  EFFECTIVE PLANETARY K INDEX                          *
C*     GGLAT  RS  GEOGRAPHIC LATITUDE OF A GRIDPOINT                   *
C*     GGLON  RS  GEOGRAPHIC LONGITUDE OF A GRIDPOINT                  *
C*     CGLAT  RS  CORRECTED GEOMAGNETIC LATITUDE OF A GRIDPOINT        *
C*     CGLON  RS  CORRECTED GEOMAGNETIC LONGITUDE OF A GRIDPOINT       *
C*                                                                     *
C*  LOCAL VARIABLES:  MFLAG    IS  QUALIFIER FLAG AT GRIDPOINT         *
C*                    NFLAG    IS  MODIFIED QUALIFIER AT GRIDPOINT     *
C*                    CEN      RS  CENTER OF AURORAL ZONE              *
C*                    CHI      RS  SOLAR ZENITH ANGLE                  *
C*                    DELTAN   RS  SMALL INCREMENT OF TIME             *
C*                    EB       RS  EQUATORIAL AURORAL BOUNDARY
C*  XXX               EQBN     RS  EQUATORIAL BOUNDARY VALUE           *
C*  XXX               EQLAT    RS  EQUATORIAL BOUNDARY LATITUDE VALUE  *
C*  XXX               EQLON    RS  EQUATORIAL BOUNDARY LONGITUDE VALUE *
C*                    DUM      RS  PLACEHOLDER IN CALL TO SOLPOS       *
C*  XXX               FACME    RS  FOURIER ANALYSIS COEFFICIENT - EQ.  *
C*  XXX               FACMP    RS  FOURIER ANALYSIS COEFFICIENT - POLAR*
C*                    FOE      RS  FREQUENCY OF E LAYER                *
C*                    FOF      RS  TEMP VALUE OF FREQUENCY OF F2 LAYER *
C*                    FOF2     RS  FREQUENCY OF THE FOF2 LAYER         *
C*  XXX               FRAC     RS  FRACTIONAL PART - TEMP VARIABLE     *
C*                    HMAX     RS  HEIGHT OF THE F2 LAYER              *
C*  XXX               HMAXC    RS  HEIGHT OF THE F2 LAYER - CENTER     *
C*  XXX               HMAXE    RS  HEIGHT OF THE F2 LAYER - EQUATOR    *
C*  XXX               HMAXP    RS  HEIGHT OF THE F2 LAYER - POLAR      *
C*                    PB       RS  POLAR BOUNDARY OF AURORAL ZONE      *
C*                    PHIA     RS  TEMP CORRECTION VALUE OF AURORAL    *
C*  XXX               PHIMIN   RS  TEMP CORRECTION VALUE OF MINIMUM    *
C*  XXX               PHIPLS   RS  TEMP CORRECTION VALUE - POLAR       *
C*                    PI       RS  3.1415926 - CONSTANT                *
C*  XXX               POLAT    RS  POLEWARD LATITUDE                   *
C*  XXX               POLON    RS  POLEWARD LONGITUDE                  *
C*                    T        RS  TEMP TIME VARIABLE                  *
C*                    T1       RS  TEMP TIME VARIABLE                  *
C*                    TIMLOC   RS  LOCAL TIME AT GGLON                 *
C*                    TCGM     RS  CORRECTED GEOMAGNETIC TIME          *
C*                    TPC      RS  TEMP TIME VARIABLE                  *
C*                    X1       RS  TEMP VARIABLE                       *
C*                    XA       RS  TEMP VARIABLE                       *
C* TRFPB  - RS - POLEWARE BOUNDARY OF THE TROUGH                       *
C* TRFMAX - RS - CENTER OF THE TROUGH                                  *
C* TRFEB  - RS - EQUATORWARE BOUNDARY OF THE TROUGH                    *
C* HFRM21 - RS - MLT HOURS PAST 21 MLT OF THIS GRIDPOINT               *
C* CGLN21 - RS - CORRECTED GEOMAGNETIC LONGITUDE AT 21 MLT             *
C* CGLN03 - RS - CORRECTED GEOMAGNETIC LONGITUDE AT 03 MLT             *
C* CGLN06 - RS - CORRECTED GEOMAGNETIC LONGITUDE AT 06 MLT             *
C* GLAT   - RS - TEMPORARY GEOGRAPHIC LATITUDE                         *
C* GLON   - RS - TEMPORARY GEOGRAPHIC LONGITUDE                        *
C* M3000  - RS - TEMPORARY M(3000) FACTOR                              *
C* HMAXTL - RS - F2 HEIGHT AT TOP LEFT OF INTERPOLATION BOX            *
C* HMAXBL - RS - F2 HEIGHT AT BOTTOM LEFT OF INTERPOLATION BOX         *
C* HMAXTR - RS - F2 HEIGHT AT TOP RIGHT OF INTERPOLATION BOX           *
C* HMAXBR - RS - F2 HEIGHT AT BOTTOM RIGHT OF INTERPOLATION BOX        *
C* FRLAT  - RS - FRACTIONAL LAT. FROM BOTTOM TO TOP OF INTERPOLATION   *BOX
C* FRLON  - RS - FRACTIONAL LONG. FROM LEFT TO RIGHT OF INTERPOLATION  * BOX
C* PT1    - RS - TEMP. BOTTOM F2 HEIGHT IN LONGITUDE INTERPOLATION BOX *X
C* PT2    - RS - TEMP. TOP F2 HEIGHT IN LONGITUDE INTERPOLATION BOX    *
C* F      - RS - M3000 CALCULATION VARIABLE                            *
C* XE     - RS - RATIO OF FOF2 TO FOE                                  *
C* DELTAM - RS - M3000 CORRECTION TERM                                 *
C*  (I=INTEGER, R=REAL, C=CHARACTER, S=SCALAR, V=VECTOR, A=ARRAY)      *
C*                                                                     *
C*     SETC OPTIONS:  NONE USED                                        *
C*                                                                     *
C*       SUBPROGRAMS                                                   *
C*           CALLED:  QOVAL1 - CALCULATES THE AURORAL OVAL POSITION    *
C*                    FLDHR  - RETRIEVES FOURIER ANALYSIS COEFFICIENTS *
C*                    EQBOUN - CALCULATES THE EQ. BOUNDARY OF OVAL     *
C*                    CGINV1 - CONVERTS GEOMAG TO GEOGRAPHIC COORDS    *
C*                    SOLPOS - COMPUTES SOLAR ZENITH ANGLE             *
C*                                                                     *
C*       SUBPROGRAM                                                    *
C*       CALLED BY :  FIELD6                                           *
C*                                                                     *
C* PROGRAM WRITTEN:  JAN 86 - NATIONAL GEOPHYSICAL DATA CENTER         *
C*                   MAY 86 - AFGWC/SDDE - UPGRADED DOCUMENTATION      *
C*                   AUG 87 - NATIONAL GEOPHYSICAL DATA CENTER (87-I)  *
C*                   MAR 88 - NGDC (88-II) NEW SOLAR ZENITH ANGLE      *
C*                                                                     *
C***********************************************************************
      INTEGER IDA
      INTEGER IMO
      INTEGER IYR
      REAL CGLAT
      REAL CGLON
      REAL DAYJUL
      REAL EFFKP
      REAL EFFQ
      REAL EFFSSN
      REAL GGLAT
      REAL GGLON
      REAL TCGM
      REAL TIME
      COMMON/F6PARM/IYR,IMO,IDA,TIME,DAYJUL,EFFSSN,EFFQ,EFFKP,
     +              GGLAT,GGLON,CGLAT,CGLON,TCGM
      INTEGER MFLAG
      INTEGER NFLAG
      REAL TRFPB,TRFMAX,TRFEB,HFRM21,CGLN21,CGLN03,CGLN06
      REAL GLAT,GLON,M3000,HMAXTL,HMAXBL,HMAXTR,HMAXBR
      REAL FRLAT,FRLON, PT1,PT2
      REAL F,XE,DELTAM
      REAL CEN
      REAL CHI
      REAL*8 DELTAN
      REAL DUM
      REAL EB
      REAL FOE
      REAL FOF
      REAL FOF2
      REAL HMAX
      REAL PB
      REAL PHIA
      REAL PI
      REAL T
      REAL*8 T1,t_exp
      REAL TIMLOC
      REAL TPC
      REAL X1
      REAL XA
      DATA PI/3.141593/
 
C.......................................................................
C     BEGIN EXECUTION                                                  .
C.......................................................................
 
      MFLAG = NFLAG
      fof=fof2
C.......................................................................
C     AURORAL ZONE BOUNDARIES                                          .
C.......................................................................
      CALL QOVAL1(EFFQ,TCGM,PB,CEN,EB)
      PHIA = EB
C.......................................................................
C     DETERMINE THE CORRECTION FACTOR IN AURORAL ZONE AND POLAR CAVITY .
C.......................................................................
      TPC=ABS(TCGM-3.)
      IF(TPC.GT.14.0) TPC=27.-TCGM
 
      IF (CGLAT.LT.PHIA) GO TO 40
      XA = PB-PHIA
      X1 = (PHIA-CGLAT)/XA
      IF (CGLAT.GT.CEN) X1 = X1 * 2.0
      DELTAN=EXP((-1.0*X1*X1)/2.0)
      GO TO 80
C.......................................................................
C     CALCULATE THE CORRECTION FACTOR SOUTH OF AURORAL ZONE            .
C.......................................................................
40    T1 = 0.0
      XA = 3.7 + (1.3*EFFKP)
C.......................................................................
C     COMPUTE SOLAR ZENITH ANGLE                                       .
C.......................................................................
      TIMLOC = TIME + GGLON/15.0
      IF ( TIMLOC.GE.24.00 ) TIMLOC = TIMLOC - 24.00
      IF ( TIMLOC.LT. 0.00 ) TIMLOC = TIMLOC + 24.00
      CALL SOLPOS( IYR,IMO,IDA,TIMLOC,GGLAT,GGLON,CHI,DUM,DUM,DUM )
 
      X1=(CGLAT-PHIA)/XA
ccc      T1=EXP((X1-(X1*X1))/2.0)*EXP((-1.0*TPC*TPC)/12.0)
      t_exp=(X1-(X1*X1))/2.0 - TPC*TPC/12.0
      T1=exp(t_exp)
      if(t1.le.1.e20) t1=0.
      IF (CHI.LE.90.0.OR.(TCGM.GT.6.0.AND.TCGM.LT.18.0))  T = 0.0
      IF((CHI.GT.94.6).AND.((TCGM.GE.18.0).OR.(TCGM.LE.6.0)))
     +     T=-0.2*T1
      IF (((CHI.GE.90.0).AND.(CHI.LE.94.6) ) .AND.
     +  ((TCGM.LE.6.0).OR.(TCGM.GE.18.0))) then
ccc      write(*,'(''t1='',e15.7)') t1
           T=-0.2*(CHI-90.0)/4.6*T1
      end if
C......................................................................
      if(abs(t).lt.1.e-20) t=0.
C    MILLER AND GIBBS 1975                                            .
C......................................................................
ccc      T=T1*EXP((X1-(X1*X1))/2.0)*EXP((-1.0*TPC*TPC)/12.0)
ccc      write(*,79) t,t1,x1,tpc,t_exp
ccc79    format('T=',5e15.7)
      DELTAN=T*(1.0+COS(PI*(DAYJUL+11.0)/182.5))
80    continue
      FOF2=FOF*(1.0+DELTAN)
C......................................................................
C     'DENSITY' CORRECTION IN AURORAL ZONE AND POLAR CAVITY CONSIDERED.
C     CONSTANT IN TIME. CORRECTION BASED ON DENSITY DIFFERENCE BETWEEN.
C     4 AND 5 MHZ. 5 MHZ BEING APPROX 1.22663 TIMES 4 MHZ WHICH IS A  .
C     TYPICAL NIGHTTIME URSI FOF2 VALUE.                              .
C......................................................................
      IF (CGLAT.GE.PHIA) FOF2=SQRT( FOF*FOF + 9.0+DELTAN )
 
C......................................................................
C     F2 HEIGHT CALCULATION : BRANCH TO 170 IF NOT TROUGH POINT       .
C......................................................................
      IF ( (TCGM.GT. 6.0).AND.(TCGM.LT.21.0) ) GO TO 170
      TRFMAX = PHIA - 1.5
      TRFPB = PHIA + 1.5
      IF ( CGLAT.GT.TRFPB ) GO TO 170
      CALL EQBOUN( TPC,TRFMAX,TRFEB )
      IF ( TRFEB.GT.TRFMAX-1.5 ) TRFEB = TRFMAX - 1.5
      IF ( CGLAT.LT.TRFEB ) GO TO 170
 
C......................................................................
C     F2 TROUGH HEIGHT CALCULATION BY INTERPOLATION                   .
C     INTERPOLATION CASES :                                           .
C       |---------------------------------|-----------------| TRFPB   .
C       |               1                 |        3        |         .
C       |                                 |                 |         .
C       |---------------------------------*-----------------| TRFMAX  .
C       |               2                 |        4        |         .
C       |                                 |                 |         .
C       |---------------------------------|-----------------| TRFEB   .
C     21 MLT                            03 MLT            06 MLT      .
C                                                                     .
C       * = 450.0 KILOMETERS (MAX HEIGHT IN TROUGH)                   .
C......................................................................
C----------  HOURS PAST 21 MLT
      HFRM21 = 3.0 + TCGM
      IF ( TCGM.GE.21.0 ) HFRM21 = TCGM - 21.0
 
C----------  CG LONGITUDES OF 21,03,06 MLT
      CGLN21 = CGLON - ( HFRM21 * 15.0 )
      CGLN03 = CGLN21 + 90.0
      CGLN06 = CGLN21 + 135.0
      IF ( CGLN21.LE.  0.0 ) CGLN21 = CGLN21 + 360.0
      IF ( CGLN03.GE.360.0 ) CGLN03 = CGLN03 - 360.0
      IF ( CGLN06.GE.360.0 ) CGLN06 = CGLN06 - 360.0
 
C......................................................................
C     HMF2 EQUATION FROM:                                             .
C     DUDENY, J.R., "THE ACCURACY OF SIMPLE METHODS FOR DETERMINING   .
C       THE HEIGHT OF THE MAXIMUM ELECTRON CONCENTRATION OF THE F2-   .
C       LAYER FROM SCALED IONOSPHERIC CHARACTERISTICS",               .
C     J. ATMOS. TERR. PHYSICS, VOL 45, NO. 8/9, PP. 629-640, 1983     .
C     - ERROR IN HPF2 20% WHEN XE=2.0; 60% WHEN XE=1.7                .
C     - MOST APPROPRIATE FOR 15-60 DEGREES MAGNETIC DIP LATITUDE      .
C......................................................................
      XE = FOF2 / FOE
C----------  BY CCIR RECOMMENDATION
      IF ( XE.LT.1.7 ) XE = 1.7
      DELTAM = (0.253/(XE-1.215)) - 0.012
C----------  INTERPOLATION CASE 1
      IF ( (CGLAT.GE.TRFMAX).AND.(HFRM21.LE.6.) ) THEN
        CALL CGINV1( TRFPB,CGLN21,GLAT,GLON )
        CALL FLDHR( 3,GLAT,GLON,M3000 )
        F = M3000 * SQRT((0.0196*M3000*M3000+1)/(1.2967*M3000*M3000-1))
        HMAXTL = (1490.*F)/(M3000+DELTAM) - 176.
        CALL CGINV1( TRFMAX,CGLN21,GLAT,GLON )
        CALL FLDHR( 3,GLAT,GLON,M3000 )
        F = M3000 * SQRT((0.0196*M3000*M3000+1)/(1.2967*M3000*M3000-1))
        HMAXBL = (1490.*F)/(M3000+DELTAM) - 176.
        CALL CGINV1( TRFPB,CGLN03,GLAT,GLON )
        CALL FLDHR( 3,GLAT,GLON,M3000 )
        F = M3000 * SQRT((0.0196*M3000*M3000+1)/(1.2967*M3000*M3000-1))
        HMAXTR = (1490.*F)/(M3000+DELTAM) - 176.
        HMAXBR = 450.0
        FRLAT = (CGLAT-TRFMAX) / (TRFPB-TRFMAX)
        FRLON = HFRM21 / (27.-21.)
      ENDIF
C----------  INTERPOLATION CASE 2
      IF ( (CGLAT.LT.TRFMAX).AND.(HFRM21.LE.6.) ) THEN
        CALL CGINV1( TRFMAX,CGLN21,GLAT,GLON )
        CALL FLDHR( 3,GLAT,GLON,M3000 )
        F = M3000 * SQRT((0.0196*M3000*M3000+1)/(1.2967*M3000*M3000-1))
        HMAXTL = (1490.*F)/(M3000+DELTAM) - 176.
        CALL CGINV1( TRFEB,CGLN21,GLAT,GLON )
        CALL FLDHR( 3,GLAT,GLON,M3000 )
        F = M3000 * SQRT((0.0196*M3000*M3000+1)/(1.2967*M3000*M3000-1))
        HMAXBL = (1490.*F)/(M3000+DELTAM) - 176.
        HMAXTR = 450.0
        CALL CGINV1( TRFEB,CGLN03,GLAT,GLON )
        CALL FLDHR( 3,GLAT,GLON,M3000 )
        F = M3000 * SQRT((0.0196*M3000*M3000+1)/(1.2967*M3000*M3000-1))
        HMAXBR = (1490.*F)/(M3000+DELTAM) - 176.
        FRLAT = (CGLAT-TRFEB) / (TRFMAX-TRFEB)
        FRLON = HFRM21 / (27.-21.)
      ENDIF
C----------  INTERPOLATION CASE 3
      IF ( (CGLAT.GE.TRFMAX).AND.(HFRM21.GT.6.) ) THEN
        CALL CGINV1( TRFPB,CGLN03,GLAT,GLON )
        CALL FLDHR( 3,GLAT,GLON,M3000 )
        F = M3000 * SQRT((0.0196*M3000*M3000+1)/(1.2967*M3000*M3000-1))
        HMAXTL = (1490.*F)/(M3000+DELTAM) - 176.
        HMAXBL = 450.0
        CALL CGINV1( TRFPB,CGLN06,GLAT,GLON )
        CALL FLDHR( 3,GLAT,GLON,M3000 )
        F = M3000 * SQRT((0.0196*M3000*M3000+1)/(1.2967*M3000*M3000-1))
        HMAXTR = (1490.*F)/(M3000+DELTAM) - 176.
        CALL CGINV1( TRFMAX,CGLN06,GLAT,GLON )
        CALL FLDHR( 3,GLAT,GLON,M3000 )
        F = M3000 * SQRT((0.0196*M3000*M3000+1)/(1.2967*M3000*M3000-1))
        HMAXBR = (1490.*F)/(M3000+DELTAM) - 176.
        FRLAT = (CGLAT-TRFMAX) / (TRFPB-TRFMAX)
        FRLON = (HFRM21-6.) / (30.-27.)
      ENDIF
C----------  INTERPOLATION CASE 4
      IF ( (CGLAT.LT.TRFMAX).AND.(HFRM21.GT.6.) ) THEN
        HMAXTL = 450.0
        CALL CGINV1( TRFEB,CGLN03,GLAT,GLON )
        CALL FLDHR( 3,GLAT,GLON,M3000 )
        F = M3000 * SQRT((0.0196*M3000*M3000+1)/(1.2967*M3000*M3000-1))
        HMAXBL = (1490.*F)/(M3000+DELTAM) - 176.
        CALL CGINV1( TRFMAX,CGLN06,GLAT,GLON )
        CALL FLDHR( 3,GLAT,GLON,M3000 )
        F = M3000 * SQRT((0.0196*M3000*M3000+1)/(1.2967*M3000*M3000-1))
        HMAXTR = (1490.*F)/(M3000+DELTAM) - 176.
        CALL CGINV1( TRFEB,CGLN06,GLAT,GLON )
        CALL FLDHR( 3,GLAT,GLON,M3000 )
        F = M3000 * SQRT((0.0196*M3000*M3000+1)/(1.2967*M3000*M3000-1))
        HMAXBR = (1490.*F)/(M3000+DELTAM) - 176.
        FRLAT = (CGLAT-TRFEB) / (TRFMAX-TRFEB)
        FRLON = (HFRM21-6.) / (30.-27.)
      ENDIF
 
C----------  TWO-DIMENSIONAL LINEAR INTERPOLATION BETWEEN FOUR CORNERS
      PT1 = HMAXBL + FRLON*(HMAXBR-HMAXBL)
      PT2 = HMAXTL + FRLON*(HMAXTR-HMAXTL)
      HMAX = PT1 + FRLAT*(PT2-PT1)
 
C......................................................................
C     ADJUST QUALIFIER FLAG FOR TROUGH POINT                          .
C......................................................................
      IF ( CGLAT.LT.PHIA ) NFLAG = MFLAG + 100
      RETURN
 
C......................................................................
C     NO INTERP NEEDED. DAYTIME OR OUTSIDE INTERP ZONES AT NIGHT      .
C......................................................................
170   CALL FLDHR(3,GGLAT,GGLON,M3000)
      F = M3000 * SQRT((0.0196*M3000*M3000+1)/(1.2967*M3000*M3000-1))
      XE = FOF2 / FOE
C----------  BY CCIR RECOMMENDATION
      IF ( XE.LT.1.7 ) XE = 1.7
      DELTAM = (0.253/(XE-1.215)) - 0.012
      HMAX = (1490.*F)/(M3000+DELTAM) - 176.
      RETURN
      END
 
c--------------------------------------------------------------
ccc      subroutine uflow(n)
ccc      integer (kind=3) count_underflow
ccc      call underflow_count@(count_underflow)  !  see if any underflows occured
ccc      write(*,'(''uflow='',2i8)') n,count_underflow
ccc      if(count_underflow.gt.0) stop 'underflow halt'
ccc      RETURN
ccc      END
c--------------------------------------------------------------
ccc      subroutine uflow2(n)
ccc      integer (kind=3) count_underflow
ccc      call underflow_count@(count_underflow)  !  see if any underflows occured
ccc      write(*,'(''uflow2='',2i8)') n,count_underflow
ccc      if(count_underflow.gt.5) stop 'underflow halt'
ccc      RETURN
ccc      END
c--------------------------------------------------------------
