c# feccir.f
      SUBROUTINE FECCIR( IYR,IMO,IDA,TIME,GGLAT,GGLON,EFFSSN,FOE,HME )
C***********************************************************************
C* SUBROUTINE NAME :  FECCIR            CPC:  SS/MOD/RTN/FECCIR        *
C*          VERSION:  88-II            DATE:  16 MAR 88                *
C*                                                                     *
C*          PURPOSE:  THIS SUBROUTINE COMPUTES THE MAXIMUM FREQUENCY   *
C*                    AND HEIGHT OF THE IONOSPHERE'S E LAYER UNDER     *
C*                    SOLAR CONTROL                                    *
C*                                                                     *
C*          CALLING                                                    *
C*        ARGUMENTS:  IYR,IMO,IDA,TIME,GGLAT,GGLON,EFFSSN,FOE,HME      *
C*                                                                     *
C*    ABBREVIATIONS:  NONE                                             *
C*                                                                     *
C*    COMMON BLOCKS:  NONE ACCESSED                                    *
C*                                                                     *
C*   FILES ACCESSED:  NONE                                             *
C*                                                                     *
C*           METHOD:  BASED ON THE CCIR METHOD (SEE SUPPLEMENT TO      *
C*                    REPORT 252-2)                                    *
C*                                                                     *
C*          REMARKS:  NONE                                             *
C*                                                                     *
C*       REFERENCES:  1.  ICED-III SYSTEM DOCUMENTATION                *
C*                    2.  SPERRY FORTRAN-77 (ASCII) PRM                *
C*                    3.  AFGWC FORM 10 DX-50194                       *
C*                    4.  AFGWC FORM 10 DX-60096                       *
C*                                                                     *
C*  LOCAL VARIABLES:  IYR      IS  YEAR OF DATA SET                    *
C*                    IMO      IS  MONTH OF DATA SET                   *
C*                    IDA      IS  DAY OF DATA SET                     *
C*                    A        RS  E LAYER CONSTANT                    *
C*                    B        RS  E LAYER CONSTANT                    *
C*                    CHID     RS  FAVORABLE SOLAR ZENITH ANGLE        *
C*                    COSLAM   RS  UNKNOWN VARIABLE                    *
C*                    D        RS  E LAYER CONSTANT                    *
C*                    DELCHI   RS  ADJUSTMENT FACTOR FOR SOLAR ZENITH  *
C*                    DTR      RS  DEGREE TO RADIAN CONVERSION CONSTANT*
C*                    DUM      RS  PLACEHOLDER IN CALL TO SOLPOS       *
C*                    EFFSSN   RS  EFFECTIVE SUNSPOT NUMBER            *
C*                    EM       RS  EXPONENT IN FOE EQUATION            *
C*                    FA       RS  GEOGRAPHIC LATITUDE IN RADIANS      *
C*                    FLUX     RS  10.7CM SOLAR FLUX                   *
C*                    FOEMIN   RS  MINIMUM FOE FREQUENCY               *
C*                    FOE      RS  MAXIMUM FREQUENCY OF E LAYER        *
C*                    GGLAT    RS  GEOGRAPHIC LATITUDE OF GRIDPOINT    *
C*                    GGLON    RS  GEOGRAPHIC LONGITUDE OF GRIDPOINT   *
C*                    HME      RS  HEIGHT OF MAXIMUM FREQUENCY         *
C*                    LAMBDA   RS  MAGNITUDE OF GEOGRAPHIC LATITUDE    *
C*                    LOCALT   RS  LOCAL TIME AT SPECIFIED LOCATION    *
C*                    LTLAG    RS  LOCAL TIME FOR SLUGGISH IONOSPHERE  *
C*                    P        RS  UNKNOWN VARIABLE                    *
C*                    SUNRIS   RS  TIME OF SUNRISE                     *
C*                    SUNSET   RS  TIME OF SUNSET                      *
C*                    TERMA    RS  FACTOR IN FOE CALCULATION           *
C*                    TERMB    RS  FACTOR IN FOE CALCULATION           *
C*                    TERMC    RS  FACTOR IN FOE CALCULATION           *
C*                    TERMD    RS  FACTOR IN FOE CALCULATION           *
C*                    TIME     RS  UNIVERSAL TIME OF DATA SET          *
C*                    ZENITH   RS  SOLAR ZENITH ANGLE AT LOCAL TIME    *
C*                    ZEN12    RS  SOLAR ZENITH ANGLE AT LOCAL NOON    *
C*                    ZENSL    RS  SOLAR ZEN. ANGLE FOR SLUGGISH IONOS.*
C*  (I=INTEGER, R=REAL, C=CHARACTER, S=SCALAR, V=VECTOR, A=ARRAY)      *
C*                                                                     *
C*     SETC OPTIONS:  NONE USED                                        *
C*                                                                     *
C*       SUBPROGRAMS                                                   *
C*           CALLED:  SOLPOS                                           *
C*                                                                     *
C*       SUBPROGRAM                                                    *
C*       CALLED BY :  ELAYER                                           *
C*                                                                     *
C* PROGRAM WRITTEN:  MAR 88 - WRITTEN BY NGDC (88-II)                  *
C*                                                                     *
C***********************************************************************
      INTEGER IDA
      INTEGER IMO
      INTEGER IYR
      REAL A
      REAL B
      REAL CHID
      REAL COSLAM
      REAL D
      REAL DELCHI
      REAL DTR
      REAL DUM
      REAL EFFSSN
      REAL EM
      REAL FLUX
      REAL FOEMIN
      REAL FOE
      REAL GGLAT
      REAL GGLON
      REAL LAMBDA
      REAL LOCALT
      REAL LTLAG
      REAL P
      REAL SUNRIS
      REAL SUNSET
      REAL TERMA
      REAL TERMB
      REAL TERMC
      REAL TERMD
      REAL TERM
      REAL TIME
      REAL ZENITH
      REAL ZEN12
      REAL ZENSL
      REAL HME
 
      DATA DTR / 0.017453293 /
 
C......................................................................
C     COMPUTE SOLAR 10.7CM FLUX                                       .
C......................................................................
      FLUX = 63.7 + 0.728*EFFSSN + 0.00089 * EFFSSN**2
 
C......................................................................
C     COMPUTE LOCAL TIME AT THIS GRIDPOINT                            .
C......................................................................
      LOCALT = TIME + GGLON/15.0
      IF ( LOCALT.GE.24.00 ) LOCALT = LOCALT - 24.00
      IF ( LOCALT.LT. 0.00 ) LOCALT = LOCALT + 24.00
 
C......................................................................
C     COMPUTE SOLAR ZENITH ANGLE AND TIME OF SUNRISE AND SUNSET AT    .
C     THIS LOCAL TIME                                                 .
C......................................................................
      CALL SOLPOS( IYR,IMO,IDA,LOCALT,GGLAT,GGLON,ZENITH,DUM,
     +             SUNRIS,SUNSET )
C......................................................................
C     COMPUTE SOLAR ZENITH ANGLE AT LOCAL NOON                        .
C......................................................................
      CALL SOLPOS( IYR,IMO,IDA,12.00,GGLAT,GGLON,ZEN12,DUM,DUM,DUM )
C......................................................................
C     COMPUTE SOLAR ZENITH ANGLE 3 MINUTES AGO TO ACCOUNT FOR         .
C     SLUGGISHNESS IN THE IONOSPHERE                                  .
C......................................................................
      LTLAG = LOCALT - 0.05
      IF ( LTLAG.LT. 0.00 ) LTLAG = LTLAG + 24.00
      CALL SOLPOS( IYR,IMO,IDA,LTLAG,GGLAT,GGLON,ZENSL,DUM,DUM,DUM )
 
C......................................................................
C     MINIMUM VALUE OF FOE (WAKAI, 1971)                              .
C......................................................................
      FOEMIN = (0.017 * (1. + 0.0098 * EFFSSN) **2 ) ** 0.25
C......................................................................
C     THE EXPONENT "M" AND THE TERMS A AND B                          .
C......................................................................
      LAMBDA = ABS(GGLAT)
      COSLAM = COS(LAMBDA*DTR)
      IF (LAMBDA.LT.32.0) THEN
        EM = -1.93 + 1.92 * COSLAM
        A = 23.
        B = 116.
      ELSE
        EM = 0.11 - 0.49 * COSLAM
        A = 92.
        B = 35.
      ENDIF
C......................................................................
C     THE TERMS CHI-DASH AND P                                        .
C......................................................................
      CHID = ZENITH
      IF (LAMBDA.GT.23.) CHID = ZENSL
      P = 1.20
      IF (LAMBDA.LE.12.0) P = 1.31
C......................................................................
C      THE TERM "D"                                                   .
C......................................................................
      IF (CHID.LE.73.0) D = (COS(CHID*DTR)) ** P
      IF ( (CHID.GT.73.0).AND.(CHID.LT.90.0) ) THEN
        DELCHI = 6.27E-13 * (CHID - 50.) ** 8
        D = ( COS( (CHID - DELCHI)*DTR ) ) ** P
      ENDIF
      IF ( CHID.GE.90.0 ) THEN
        D = 0.044
        IF ( (LOCALT.GE.0.0).AND.(LOCALT.LT.SUNRIS) )
     +    D = (0.077)**P * EXP(-1.68*(SUNRIS-LOCALT))
        IF ( (LOCALT.GE.SUNSET).AND.(LOCALT.LT.24.0) )
     +    D = (0.077)**P * EXP(-1.01*(LOCALT-SUNSET))
      ENDIF
C......................................................................
C     NOW BACK TO EQUATION 6 FOR FOE                                  .
C......................................................................
      TERMC = A + B * COSLAM
      TERMD = D
      IF ( ZEN12.GE.90.0 ) ZEN12 = 89.99999
      IF ( ZEN12.LE.-90.0 ) ZEN12 = -89.99999
      TERMB = COS(ZEN12*DTR) ** EM
      TERMA = 1.0 + 0.0094 * (FLUX - 66.)
      TERM = TERMA * TERMB * TERMC * TERMD
      FOE = TERM ** 0.25
C......................................................................
C     KEEP FOE ABOVE THE NIGHTTIME MINIMUM VALUE                      .
C......................................................................
      IF (FOE.LT.FOEMIN) FOE = FOEMIN
C......................................................................
C     TITHERIDGE FORMULA FOR HME - UPPER LIMIT SET TO 120 KM          .
C     FOR LARGE ZENITH ANGLES                                         .
C......................................................................
      IF ( ZENITH.GE.77.10 ) THEN
        HME = 120.0
      ELSE
        HME = 108.0 + 8.0 * LOG( 1.0/COS(ZENITH*DTR) )
      ENDIF
      RETURN
      END
 
