c# findf.f
      SUBROUTINE FINDF(K)
C
C     THIS ROUTINE DOES AREA COVERAGE FOR A SPECIFIED FREQUENCY
C     (FIND ALL MODES FOR AN OPERATING FREQUENCY)
C     INSERTS PENETRATION ANGLES INTO THE ANGLE TABLE AND COMPUTES ALL
C     RAY PATH PARAMETERS FOR EACH ANGLE AT THE FREQUENCY "FREQ"
C
C     FREQ  GIVEN OPERATING FREQUENCY  - MHZ-
C     GHOP  GIVEN GROUND DISTANCE -RADIANS-
C     DELPEN(3,5) PENETRATION ANGLE FOR FREQUENCY FMHZ -DEGREES-
C
C
C     DELMOD(6,5)  TAKE OFF ANGLE AT FMHZ,GHOP -DEGREES-
C     HPMOD (6,5)  VIRTUAL HEIGHT AT FMHZ,GHOP -KM-
C     HTMOD (6,5)  TRUE    HEIGHT AT FMHZ,GHOP -KM-
C     DSKPKM       SKIP DISTANCE AT FMHZ,GHOP -KM-
C     DELSKP       TAKE OFF ANGLE FOR SKIP DISTANCE -DEGREES-
C     HPSKP        VIRTUAL HEIGHT FOR SKIP DISTANCE -KM-
C     HTSKP        TRUE    HEIGHT FOR SKIP DISTANCE -KM-
C     NANG IS THE HIGHEST ANGLE NUMBER (PRESET IN SUBROUTINE SANG)
C
C     K IS THE SAMPLE AREA
C     ICUSP IS THE INSERT CUSP INDEX
C     (=-1 FOR NOT IN, =0 FOR ONE SIDE IN, =1 FOR FINISHED)
C     IH IS THE HEIGHT INDEX FOR COMMON/RAYS/ (FROM 1 TO 30)
C     ILOW IS THE LOWER LIMIT (IH) FOR LAYER
C     IHIGH IS THE UPPER LIMIT (IH) FOR LAYER
C     IA IS THE ANGLE INDEX FOR COMMON/RAYS/ (1 TO NANG .LE. 40)
C     IAF IS THE ANGLE INDEX FOR COMMON/REFLX/ (1 TO 45)
C     IFOB IS IN KHZ
C
      COMMON / DON /  AMIND, DMP, PMP, RSN, ATMNO,
     1                D90R, D50R, D10R, D90S, D50S, D10S
      COMMON / FRQ / FREL(29), FREQ,JMODE
      COMMON /REFLX /DELFX (45, 3), HPFLX (45, 3), HTFLX (45, 3), GDFLX
     1(45, 3), FVFLX (45, 3), DSKPKM (3), DELSKP (3), HPSKP (3), HTSKP (
     23), DMAXKM (3), FVSKP (3), ISKP (3), IMODE (45, 3), AFFLX (45, 3)
     3, DELPEN(3,3)
      COMMON/LOSX/ANDVX(45,3),ADVX(45,3),AOFX(45,3),ARFX(45,3),GRLOSX(
     A 45,3),TGAINX(45,3)
      COMMON /MODES /GHOP, DELMOD (6, 3), HPMOD (6, 3), HTMOD (6, 3), FV
     1MOD (6, 3), ITMOD (6, 3), AFMOD (6, 3)
      COMMON /CON /D2R, DCL, GAMA, PI, PI2, PIO2, R2D, RZ, VOFL
      COMMON /RON /RAT(5),CLCK(5),ABIY(5),ARTIC(5),SIGPAT(5),EPSPAT(5),
     1 FI(3,5),YI(3,5),HI(3,5),FX(3,5),HPRIM(30,3),HTRUE(30,3),
     2 FVERT(30,3),KFX,AFAC(30,3),HTR(54),FNSQ(54)
C GEOGRAPHIC AND IONSPHERIC DATA AT SAMPLE AREAS,SEE GEOM AND GENION.
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
      COMMON/RAYS/ANG(40),IFOB(40,30,3),NANG
      common /files/luo,lui,lu25,lu26
      DIMENSION ITYPE(3)
      DATA ITYPE/1,2,3/
ccc      write(9,'('' in findf, k='',i5)') k
      JFHZ = 1000. * FREQ
      DMAXKM (K) = 0.
      DSKPKM (K) = 10000.
      DO 100 IA = 1, 45
      HPFLX (IA, K) = 0.
      DELFX (IA, K) = 0.
 100  GDFLX (IA, K) = 0.
      FC2 = FI (3, K) * FI (3, K)
C
C     FIND PENETRATION ANGLES
C
      CALL PENANG(K)
      IA = 0
      IAF = 1
C
C     SET  LAYER
C
C.....SET FOR E LAYER
      ICUSP = - 1
      IL = 1
      IUP = 0
      IH = 1
      ILOW = 1
      IHIGH = 10
      GO TO 275
C.....SET FOR F LAYER
  225 IH = 11
      ILOW = 11
      IF (FI(2, K) - 0.2)235, 235, 245
C.....SET FOR F2 LAYER ONLY
 235  IL = 3
      ICUSP = - 1
      IUP = 0
      IHIGH = 30
  236 CONTINUE
      GO TO 275
C.....SET FOR F1 LAYER
 245  IL = 2
      ICUSP = - 1
      IUP = 0
      IHIGH = 20
      GO TO 236
C.....SET FOR F2 LAYER
 255  IL = 3
      ICUSP = - 1
      ILOW = IHIGH + 1
      IUP = 0
      IHIGH = 30
      IH = 21
      GO TO 236
 265  GO TO (225, 255, 400), IL
C.....START OF SEARCH
 275  CONTINUE
C.....CHECK TO SEE IF ANY MODES FROM THIS LAYER
      IF (DELPEN (IL, K))265, 265, 285
C.....CHECK IF PENETRATED ALL LAYERS
 285  IF (DELPEN (IL, K) - 89.99)295, 295, 400
C.....INCREMENT ANGLE
 295  IA = IA + 1
C.....STOP IF THERE ARE MORE HOPS THAN REASONABLE
      IF(IA-NANG) 300,300,400
  300 CONTINUE
C.....CHECK TO SEE IF LAYER WAS PENETRATED
      IF (DELPEN (IL, K) - ANG (IA))345, 345, 305
C.....SEARCH FOR FREQUENCY
 305  CONTINUE
      IF(IFOB(IA,ILOW,K) - JFHZ) 306, 325, 325
  306 IF(IH - IHIGH) 315, 275, 275
 315  IF (IFOB (IA, IH, K) - JFHZ)335, 325, 330
C.....EXACT FREQUENCY TO THREE PLACES (IN MHZ)
 325  DELFX (IAF, K) = ANG (IA)
      HTFLX (IAF, K) = HTRUE (IH, K)
      AFFLX(IAF,K)=AFAC(IH,K)
      FV = FVERT (IH, K)
      HP = HPRIM (IH, K)
      IMODE (IAF, K) = ITYPE (IL)
      GO TO 375
C.....INCREMENT HEIGHT INDEX
 330  IH = IH + 1
      GO TO 305
 335  IF (IFOB (IA, IH + 1, K) - JFHZ)330, 340, 340
C.....BEGIN INTERPOLATION
 340  SLOPD = IFOB (IA, IH + 1, K) - IFOB (IA, IH, K)
      SLOPD = AMAX1 (1., SLOPD)
      SLOPE = JFHZ - IFOB (IA, IH, K)
      SLOPE = SLOPE / SLOPD
      HTFLX (IAF, K) = HTRUE (IH, K) + SLOPE * (HTRUE (IH + 1, K) - HTRU
     1E (IH, K))
      FV = FVERT (IH, K) + SLOPE * (FVERT (IH + 1, K) - FVERT (IH, K))
      DELFX (IAF, K) = ANG (IA)
      HP = HPRIM (IH, K) + SLOPE * (HPRIM (IH + 1, K) - HPRIM (IH, K))
      AFFLX (IAF, K) = AFAC (IH, K) + SLOPE * (AFAC (IH + 1, K) - AFAC (
     1IH, K))
      IMODE (IAF, K) = ITYPE (IL)
C.....END INTERPOLATION
      GO TO 375
C.....BEGIN INSERT OF CUSP
 345  DELFX (IAF, K) = DELPEN (IL, K)
      HTFLX (IAF, K) = HTRUE (IHIGH, K)
      AFFLX( IAF,K ) = AFAC( IHIGH, K)
      FV = FVERT (IHIGH, K)
      HP = HPRIM (IHIGH, K)
C.....KEEP ANGLE COUNT CORRECT
      IA = IA - 1
      ICUSP = 0
      IMODE (IAF, K) = ITYPE (IL)
C.....END OF INSERT CUSP
      GO TO 375
C.....F2 IS THE LAST LAYER
 350  IF (IL - 3)355, 400, 400
C.....IS NEXT LAYER POSSIBLE
C
C.....BEGIN INSERT CUSP FOR NEXT LAYER
 355  IF (DELPEN (IL, K) - 89.89)360, 400, 400
 360  DELFX (IAF, K) = DELFX (IAF - 1, K) + .001
      HTFLX (IAF, K) = HTRUE (IHIGH + 1, K)
      AFFLX(IAF,K) = AFAC(IHIGH+1,K)
      FV = FVERT (IHIGH + 1, K)
      HP = HPRIM (IHIGH + 1, K)
      ICUSP = 1
      IF (FI(2, K) - 0.2) 365, 365, 370
 365  IMODE (IAF, K) = ITYPE (3)
      GO TO 375
 370  IMODE (IAF, K) = ITYPE (IL + 1)
C.....END OF INSERT CUSP FOR NEXT LAYER
 375  CONTINUE
C  CORRECT MARTYN S THEOREM
C.....MARTYN"S THEOREM ASSUMES FLAT IONOSPHERE
C.....THIS IS A CORRECTION FOR A SPHERICAL IONOSPHERE
      DEL = DELFX (IAF, K) * D2R
      RCOSD = RZ * COS (DEL)
      HT = HTFLX (IAF, K)
      xfsq = (freq*freq-fv*fv)/fc2
      XHP = (HP - HT) / RZ
      hp=hp+xfsq*xhp*(ht+2.*(rz+ht)*xhp)
      PHE = RCOSD / (RZ + HP)
      PHE = ASIN (PHE)
      GDR = 2. * RZ * (PIO2 - DEL - PHE)
C.....GROUND DISTANCE (KM)
      GDFLX (IAF, K) = GDR
      HPFLX (IAF, K) = HP
      FVFLX (IAF, K) = FV
C.....BEGIN TO FIND SKIP DISTANCE (MINIMUM)
      IF (DSKPKM (K) - GDR)385, 385, 380
 380  DSKPKM (K) = GDR
      DELSKP (K) = DELFX (IAF, K)
      HTSKP (K) = HT
      HPSKP (K) = HP
      FVSKP (K) = FV
      ISKP (K) = ITYPE (IL)
C.....END OF FINDING SKIP DISTANCE
 385  IF (DMAXKM (K) - GDR)390, 390, 395
  390 IF(DELFX(IAF,K)  - AMIND ) 395,391,391
C.....FIND MAXIMUM DISTANCE
  391 DMAXKM(K) = GDR
 395  CONTINUE
C.....INCREMENT INDEX FOR COMMON/REFLX/ (MAXIMUM IS 45)
      IAF = IAF + 1
ccc      write(9,'('' iaf='',i5)') iaf
      IF(IAF - 45) 396, 396, 400
  396 IF(ICUSP) 275, 350, 265
 400  CONTINUE
ccc      write(9,'(1x,i7,9f7.1)') jfhz,(delpen(j,k),j=1,3),dskpkm(k),
ccc     A dmaxkm(k),delskp(k),htskp(k),hpskp(k),fvskp(k)
ccc      ij=iaf-1
ccc      do 500 j=1,ij
ccc      write(9,'(1x,i4,2x,6f8.1)') imode(j,k),gdflx(j,k),delfx(j,k),
ccc     A hpflx(j,k),htflx(j,k),fvflx(j,k)
ccc 500  continue
C.....END OF INSERT CUSP  (IE CUSP FINISHED)
ccc      write(9,'('' leaving FINDF, IAF='',i5)') iaf
      RETURN
      END
