c# flag.f
      SUBROUTINE FLAG(II,TCGM,PB,CEN,EB)
C***********************************************************************
C* SUBROUTINE NAME:  FLAG             CPC :  SS/MOD/RTN/FLAG           *
C*                                                                     *
C*         PURPOSE:  THIS SUBROUTINE DETERMINES WHETHER OR NOT THE CRI-*
C*                   TERIA FOR A SOLAR E OR F1 LAYER, AN AURORAL E     *
C*                   LAYER, SPORADIC E OR F LAYER IRREGULARITIES, OR A *
C*                   POLAR CAP GRIDPOINT HAVE BEEN MET.  IT RETURNS    *
C*                   A FLAG FOR THE GRIDPOINT WHICH TELLS THE OTHER    *
C*                   PROGRAMS WHAT STATE THE GRIDPOINT IS IN.          *
C*                                                                     *
C*                                                                     *
C*         METHOD:  1.  CALCULATES THE SUBSOLAR AND ANTI-SUBSOLAR      *
C*                  POINT, THE SOLAR DECLINATION, AND THE CORRECTED    *
C*                  GEOMAGNETIC LOCAL TIME.                            *
C*                                                                     *
C*                  2.  DETERMINES IF THE GRIDPOINT IS IN THE AURORAL  *
C*                  ZONE, POLAR CAP OR MIDLATITUDE ZONES, AND WHETHER  *
C*                  AN E LAYER WOULD BE FORMED BY THE SOLAR RADIATION  *
C*                                                                     *
C*                  3.  DETERMINES IF SOLAR F1 REGION WOULD BE FORMED  *
C*                  AND WHETHER SPORADIC E OR SPREAD F WOULD OCCUR AT  *
C*                  THE GRIDPOINT.                                     *
C*                                                                     *
C*                  4.  CALCULATES THE VALUE OF THE QUALIFIER FLAG FOR *
C*                  THE GRIDPOINT.                                     *
C*                                                                     *
C***********************************************************************
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
      COMMON / TIME / IT, GMT, UTIME(24), GMTR, XLMT(24), ITIM
      COMMON /RON /RAT(5),CLCK(5),ABIY(5),ARTIC(5),SIGPAT(5),EPSPAT(5),
     1 FI(3,5),YI(3,5),HI(3,5),FX(3,5),HPRIM(30,3),HTRUE(30,3),
     2 FVERT(30,3),KFX,AFAC(30,3),HTR(54),FNSQ(54)
C SOLAR PARAMETERS
      COMMON /SOLAR/IYR,IMO,IDA,SSN,EFFQ,EFFKP,JUDAY,CHI(5),
     A TCGMT(5),PBT(5),CENT(5),EBT(5)
      DATA D2R/0.0174532925/
C......................................................................
      DCGLT = CGLT(II)/D2R
      sslt=-23.45*cos(6.283185*(juday+10.0)/365.0)
      ASLT=-SSLT
      SSLN=180.0 - 15.0 * GMT
      IF(SSLN .LT. 0.0) SSLN = SSLN +360.0
      ASLN = SSLN +180.0
      IF(ASLN .GE.360.0) ASLN=ASLN-360.0
      HANG = CLONG(II)/D2R - SSLN
      IF (HANG.LT.0.0)  HANG = HANG + 360.0
C.......................................................................
C     CALCULATE THE CHI ANGLE (ANGLE BETWEEN ZENITH AND SUN)           .
C.......................................................................
      COZANG = SIN(CLAT(II))*SIN(SSLT*D2R) +
     A COS(CLAT(II))*COS(SSLT*D2R)*COS(HANG*D2R)
      CHI(II)= ABS(ACOS(COZANG))/D2R
C......................................................................
C     LOCAL MEAN TIME                                                 .
C......................................................................
      CLOCK = GMT+(CLONG(II)/D2R)/15.0
      IF(CLOCK .GE. 24.0) CLOCK=CLOCK-24.0
      CLCK(II)=CLOCK
C......................................................................
C     CORRECTED GEOMAGNETIC LOCAL TIME                                .
C......................................................................
      RASLT=ASLT
      RASLN=ASLN
ccc      write(66,1) raslt,rasln
ccc1     format('flag=',2e16.8)
      CALL CGLAL1(RASLT,RASLN,ASCGLT,ASCGLN)
ccc      write(66,2) ascglt,ascgln
ccc2     format(40x,2e16.8)
      TCGM = (CGLN(II)/d2r-ASCGLN)/15.0
      IF (TCGM.LT.0.0)  TCGM = TCGM + 24.0
      IF (TCGM.GE.24.0)  TCGM = TCGM - 24.0
C.......................................................................
C     F1 LAYER (240 KM)                                                .
C.......................................................................
      IFLAG = 0
      IF (CHI(II).LE.105.5) IFLAG = IFLAG + 4
C.......................................................................
C     SOLAR E                                                          .
C.......................................................................
      IF (CHI(II).LE.101.0) IFLAG = IFLAG + 2
C.......................................................................
C     AURORAL E                                                        .
C.......................................................................
      CALL QOVAL1(EFFQ,TCGM,PB,CEN,EB)
      IF (DCGLT.GE.EB.AND.DCGLT.LT.CEN)  IFLAG = IFLAG + 1
      IF (DCGLT.GE.CEN.AND.DCGLT.LE.PB)  IFLAG = IFLAG + 11
C.......................................................................
C     F LAYER IRREGULARITY ZONE   (GASSMAN ET. AL)                     .
C.......................................................................
      ESTOP = CEN + 1.0
      ESBOT = CEN - 1.0
      IF (EFFQ.GE.2.0) ESBOT = (CEN + EB)/2.0
      IF (EFFQ.GE.4.0) ESBOT = EB
      IF (EFFQ.GE.6.0) ESTOP = PB
      IF (DCGLT.GE.ESBOT.AND.DCGLT.LE.ESTOP) IFLAG=IFLAG+20
      IF ( IFLAG.GE.30 ) IFLAG = IFLAG - 10
C.......................................................................
C  LOW LATITUDE SPREAD F (FLAG=36)                                     .
C.......................................................................
      MFLG=0
      IF ( IMO.GE.5 .AND. IMO.LE.9 ) MFLG = 1
      IF ( DCGLT.LE.30.0 ) MFLG = MFLG + 10
      IF ( MFLG.EQ.11 .AND. EFFQ.GE.4 ) IFLAG = IFLAG + 30
      IF ( TCGM.GE.0. .AND. TCGM.LE.5. .AND. MFLG.EQ.10 )
     +  IFLAG = IFLAG + 30
      IF ( TCGM.GE.19. .AND. TCGM.LE.24. .AND. MFLG.EQ.10 )
     +  IFLAG = IFLAG + 30
C.......................................................................
C  SPORADIC E                                                          .
C.......................................................................
      IFG = MOD( IFLAG,2 )
      IF ((TCGM.LE.4. .OR. TCGM.GE.10.) .AND. IFG.NE.0 )
     +  IFLAG = IFLAG + 30
      IF ( IFLAG.GT.50 ) GO TO 90
      MFG = MOD( MFLG,2 )
      ITG = 0
      IF (TCGM.LT.6.0.OR.TCGM.GT.18) ITG = 1
      IF (ITG.EQ.1.AND.MFG.EQ.0) GO TO 90
      ISE = 40
      IF ((IFLAG.GT.10).OR.(IFG.NE.0)) ISE = 30
      IF (MFG.NE.0) IFLAG = IFLAG + ISE
      IF ((IFLAG.GT.60.AND.IFLAG.LT.70).AND.(IFG.NE.0) )
     +  IFLAG = IFLAG - 30
      IF (IFLAG.GT.70) IFLAG = IFLAG - 30
90    IF (DCGLT.GE.ESTOP) IFLAG = 9
      IFLG(II)=IFLAG
      RETURN
      END
