c# fnorml.f
      FUNCTION FNORML(YPX)
C
C     THIS FUNCTION COMPUTES THE CUMULATIVE NORMAL DISTRIBUTION FUNCTION
C     FOR POSITIVE OR NEGATIVE VALUES OF X. SEE "THE HANDBOOK OF
C     MATHEMATICAL FUNCTIONS", AMS 55.  NOTE THAT THIS METHOD WILL WORK
C     ON 16 BIT MACHINES (32 BIT FLOATING POINT WORD)
C
      DIMENSION C(4)
      DATA C/.196854, .115194, .000344, .019527/
C
      YP = YPX
      if(YPX .lt. 0.0)  yp = -ypx
      YP = AMIN1(5.0, YP)
      QX = 1. + YP * (C(1) + YP * (C(2) + YP* (C(3) + YP * C(4))))
      QX = QX * QX * QX * QX
      QX = 1. / QX
      QX = .5 * QX
      px = qx
      if(ypx .ge. 0.0)  px = 1.0 - qx
      FNORML = PX
      RETURN
      END
