c# genion.f
      SUBROUTINE GENION(K)
C  THIS SECTION WILL GENERATE AN ELECTRON DENSITY PROFILE, AN IONOGRAM,
C  A REFLECTRIX,TABLE OF OBLIQUE FREQUENCIES AND DISTANCES AT SPECIFIED
C  ANGLES,ORDINARY MODE ONLY
C
C     HTR(54)  TRUE HEIGHT PROFILE FOR ELECTRON DENSITY PROFILE -- KM
C     FNSQ(54) ELECTRON DENSITY AS PLASMA FREQUENCY -- (MHZ)**2
C     FVERT(30,5) VERTICAL SOUNDING FREQUENCY--MHZ
C     HTRUE(30,5) TRUE HEIGHT OF REFLECTION--KM
C     HPRIM(30,5) VIRTUAL HEIGHT OF REFLECTION--KM
C
C     IFOB(40,30,5) OBLIQUE OPERATING FREQUENCY -- HZ
C     IDIST(40,30,5) PATH DISTANCE -- KM
C     ANG(40)  ELEVATION ANGLE -- DEGREES
C
      COMMON /RON /RAT(5),CLCK(5),ABIY(5),ARTIC(5),SIGPAT(5),EPSPAT(5),
     1 FI(3,5),YI(3,5),HI(3,5),FX(3,5),HPRIM(30,3),HTRUE(30,3),
     2 FVERT(30,3),KFX,AFAC(30,3),HTR(54),FNSQ(54)
C  SAMPLE VERTICAL SOUNDING  FREQUENCIES
C D-E  REGION TAIL
C   XTAIL MUST AGREE WITH LECDEN
      XTAIL = .85
      FEX = FI(1,K) * SQRT(1. - XTAIL * XTAIL)
      FVERT (1, K) = .01
      FVERT (4, K) = FEX
      FDIF = (FVERT (4, K) - FVERT (1, K)) / 3.
      FVERT (2, K) = FVERT (1, K) + FDIF
      FVERT (3, K) = FVERT (2, K) + FDIF
C  E REGION NOSE
C.....GUESS FOR E MUF
      FVERT(9,K) = .957 * FI(1,K)
      FVERT(10,K) = 0.99 * FI(1,K)
      FDIF = (FVERT(9,K) - FVERT(4,K)) / 5.
      FVERT (5, K) = FVERT (4, K) + FDIF
      FVERT (6, K) = FVERT (5, K) + FDIF
      FVERT (7, K) = FVERT (6, K) + FDIF
      FVERT (8, K) = FVERT (7, K) + FDIF
C.....E - F CUSP
      FVERT(11,K) =  1.05 * FI(1,K)
C.....F REGION NOSE
      FVERT(30,K) = 0.99 * FI(3,K)
      FVERT (29, K) = 0.98 * FI (3, K)
      FVERT (28, K) = 0.96 * FI (3, K)
      FVERT (27, K) = 0.92 * FI (3, K)
      IF (FI(2, K).lt. fvert(11,k)) then
C   F2 LAYER, NO F1 LAYER
      FDIF = (FVERT (27, K) - FVERT (11, K)) / 16.
      DO 395 IF = 12, 26
 395  FVERT (IF, K) = FVERT (IF - 1, K) + FDIF
      else
C  F1 LAYER  AND F2 LAYER
      FVERT(20,K) = 0.99 * FI(2,K)
      FDIF = (FVERT (20, K) - FVERT (11, K)) / 9.
      DO 405 IF = 12, 19
 405  FVERT (IF, K) = FVERT (IF - 1, K) + FDIF
C.....F1 - F2 CUSP
      FVERT(21,K) = 1.01 * FI(2,K)
      FDIF = (FVERT (27, K) - FVERT (21, K)) / 6.
      DO 415 IF = 22, 26
 415  FVERT (IF, K) = FVERT (IF - 1, K) + FDIF
      endif
C
C
C    INTEGRATE TO GET IONOGRAM, NT-POINT GUASSIAN
C
C
      DO 640 IF = 1, 30
C.....VERTICAL SOUNDING FREQUENCY
      FXX = FVERT(IF,K)
      CALL GETHP(FXX, HPX, HTX)
C.....HPRIM(IF,K) IS THE VIRTUAL HEIGHT
C.....HTRUE(IF,K) IS THE TRUE HEIGHT
      HPRIM(IF,K) = HPX
      HTRUE(IF,K) = HTX
  640 CONTINUE
      RETURN
      END
