c# geom.f
      SUBROUTINE GEOM (NPSL)
C
C     THIS ROUTINE CALCULATES THE PATH GEOMETRY
C
C MAPIN IS -1,IF DATA TAPE HAS NOT BEEN READ.
C
      COMMON /CON /D2R, DCL, GAMA, PI, PI2, PIO2, R2D, RO, VOFL
      COMMON / DON /  AMIND, DMP, PMP, RSN, ATMNO,
     1                D90R, D50R, D10R, D90S, D50S, D10S
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
      DATA SGLP/0.97992477/,CGLP/0.19936793/, GLG/1.20427718/
      DATA EPSLON/1.E-7/
C.....GEOMAGNETIC NORTH POLE, LATITUDE, LONGITUDE, MINIMUM
C.....TAKE OFF ANGLE SERVICE PROBABILITY FACTOR
C.....LATITUDE SOUTH IS "-" AND LATITUDE NORTH IS "+"
C.....LONGITUDE IS EAST "+"
C.....Geomagnetic pole is Lat=78.5, Lon=69.0
      STL=SIN(TLAT)
      CTL=COS(TLAT)
      SRL=SIN(RLAT)
      CRL=COS(RLAT)
C     GREAT CIRCLE DISTANCE AND BEARINGS.
      DLONG = TLONG - RLONG
      IF (ABS (DLONG) .GT. PI) DLONG = DLONG - SIGN (PI2, DLONG)
      QCOS = STL * SRL + CTL * CRL * COS(DLONG)
      IF (ABS (QCOS) .GT. 1.0) QCOS = SIGN (1.0, QCOS)
      GCD = ACOS (QCOS)
C.....MINIMUM DISTANCE IS 31.85 METERS
      IF(GCD.LT.0.000001) GCD = 0.000001
C.....CHECK IF TRANSMITTER IS NEAR A POLE
      IF(CTL - EPSLON) 101, 101, 104
C.....TRANSMITTER IS NEAR A POLE
  101 IF (TLAT) 102,102,103
  102 BTR= 0.0
      GO TO 106
  103 BTR = PI
      GO TO 106
C.....TRANSMITTER IS NOT NEAR A POLE
  104 CONTINUE
      QCOS = (SRL - STL * COS (GCD)) / (CTL * SIN (GCD))
      IF (ABS (QCOS) .GT. 1.0) QCOS = SIGN (1.0, QCOS)
C.....BTR IS BEARING, TRANSMITTER TO RECEIVER
      BTR = ACOS (QCOS)
  106 CONTINUE
      IF (DLONG .GT. 0.0) BTR = PI2 - BTR
C.....CHECK IF RECEIVER IS NEAR A POLE
      IF(CRL - EPSLON) 111, 111, 114
C.....RECEIVER IS NEAR A POLE
  111 IF( RLAT )  112,112,113
  112 BRT = 0.
      GO TO 116
  113 BRT=PI
      GO TO 116
C.....RECEIVER IS NOT NEAR A POLE
  114 CONTINUE
      QCOS = (STL - SRL * COS (GCD)) / (CRL * SIN (GCD))
      IF (ABS (QCOS) .GT. 1.0) QCOS = SIGN (1.0, QCOS)
C.....BRT IS BEARING, RECEIVER TO TRANSMITTER
      BRT = ACOS (QCOS)
  116 CONTINUE
      IF (DLONG .LT. 0.0) BRT = PI2 - BRT
C.....CHANGE FOR LONG PATH CALCULATIONS
      IF(NPSL .EQ. 0) GO TO 118
      DLONG=DLONG-SIGN(PI2,DLONG)
      GCD=PI2-GCD
      BTR=BTR+PI
      BRT=BRT+PI
      IF(BTR .GT. PI2) BTR=BTR-PI2
      IF(BRT .GT. PI2) BRT=BRT-PI2
  118 GCDKM=GCD*RO
C.....CONVERT BEARINGS TO DEGREES
      BTRD = BTR * R2D
      BRTD = BRT * R2D
C     DETERMINATION OF REFLECTION AREAS.
C SELECT SAMPLE AREAS IN ORDER
      IF(GCDKM - 2000.01) 50, 50, 55
C.....KM IS THE NUMBER OF SAMPLE AREAS
   50 KM=1
      RD(1)= GCD/2.
      GO TO 66
   55 IF(GCDKM- 4000.) 60,60,65
   60 KM=3
      RD(1) = 1000. / RO
      RD(2)= GCD/2.
      RD(3)= GCD -RD(1)
      GO TO 66
   65 KM= 5
      RD(1) = 1000. / RO
      RD(2)= RD(1)+RD(1)
      RD(3)= GCD/2.
      RD(4)= GCD-RD(2)
      RD(5)= GCD-RD(1)
   66 CONTINUE
C.....RD(1) IS E LAYER, RD(2) IS F LAYER, RD(3) IS ALL LAYERS,
C.....RD(4) IS F LAYER AND RD(5) IS E LAYER
C     REFLECTION AREA COORDINATES AND GEOMAGNETIC LATITUDE.
      IF(KM.LT.1) GO TO 185
      DO 180 I = 1, KM
      DRF = RD (I)
C.....CHECK IF TRANSMITTER IS NEAR A POLE
      IF(CTL - EPSLON) 71, 76, 76
C.....TRANSMITTER IS NEAR A POLE
   71 RFLT = TLAT - SIGN(DRF,TLAT)
      IF(ABS(RFLT) -PIO2) 75,75,72
   72 IF(RFLT ) 73,74,74
   73 RFLT = -PIO2
      GO TO 75
   74 RFLT = PIO2
   75 RFLG=RLONG
      GO TO 80
C.....TRANSMITTER IS NOT NEAR A POLE
   76 CONTINUE
      QCOS = COS (DRF) * STL + SIN (DRF) * CTL * COS (BTR)
      IF (ABS (QCOS) .GT. 1.0) QCOS = SIGN (1.0, QCOS)
      RFLT = PIO2 - ACOS (QCOS)
C.....CHECK IF THE SAMPLE AREA IS NEAR A POLE
      IF(COS(RFLT) - EPSLON) 78, 78, 79
C.....SAMPLE AREA IS NEAR A POLE
   78 RFLG = TLONG
      GO TO 80
C.....SAMPLE AREA IS NOT NEAR A POLE
   79 CONTINUE
      QCOS = (COS (DRF) - SIN (RFLT) * STL) / (COS (RFLT) * CTL)
      IF (ABS (QCOS) .GT. 1.0) QCOS = SIGN (1.0, QCOS)
      RFLG = ACOS (QCOS)
      IF (DRF .GE. PI) RFLG = PI2 - RFLG
      RFLG = TLONG - SIGN (RFLG, DLONG)
      IF(RFLG .LT. 0.0) RFLG=RFLG+PI2
      IF(RFLG .GE. PI2) RFLG=RFLG-PI2
   80 CONTINUE
      QCOS = SGLP * SIN(RFLT) + CGLP * COS(RFLT) * COS(RFLG+GLG)
      IF (ABS (QCOS) .GT. 1.0) QCOS = SIGN (1.0, QCOS)
C.....GLAT(I) IS THE GEOMAGNETIC LATITUDE
C.....CLAT(I) IS THE GEOGRAPHIC LATITUDE
C.....CLONG(I) IS THE GEOGRAPHIC LONGITUDE
      GAT = ACOS (QCOS)
      GLAT (I) = PIO2 - GAT
      CLAT (I) = RFLT
      CLONG (I) = RFLG
C.....MAGNETIC FIELD VARIABLES.
      CALL MAGFIT(RFLT,RFLG,DIP,GYZ(I))
      cos_rflt=cos(rflt)
      if(abs(cos_rflt).lt.epslon) cos_rflt=epslon
      GMDIP(I)=ATAN(DIP/SQRT(COS_RFLT))
      RFLT = RFLT * R2D
      RFLG = RFLG * R2D
      CALL CGLAL1(RFLT,RFLG,CFLT,CFLG)
      CGLT(I)=CFLT*d2r
      CGLN(I)=CFLG*d2r
  180 CONTINUE
 185  CONTINUE
      RETURN
      END
