c# htf2.f
      SUBROUTINE HTF2(IKM,HOUT,SHOUT,TIMEL)
C***********************************************************************
C*         PURPOSE: THIS SUBROUTINE CALCULATES THE THICKNESS OF THE    *
C*                  F2 LAYER.                                          *
C*     SUBPROGRAMS                                                     *
C*         CALLED:  SCALHT - TO CALCULATE THE SCALE HEIGHT             *
C***********************************************************************
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
C SOLAR PARAMETERS
      COMMON /SOLAR/IYR,IMO,IDA,SSN,EFFQ,EFFKP,JUDAY,CHI(5),
     A TCGMT(5),PBT(5),CENT(5),EBT(5)
C
      DIMENSION CSSZ(3),ZACONS(5)
C
      DATA CSSZ/-0.2,0.052,0.208/
      DATA PI/3.1415927/
      DATA PI2/6.2831853/
      DATA R2D/57.2957795/
C
      FLAT=CLAT(IKM)
      DCGLT=CGLT(IKM)*R2D
      sslt=-23.45*cos(6.283185*(juday+10.0)/365.0)
      DEC=SSLT/R2D
      SDAY=FLOAT(JUDAY)
      DO 100 I=1,5
        ZACONS(   I)=0.0
100   CONTINUE
      SDEC=SIN(DEC)
      CDEC=COS(DEC)
      SAT=SIN(FLAT)
      CAT=COS(FLAT)
C
C............................................................
C     (  1)  -  NOON LOCAL TIME,  (  2)  -  MIDNIGHT LOCAL TIME
C............................................................
C
      ZACONS(   1)=SDEC*SAT + CDEC*CAT
      ZACONS(   2)=SDEC*SAT - CDEC*CAT
      DO 110 I=1,3
        TP=(CSSZ(I) - SDEC*SAT)/(CDEC*CAT)
        TP=-TP
        IF(TP.LT.(-1.0))  TP= -1.0
        IF(TP.GT.1.0) TP=1.0
        TP=ACOS(TP)
        ZACONS(   2+I)=12.0*TP/PI
110   CONTINUE
      AA=      0.55*((DCGLT)    - 45.0)
      H12=(197.0 +(0.79*SSN)-(0.0011*(SSN**2))+ AA)
      H24=(297.0 +(0.603*SSN)+ AA)
      SOLFLX=63.7493+(0.7274+0.000895*SSN)*SSN
      IF(ZACONS(   2).GE.CSSZ(1))  then
C
C.............................................................
C     CASE I A
C.............................................................
C
         HOUT=H12
         GO TO 200
      endif
      IF(ZACONS(   1).LE.CSSZ(1))  then
C
C.............................................................
C     CASE I B
C.............................................................
C
         TINF=EXOT(SOLFLX,EFFKP,DEC,FLAT,0.524)
         CALL DENS(TINF,1000.0,ZATR,SMULT)
         BTA1=DCGLT
         BTA2=67.0 - 2.0*EFFKP
         HOUT=H24 +(0.08*ZATR*dexp(dble(-((BTA1-BTA2)**2)/20.0)))
         GO TO 200
      endif
C
C...................................................................
C     CASE II - TIME LT T (102 DEGREES)
C...................................................................
C
      IF(TIMEL.LT.ZACONS(   3)) then
         TINF=EXOT(SOLFLX,EFFKP,DEC,FLAT,0.524)
         CALL DENS(TINF,1000.0,ZATR,SMULT)
         BTA1=DCGLT
         BTA2=67.0 - 2.0*EFFKP
         HOUT=H24 +(0.08*ZATR*dexp(dble(-((BTA1-BTA2)**2)/20.0)))
         GO TO 200
      endif
      IF(ZACONS(   1).LE.CSSZ(2))  then
C
C...................................................................
C     CASE II  -  TIME GE T(102 DEGREES)
C...................................................................
C
         IF(TIMEL.LE.12.0) then
C
C...................................................................
C     CASE II  -  T(102 DEG) LT TIME LE 12.0
C...................................................................
C
            SP1=(H24-H12)/(12.0-ZACONS(   3))
            HOUT=H24 - SP1*(TIMEL - ZACONS(   3))
         else
C
C...................................................................
C     CASE II  -  12.0 LT TIME LE 24.0
C...................................................................
C
            SP1=(H24-H12)/12.0
            HOUT=H12 +SP1*(TIMEL - 12.0)
         endif
         GO TO 200
      endif
C
C...................................................................
C     CASES III AND IV  -  T(102 DEG) LE TIME
C...................................................................
C
      IF(ZACONS(   1).GE.CSSZ(3))
     +  H12=H12 -(((H24-H12)*(12.0-ZACONS(   5)))/12.0)
C
      IF(TIMEL.LE.ZACONS(   4))  then
C
C...................................................................
C     CASES III AND IV  -  T(102 DEG) LT TIME LE T(87 DEG)
C...................................................................
C
         SP1=(H24-H12)/(ZACONS(   4)-ZACONS(    3))
         HOUT=H24 -(SP1*(TIMEL-ZACONS(   3)))
         GO TO 200
      endif
      IF(TIMEL.LE.ZACONS(   5))  then
C
C...................................................................
C     CASES III AND IV  -  T(87 DEG) LT TIME LE T(78 DEG)
C...................................................................
C
         HOUT=H12
      else
C
C...................................................................
C     CASES III AND IV  -  T(78 DEG) LT TIME LE 24.0
C...................................................................
C
         SP1=(H24-H12)/(24.0-ZACONS(   5))
         HOUT=H12 +(SP1*(TIMEL - ZACONS(   5)))
      endif
200   CONTINUE
      YMF12=1.4 +(0.4*COS((PI2*(SDAY-14.0))/365.0))
      YMF24=1.2 + 0.3*COS(((2.0*PI2)*(SDAY-100.0))/365.0)
      IF(ZACONS(   2).GE.CSSZ(1))  then
         SHOUT=YMF12
         GO TO 250
      endif
      IF(ZACONS(   1).LE.CSSZ(1))  then
         SHOUT=YMF24
         GO TO 250
      endif
      TR=ZACONS(   3)
      TS=24.0 - TR
      IF(TIMEL.LE.12.0)  then
         SHOUT=YMF24 + (YMF12-YMF24)*(TIMEL-TR)/4.0
      else
         SHOUT=YMF24 - (YMF12-YMF24)*(TIMEL-TS)/4.0
      endif
      IF(SHOUT.GT.YMF12) SHOUT=YMF12
      IF(SHOUT.LT.YMF24) SHOUT=YMF24
250   CONTINUE
      HA=PI2*(TIMEL+12.0)/24.0
      TINF=EXOT(SOLFLX,EFFKP,DEC,FLAT,HA)
      CALL DENS(TINF,HOUT,DMY,SMULT)
      SHOUT=1.50*SMULT*SHOUT
      RETURN
      END
