c-------------------------------------------------------------
         winapp 80000,120000
c# icepac.f
C***********************************************************************
      PROGRAM ICEPACW
*    +               (IONINP,IONFOT,areach)
      character COMPILER*3
      parameter (COMPILER='W32')       !  32-bit compiler
      include <windows.ins>
C***********************************************************************
c Execute with:
c    ICEPACW.EXE [S] directory ICEPACX.DAT ICEPACX.OUT a  (P-P circuit)
c    ICEPACW.EXE [S] directory ICEPACG.DAT ICEPACG.OUT    (P-P graph)
c    ICEPACW.EXE [S] directory ICEPACD.DAT ICEPACD.OUT    (P-P distance)
c    ICEPACW.EXE [S] directory ICEPACT.DAT ICEPACT.OUT    (P-P time)
c    ICEPACW.EXE [S] directory BATCH                      (P-P batch)
c    ICEPACW.EXE [S] directory BATCH deckname.dat         (P-P NEW batch)
c    ICEPACW.EXE [S] directory BATCH deckname.dat nam.out (P-P NEW batch)
c    ICEPACW.EXE [S] directory AREA CALC ICEAREAW.CIR     (AREA batch)
c    ICEPACW.EXE [S] directory AREA method pathname       (AREA single)
c    ICEPACW.EXE [S] directory INV  CALC ICEAREAW.CIR     (AREA INVERSE batch)
c    ICEPACW.EXE [S] directory INV  method pathname       (AREA INVERSE single)
c where:
c    [S]       = SILENT, then no messages are written to output window
c    directory = full pathname to the install directory (e.g. c:\ITSHFBC)
c    method    = (CALC/SCREEN/PRINT)
c    pathname  = full pathname below directory\AREADATA\ of input data file
c                (e.g. DEFAULT\DEFAULT.ICE)
c    a         = append results to output file (leave blank to create new file)
c
c Stuff below may be old:
c                  ICEPACW ioninp ionfot list
c                       where:
c                             ioninp  = input card image data file
c                             ionfot  = output file to create
c                             area    =   = normal point-to-point
c                                     = a = area coverage mode
c                                           ionfot is directory name
c                                           ioninp 1st record contains name
C***********************************************************************
C***********************************************************************
C
C  THIS IS THE IONOSPHERIC COMMUNICATIONS ENHANCED PROFILE
C  ANALYSIS AND CIRCUIT PREDICTION PROGRAM (ICEPAC).
C    THE COMPUTER PROGRAM IS AN INTEGRATED SYSTEM
C  OF SUBROUTINES DESIGNED TO PREDICT HIGH-FREQUENCY (HF) SKY-WAVE
C  SYSTEM PERFORMANCE AND ANALYSE IONOSPHERIC PARAMETERS.
C
C***********************************************************************
C
C  QUESTIONS CONCERNING THE ICECAP PROGRAM SHOULD BE DIRECTED TO
C
C     FRANK G. STEWART    (303) 497-3336
c        Frank retired 12/31/92 try
c     Greg Hand           (303) 497-3375
c                         Email: gh@its.bldrdoc.gov
C     U. S. DEPARTMENT OF COMMERCE
C     NATIONAL TELECOMMUNICATIONS AND INFORMATION ADMINISTRATION
C     INSTITUTE FOR TELECOMMUNICATION SCIENCES
C     325 BROADWAY
C     BOULDER, COLORADO  80303
C***********************************************************************
C
C
C***********************************************************************
C
C  ADDITIONAL INFORMATION CONCERNING TECHNIQUES FOR MODELING HF SYSTEMS
C  THAT DEPEND ON IONOSPHERIC PROPAGATION CAN BE FOUND IN THE FOLLOWING
C
C  NBS REPORT 7619 (1962)
C  ESSA TECHNICAL REPORT,IER-ITSA 1 (1966)
C  TECHNICAL REPORT  NO. RADC-TR-67-396 (1967)
C  ESSA TECHNICAL REPORT,ERL 110-ITS-78 (1969)
C  NRL MEMO REPORT 2226 (1971)
C  NRL MEMO REPORT 2500 (1972)
C  A TECH. DESCRIPTION OF PROFILE MODEL(ICED, Version 1986-II)
C
C  INPUT IS OF THREE KINDS
C  1. CARD IMAGES - THE INPUT IS FORMATTED CARD IMAGES READ
C      FROM FUNCTION MONITR AND ASSEMBLED IN SUBROUTINE DECRED
C  2. LONG TERM DATA FILE. THIS IS A BINARY FILE CONTAINING COEFFICIENTS
C     FOR PREDICTING IONOSPHERIC INDICES.
C  3. ANTENNA GAIN DATA. THE GAIN AS A FUNCTION OF FREQUENCY AND ANGLE
C     CAN BE READ FROM A FILE. THIS FILE CAN BE CALCULATED FROM THIS
C     PROGRAM
C
C***********************************************************************
C
C  FILE DEFINITION OF LOGICAL UNITS USED BY ICEPAC
C
C     LOGICAL UNIT      MNEMONIC                FILE DESCRIPTION
C
C          8              LUI           USER DEFINED INPUT (CARD IMAGES)
C          9              LUO           LINE PRINTER OUTPUT
C          2        *     LU2           IONOSPHERIC LONG TERM DATA BASE
C         25        *     LU25          ANTENNA PATTERN OUTPUT
C         26        *     LU26          OPTIONAL ANTENNA PATTERN INPUT
C
C                   * DENOTES BINARY FILE, ASCII OTHERWISE
C
C**********************************************************************
C
C  THERE ARE THREE BASIC PROGRAM ANALYSIS OPTIONS AVAILABLE TO THE USER
C     (A) MAXIMUM USABLE FREQUENCIES (MUF)
C     (B) LOWEST USEFUL HIGH FREQUENCIES (LUF)
C     (C) SYSTEM PERFORMANCE
C
C  THE PROGRAM ANALYSIS IS CONTROLLED BY A VARIABLE CALLED "METHOD"
C  WHICH IS INPUT BY THE USER. THE FOLLOWING METHODS ARE AVAILABLE
C
C  METHOD          DESCRIPTION OF METHOD
C
C     1       IONOSPHERIC PARAMETERS
C     2       IONOGRAMS
C     3       MUF-FOT LINES (NOMOGRAM)
C     4       MUF-FOT GRAPH
C     5       HPF-MUF-FOT GRAPH
C     6       MUF-FOT-ES GRAPH
C     7       FOT-MUF TABLE (FULL IONOSPHERE)
C     8       MUF-FOT GRAPH
C     9       HPF-MUF-FOT GRAPH
C    10       MUF-FOT-ANG GRAPH
C    11       MUF-FOT-ES GRAPH
C    12       MUF BY MAGNETIC INDICES, K. (N O T E  NOT YET IMPLEMENTED)
C    13       TRANSMITTER ANTENNA PATTERN
C    14       RECEIVER ANTENNA PATTERN
C    15       BOTH TRANSMITTER AND RECEIVER ANTENNA PATTERNS
C    16       SYSTEM PERFORMANCE  (S.P.)
C    17       CONDENSED SYSTEM PERFORMANCE, RELIABILITY
C    18       CONDENSED SYSTEM PERFORMANCE, SERVICE PROBABILITY
C    19       PROPAGATION PATH GEOMETRY
C    20       COMPLETE SYSTEM PERFORMANCE (C.S.P.)
C    21       FORCED LONG PATH MODEL (C.S.P.)
C    22       FORCED SHORT PATH MODEL (C.S.P.)
C    23       USER SELECTED OUTPUT LINES (SET BY TOPLINES AND BOTLINES)
C    24       MUF-REL TABLE
C    25       ALL MODES TABLE
C    26       MUF-LUF-FOT TABLE (NOMOGRAM)
C    27       FOT-LUF GRAPH
C    28       MUF-FOT-LUF-GRAPH
C    29       MUF-LUF GRAPH
C***********************************************************************
C
C  THE USER SUPPLIED INPUT TO THE PROGRAM IS CARD IMAGES WHICH CONTAIN
C  A CARD "NAME IDENTIFIER" USED TO IDENTIFY THE INPUT PARAMETERS
C  THE FOLLOWING "NAME IDENTIFIERS" ARE IMPLEMENTED
C
C     IDENTIFIER             DESCRIPTION OF INPUT PARAMETERS
C
C     METHOD            PROGRAM RUN OPTION AND BEGINNING PAGE NUMBER
C     MONTH             YEAR AND A LIST OF UP TO 12 MONTHS
C     SUNSPOT           LIST OF SUNSPOTS (ALL MONTHS ARE RUN FOR EACH)
C     CIRCUIT           TRANSMITTER-RECEIVER LOCATIONS
C     SYSTEM            POWER, NOISE, MIN.ANGLE, RELIAB, SNR, TIME DELAY
C     TIME              TIME OF DAY LOOP (AND INDICATOR FOR LMT OR UT)
C     ANTENNA           TRANSM OR RECEIVER, ANTENNA TYPE AND PARAMETERS
C     FREQUENCY         FREQUENCIES (THIS SET WILL INSERT FOT)
C     LABEL             ALPHANUMERIC LABEL FOR IDENTIFICATION
C     INTEGRATE         .GE. 0 FOR FAST INTEGRATION FOR E-F2 (NO F1)
C     EXECUTE           EXECUTE PROGRAM WITH PARAMETERS CURRENTLY SET
C     ANTOUT            WRITE ANTENNA PATTERNS ON A FILE
C     OUTGRAPH          REQUEST OUTPUT OF SEVERAL METHODS
C     COMMENT           COMMENT CARD IN INPUT STREAM
C     QUIT              TERMINATION OF PROGRAM EXECUTION
C     FPROB             CRITICAL FREQUENCY MULTIPLIERS
C     TOPLINES          USER SPECIFIED HEADING LINES (FOR METHOD 23)
C     BOTLINES          USER SPECIFIED OUTPUT LINES (FOR METHOD 23)
C     (USER DEFINED PROCEDURE NAME) REPLACE PROCEDURE NAME WITH ITS DEFN
C***********************************************************************
      COMMON/PCVERS/ VERSN
      CHARACTER VERSN*8
      common /cQUIET/ iquiet
      common /c_S_to_I/ i_S_to_I    !  = 1 = S/I calculation
      common /chours/ nhours,ihours(24)
      common /cantenna/ numants,iats(20),anttype(20),antname(20),
     +                  xfqs(20),xfqe(20),designfreq(20),antfile(20),
     +                  beammain(20),offazim(20),cond(20),diel(20),
     +                  array(30,91,20),dumant(60,91),aeff(30,20)
      character anttype*10,antname*70,antfile*24

      COMMON /ALPHA/ IMON(12),IRCVR(2),ITRAN(2),MODE(13),MODER(13)
      CHARACTER IMON*3,IRCVR*10,ITRAN*10,MODE*2,MODER*2
      COMMON /SOLAR/IYR,IMO,IDA,SSN,EFFQ,EFFKP,JUDAY,CHI(5),
     A TCGMT(5),PBT(5),CENT(5),EBT(5)
      COMMON / CONTRL /  KTOUT(12), MONTHS(12), SUNSP(12),
     A IANTOU, INTEG, ISOUT, JDASH, JFREQ, JLONG, MAXNAM, MAXMET
      COMMON /TIME / IT,GMT,UTIME(24),GMTR,XLMT(24),ITIM
      COMMON / ION /  IEA, IFQB, IFQE, IGRAPH, IHRE, IHRO, IHRS, JO,
     A LUFP, METHOD, MONPR, NDAY, NES, NOISE, NPAT, NPSL, NRSP, NUMO
      COMMON / RTANT /TEFF,REFF,KASANT(2)
      COMMON/LPATH/GCDLNG,TGML(45),RGML(45),DELOPT,GMIN,YMIN,LTGM,LRGM
      COMMON / DON /  AMIND, DMP, PMP, RSN, ATMNO,
     1                D90R, D50R, D10R, D90S, D50S, D10S
      COMMON /METSET/ITRUN,ITOUT,JTRUN(40),JTOUT(40)
C    MUF VALUES, SEE SUBR. NOMMUF AND CURMUF.
      COMMON/MUFS/EMUF(24),F1MUF(24),F2MUF(24),ESMUF(24),ALLMUF(24)
     A,FOT(24),XLUF(24),HPF(24),ANGMUF(24),MODMUF,SIGL(4),SIGU(4),DELMUF
     B (4),HPMUF(4),HTMUF(4),FVMUF(4),AFMUF(4),NHOPMF(4),YFOT(4),YHPF(4)
     C ,YMUF(4)
C FREQUENCY COMPLEMENT,SEE SUBR. HFMUFES.
      COMMON / FRQ / FREL(29), FREQ, JMODE
      common /cnfreqs/ nfreqs
C GEOGRAPHIC AND IONSPHERIC DATA AT SAMPLE AREAS,SEE GEOM AND GENION.
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
      COMMON /FILES/ LUO,LUI,LU25,LU26
      COMMON /CON /D2R, DCL, GAMA, PI, PI2, PIO2, R2D, RO, VOFL
      COMMON /COORDS/ XCG(2,36,89)
      COMMON /RGRID/ IPROJ,PLAT,PLON,XMIN,XMAX,YYMIN,YMAX,NX,NY
      COMMON /REC_DEG/ RLATD,RLONGD,TLATD,TLONGD
      common /carea/ area
         character area*1
      common /cdistance/ idistance,ndistance,ihr    !  plot vs distance
      common /ctime/ ntime                          !  plot vs time
      common /csystem/ system_type
      character system_type*4
      common /cdaily/ idaily
      common /Charris/ iharris    !  =1=harris99.exe exists
      common /Cmspec/ mspec      !  for Short/Long path smoothing

      CHARACTER IONINP*64,IONFOT*64,areafile*30,daily*3,areach*1
      character file_batch*64,PROGRAM*300
      character version*8,message*80,file_si*64
      character run*50
      character cmnam*64,title*80,alf*20,ich*1,area_meth*1,dum*1
      integer*4 window_handle
      integer*2 x_pos,y_pos,xsize,ysize,istat
      real*8 start_time,end_time
      common /crun_directory/ run_directory
         character run_directory*50
      character alf_narea_batch*4,alf_iarea_batch*4
      character alf_elapsed_time*8,alf_fileout*50
      common /Cprogress/ iarea_batch,alf_label
         character alf_label*80
      common /Ccancel_batch/ icancel_batch
      external cancel_batch
      character alf80*80,append*1
      integer (kind=3) count_underflow
      logical (kind=2) permission
ccc      INTEGER*2 ICG
      system_type='DOS '
*     system_type='UNIX'
      system_type='WIN '
      call permit_underflow@(.true.)
      
C.....START OF PROGRAM
      run=cmnam()
      nch=lcount(run,50)
ccc      write(*,'(''run='',a)') run
      if(run(1:).eq.'/noise') go to 1930  !  display noise card information
      if(nch.lt.3) go to 930
      call ucase(run,nch)
      iquiet=0
      if(run(1:6).eq.'SILENT') then     !  do not create output window
         iquiet=1
         run=cmnam()
         nch=lcount(run,50)
         if(nch.lt.3) go to 930
      end if
c******************************************************
      permission=.true.    !  ignore underflows
ccc      permission=.false.   !  halt when underflow
      call permit_underflow@(permission)
c******************************************************
      if(iquiet.eq.0) then
         title='ICEPAC output'
         xsize=GetSystemMetrics(SM_CXSCREEN)
         ysize=GetSystemMetrics(SM_CYSCREEN)/3
         x_pos=0
         y_pos=0
         window_handle=create_window(title,x_pos,y_pos,xsize,ysize)
         ier=set_default_window@(window_handle)
      end if
c****************************************************************
      ionce=0
      run_directory=run(1:nch)//'\RUN'
ccc      call get_run           !  get current working directory
      call set_run           !  set to the ..\RUN directory
      nch_run=lcount(run_directory,50)
      if(iquiet.eq.0)
     +write(*,'('' Executing from dir='',a)') run_directory(1:nch_run)
c******************************************************
      ierase=0    !  do not erase
      alf='ERASE debug window'
      open(21,file=run_directory(1:nch_run-3)//
     +        'database\debug.txt',status='old',err=1111)
      rewind(21)
      read(21,'(a)') alf
      close(21)
1111  if(alf(1:18).eq.'ERASE debug window') ierase=1  !  do erase
c******************************************************
c****************************************************************
ccc      open(66,file=run_directory(1:nch_run)//'\icepac.dmp')
ccc      rewind(66)
c****************************************************************
      iharris=it_exist(run_directory(1:nch_run-3)//
     +                 'bin_win\harris99.exe')
c****************************************************************
      areach=' '
      i_S_to_I=0           !  =1= S/I calculations
      iarea_batch=0
      icancel_batch=0
         ioninp=cmnam()
         if(ioninp(1:1).eq.' ') ioninp='icepacx.dat'
         call lcase(ioninp,20)
         if(ioninp(1:5).eq.'area '.or.ioninp(1:4).eq.'inv ') then !area coverage
            areach='A'
            if(ioninp(1:1).eq.'i') areach='I'     !  inverse area coverage
            area_meth=cmnam()
            ioninp=cmnam()
            call lcase(ioninp,20)
            if(ioninp(1:12).eq.'iceareaw.cir') then    !  batch area coverage
               call seconds_since_1980@(start_time)    !  use to calc time
               iarea_batch=iarea_batch+1
               open(61,file=run_directory(1:nch_run)//'\'//ioninp,
     +              status='old',err=920)
               rewind(61)
c******************************
            call count_batch(61,narea_batch)  !  count # files to process
            write(alf_narea_batch,'(i4)') narea_batch
            write(alf_iarea_batch,'(i4)') iarea_batch
            call seconds_since_1980@(end_time)    !  use to calc time
            elapsed=end_time-start_time
            write(alf_elapsed_time,'(f8.1)') elapsed/60.
            k=winio@('%ca[Batch ICEPAC Area calculations progress]&')
            alf_fileout=' '
            k=winio@('fileout= %50st&',alf_fileout)
            alf_label=' '
            k=winio@('%nl%80st&',alf_label)
            k=winio@('%nl%nl%cnCalculating file %tc[red]%4st %tc[black]'
     +               //' of '//alf_narea_batch//'&',alf_iarea_batch)
            k=winio@('%nl%cnElapsed time: %tc[red]%8st %tc[black]'//
     +               'minutes&',alf_elapsed_time)
            icancel_batch=0
            k=winio@('%nl%nl%cn%^bt[&Cancel]&',cancel_batch)
            k=winio@('%lw',iprocess_ctrl)      !  leave window open
c******************************
               read(61,'(a)',end=999) ioninp
             if(iquiet.eq.0) write(*,39) iarea_batch,narea_batch,ioninp
39           format(' BATCH area file(',i4,' of ',i4,'):',a)
            end if
            ionfot='iceareax'
            call areamap(areach,ioninp,ionfot,area_meth)
            ioninp='iceareax.da1'
            ionfot='..\AREADATA\'
            if(areach.eq.'I') ionfot='..\AREA_INV\'
         else if(ioninp(1:6).eq.'batch ') then       !  Batch point-to-point
            areach='B'
            file_batch=cmnam()       !  is this "new" Special batch?
            if(file_batch(1:1).ne.' ') areach='S'    !  YES!!!
            ioninp='icepacx.dat'
            ionfot=cmnam()
            if(ionfot(1:1).eq.' ') ionfot='ICEPACB.OUT'
            nch_fot=lenchar(ionfot)
c             !  delete any previous file
            call erase@(run_directory(1:nch_run)//'\'//
     +                  ionfot(1:nch_fot),istat)
            if(istat.ne.0 .and. iquiet.eq.0) then
               write(*,'('' run_dir='',a)') run_directory
               call dos_error_message@(istat,message)
               write(*,'('' istat='',i5,1h=,a)') istat,message
               write(*,'('' file='',a)') run_directory(1:nch_run)//
     +                                   '\'//ionfot(1:nch_fot)
            end if
         else
            ionfot=cmnam()
            if(ionfot(1:1).eq.' ') ionfot='icepacx.out'
            call lcase(ionfot,20)
         end if
      if(IONINP(1:1).eq.' ' .or. IONFOT(1:1).eq.' ')
     +          stop 'Must execute with: icepacw filein fileout'

      append=cmnam()      !  should we append to output file
      if(append.eq.'A') append='a'

      area=areach
      if(area.eq.'a') area='A'
      if(area.eq.'i') area='I'
      iabort=0
      call del_abt     !  delete the icepac.abt & icearea.abt files
c****************************************************************
40    if(area.eq.'A' .or. area.eq.'I') then     !  area coverage calculations
         OPEN(8,file=run_directory(1:nch_run)//'\'//IONINP,
     +        STATUS='OLD',FORM='FORMATTED')
         rewind(8)
         read(8,'(20x,a)') areafile     !  get real file name of output
         close(8)
         nch=lcount(ionfot,40)
         nch2=lcount(areafile,30)
         nch3=lcount(ioninp,20)
         areafile(nch2-2:nch2)='ig'//ioninp(nch3:nch3)
         ionfot(nch+1:nch+nch2)=areafile(1:nch2)
ccc         ionfot='ICEAREAx.out'
      else if(area.eq.'B') then              !  Batch point-to-point
         call read_asc('ICEPAC',*999)   !  read pt-pt common from ICEPACW.ASC
         open(38,file=run_directory(1:nch_run)//'\'//'icepac.cir',
     +        status='old',err=999)
         rewind(38)
         read(38,'(a)',err=999) dum     !  skip 1st record
         icircuit=0
         if(iquiet.eq.0)
     +   write(*,'('' Output is being written to: '',a,/)')
     +                ionfot(1:nch_fot)
         call batch(38,'ICEPAC',ioninp,icircuit,*999)
      else if(area.eq.'S') then           !  New SPECIAL batch
         nch_batch=lcount(file_batch,64)
         open(38,file=run_directory(1:nch_run)//'\'//
     +        file_batch(1:nch_batch),status='old',err=999)
         if(iquiet.eq.0)
     +   write(*,'('' Output is being written to: '',a,/)')
     +                ionfot(1:nch_fot)
         icircuit=0
         call batch_S(38,'ICEPAC',ioninp,icircuit,*999)
      else
      end if
c****************************************************************
50    nch_inp=lcount(ioninp,64)
      if(it_exist(run_directory(1:nch_run)//'\'//ioninp(1:nch_inp))
     +    .eq.0) go to 950     !  if it does not exist, quit
      if(iquiet.eq.0) then
         if(ioninp(1:7).eq.'icepacw') write(*,51) 'WANTED  '
         if(ioninp(1:7).eq.'icepacu') write(*,51) 'UNWANTED'
51       format(' Calculating ',a,' signal')
      end if
      call antcalc(ioninp,area)
c****************************************************************
      if(iquiet.eq.0) then
         if(area.eq.'A') then
            write(*,'('' Area filein ='',a)') ioninp
         else if(area.eq.'I') then
            write(*,'('' Inverse Area filein ='',a)') ioninp
         end if
      end if
      nch_inp=lcount(ioninp,64)
      OPEN(8,FILE=run_directory(1:nch_run)//'\'//IONINP(1:nch_inp),
     +     STATUS='OLD',FORM='FORMATTED',err=900)
      nch_fot=lcount(ionfot,64)
      ndistance=1
      if(ionfot(1:11).eq.'ICEPACD.OUT' .or.
     +   IONFOT(1:11).eq.'icepacd.out') ndistance=51  !  plot vs distance
      ntime=0
      if(ionfot(1:11).eq.'ICEPACT.OUT' .or.
     +   IONFOT(1:11).eq.'icepact.out') ntime=1       !  plot vs time
      if(areach.eq.'B' .or. areach.eq.'S') then       !  batch, use APPEND
         OPEN(9,file=run_directory(1:nch_run)//'\'//IONFOT(1:nch_fot),
     +        status='APPEND')
      else if(ionfot(1:2).eq.'..') then
         if(iquiet.eq.0) write(*,'('' Area fileout='',a)')
     +                run_directory(1:nch_run-3)//IONFOT(4:nch_fot)
         if(iarea_batch.ne.0) then
            alf_fileout='..\'//IONFOT(4:nch_fot)
            call window_update@(alf_fileout)
         end if
         OPEN (9,file=run_directory(1:nch_run-3)//IONFOT(4:nch_fot)) 
         rewind(9)
      else if(append.eq.'a') then
         OPEN(9,file=run_directory(1:nch_run)//'\'//IONFOT(1:nch_fot),
     +        status='APPEND')
      else
         OPEN (9,file=run_directory(1:nch_run)//'\'//IONFOT(1:nch_fot)) 
         rewind(9)
      end if
      OPEN(12,FILE=run_directory(1:nch_run-3)//'coeffs\CGLALO.DAT',
     +     STATUS='OLD',err=910)
      READ(12,'(8f6.1)') XCG
      CLOSE(12)
      if(ndistance.gt.1) then
         OPEN(48,file=run_directory(1:nch_run)//'\ICEPACD.IDX')
         rewind(48)
         call erase@(run_directory(1:nch_run)//'\ICEPACD.DST',istat)
         OPEN(49,file=run_directory(1:nch_run)//'\ICEPACD.DST',
     +        access='direct',form='unformatted',recl=108)
      end if
      if(ntime.ne.0) then
         OPEN(48,file=run_directory(1:nch_run)//'\ICEPACT.IDX')
         rewind(48)
         call erase@(run_directory(1:nch_run)//'\ICEPACT.DST',istat)
         OPEN(49,file=run_directory(1:nch_run)//'\ICEPACT.DST',
     +        access='direct',form='unformatted',recl=96)
      end if
c***********************************************************
      open(12,file=run_directory(1:nch_run-3)//'database\version.'//
     +     COMPILER,status='old')
      rewind(12)
      read(12,'(8x,a)') version
      close(12)
      VERSN=version(1:2)//version(4:8)
c****************************************************************
  100 CALL DECRED
      IF(ITRUN .LE. 0) GO TO 9000
      daily='   '
      if(idaily.ne.0) write(daily,'(1h.,i2.2)') idaily
      if(area.eq.'A' .or. area.eq.'I') go to 1000   ! area coverage calculations
      if(iquiet.eq.0)
     +write(*,101) method,IMON(IMO),daily,nint(ssn),effQ,
     +             (nint(frel(if)),if=1,11)
101   format(' Method',i3,1x,2a3,i4,'ssn',f4.1,'Q Freqs=',11i3)
      if(i_S_to_I.ne.0) then          !  S/I calculation, open output file
         file_si=ionfot
         nch=lcount(file_si,64)
         file_si(nch-3:nch)='.si '
         if(ionce.eq.0) then
            open(18,file=run_directory(1:nch_run)//'\'//file_si(1:nch))
            rewind(18)
            ionce=1
         end if
         do if=1,11            !  count # of frequencies
            if(frel(if).gt..1) nf=if
         end do
         write(18,102) METHOD,IMO,nint(SSN),nf,(frel(if),if=1,nf)
102      format('Method    ',4i5,11f7.3)
      end if
c******************************************************************
c          check to see if we should abort processing
      if(it_exist(run_directory(1:nch_run)//'\icepac.abt').ne.0) then
         call erase@(run_directory(1:nch_run)//'\icepac.abt',istat)
         iabort=1         !  indicate we have aborted batch processing
         go to 999        !  quit processing
      end if
      if(icancel_batch.ne.0) then
         iabort=1         !  indicate we have aborted batch processing
         go to 999        !  quit processing
      end if
c******************************************************************
      IF(ITRUN .eq. 6) then
	 call OUTANT
         GO TO 100
      end if
      if(ndistance.ne.1) then       !  plots vs DISTANCE
         do if=1,11            !  count # of frequencies
            if(frel(if).gt..1) nfreqs=if
         end do
         write(48,'(i5,'' distances'')') ndistance
         write(48,'(i2,11f7.3)') nfreqs,(frel(i),i=1,nfreqs)
         write(48,'(25i3)') nhours,(ihours(i),i=1,nhours)
         write(48,103)
 103     format(' 24 MODE  MUF   FOT   ANGLE DELAY VHITE MUFdayLOSS  ',
     +              'DBU   SDBW  NDBW  SNR   RPWRG REL   MPROB SPRB  ',
     +              'SIGLW SIGUP SNRLW SNRUP TGAIN RGAIN SNRxx DBM   ')
         if(iquiet.eq.0) then
            write(*,'('' Calculating Distance plot'')')
            call soua@(' UT[')
         end if
      end if
      if(ntime.ne.0) then       !  plots vs TIME
         do if=1,11            !  count # of frequencies
            if(frel(if).gt..1) nfreqs=if
         end do
         write(48,'(i2,11f7.3)') nfreqs,(frel(i),i=1,nfreqs)
         write(48,103)
         if(iquiet.eq.0) write(*,'('' Calculating Time plot'')')
      end if
      rlat_dist=rlat
      rlon_dist=rlong
      DO 405 ihr = 1,nhours         !  put hour as outside loop
      JT=ihours(ihr)
      if(ndistance.ne.1 .and. iquiet.eq.0) then
         write(alf,'(i3)') JT
         call soua@(alf)
      end if
      do 400 idistance=1,ndistance
      if(idistance.eq.1) then
         rlat=rlat_dist
         rlong=rlon_dist
      else
         CALL distxy(idistance,ndistance,tlat,tlong,rlat_dist,rlon_dist,
     +               npsl,RLATD,RLONGD)
         if(abs(RLATD-TLAT/D2R).lt..01 .and. 
     +      abs(RLONGD-TLONG/D2R).le..01) then  !  Tx & Rx cannot be same point
            RLONGD=TLONG/D2R+.01
            if(RLONGD.ge.360.) RLONGD=RLONGD-360.
         end if
         RLONG=RLONGD*D2R
         RLAT =RLATD *D2R
         if(abs(RLATD).gt.89.9) RLONG=0.    !  at poles, force long=0
      end if
      if(ndistance.eq.1) then
         if(ihr.eq.1) then
            CALL GEOM(NPSL)
            CALL IONPA1(DUM1,DUM2,DUM3,1)
            CALL SETOUT
         end if
      else
         CALL GEOM(NPSL)
         CALL IONPA1(DUM1,DUM2,DUM3,1)
         CALL SETOUT
      end if
      IFREQ=FREL(14)
      call yieldit             !  yield for Windows operations
      CALL GEOTIM(ITIM,JT)
      CALL IONPA2(1,DUM1)
      CALL IONVAL
      IF(ITRUN .le. 1) then
         CALL OUTPAR
         GO TO 300
      end if
      CALL IONSET
      IF(ITRUN .le. 2) then
         CALL OUTION
         GO TO 300
      end if
      IF(ITRUN .le. 3) then
         CALL NOMMUF
         GO TO 300
      end if
      CALL CURMUF(integ)
      IF(ITRUN .EQ. 4) GO TO 300
      IF(ITRUN .EQ. 5) GO TO 410
      IF(ITRUN .EQ. 6) GO TO 300
      IF(ITRUN .GT. 7) GO TO 250
      IF(IFREQ .gt. 0) then
         FREL(12)=ALLMUF(IT)
      else
         CALL FRQCOM(FREL,IFREQ)
      end if
      IF(GCDKM .GE. GCDLNG) GO TO 240
      IF(METHOD .EQ. 21) GO TO 245
  230 CALL LUFF(1)
      CALL SETLUF
      GO TO 300
  240 IF(METHOD .EQ. 22) GO TO 230
  245 CALL LUFF(2)
      CALL SETLUF
      GO TO 300
  250 IF(ITRUN .GT. 8) GO TO 300
      IF(GCDKM .GE. GCDLNG) GO TO 260
      CALL LUFF(3)
      GO TO 300
  260 CALL LUFF(4)
  300 CONTINUE
      IF(ITOUT .EQ. 7) CALL OUTLIN
      IF(ITOUT .EQ. 8) CALL OUTTAB
      IF(ITOUT .EQ. 10) CALL OUTLAY
  400 CONTINUE
  405 CONTINUE
  410 IF(ITOUT .EQ. 3) CALL OUTMUF
      IF(ITOUT .EQ. 4) CALL OUTGPH
C     IF(ITOUT .EQ. 11) CALL OUTCOM
C     IF(ITRUN .EQ. 5) CALL OUTKMF
      IF(ISOUT .LE. 0) GO TO 100
      IF(ITRUN .GT. 2 .AND. ITRUN .LT. 5) GO TO 420
      IF(ITRUN .LT. 7) GO TO 100
  420 ITEMP=METHOD
      JTEMP=ITRUN
      KTEMP=ITOUT
      DO 450 I=1,12
      METHOD=KTOUT(I)
      IF(METHOD .EQ. ITEMP) GO TO 450
      IF(METHOD .LT. 1 .OR. METHOD .GT. 30) GO TO 450
      ITOUT=JTOUT(METHOD)
      ITRUN=JTRUN(METHOD)
      IF(ITRUN .NE. 8) GO TO 425
      IF(JTEMP .LT. 7) GO TO 450
  425 IF(ITOUT .EQ. 3) CALL OUTMUF
      IF(ITOUT .EQ. 4) CALL OUTGPH
  450 CONTINUE
      METHOD=ITEMP
      ITRUN=JTEMP
      ITOUT=KTEMP
      GO TO 100
c**************************************************************
1000  nfreqs=1                             !  area coverage output
      do 1005 nfreqs=1,11
      if(frel(nfreqs).le.0.) go to 1006
1005  continue
1006  nfreqs=nfreqs-1
      call outarea(-nx,-ny)
      meth=method
      if(mspec.ne.0) meth=30        !  Short/Long path smoothing
      if(iquiet.eq.0) then
      if(nfreqs.eq.1) then
         write(*,1001) meth,IMON(IMO),daily,nint(SSN),EFFQ,frel(1)
1001     format(20x,'Method',i3,1x,2a3,i4,'ssn',f5.1,'Q  Freq=',f6.2)
      else
         write(*,1002) meth,IMON(IMO),daily,nint(SSN),EFFQ,nfreqs
1002     format(20x,'Method',i3,1x,2a3,i4,'ssn',f5.1,'Q  ',
     +        'max of',i3,' Freqs')
      end if
      end if
      if(area.ne.'A') then     !  inverse Area Coverage (change Tx)
         rlat=tlat
         rlong=tlong
         rlatd=tlatd
         rlongd=tlongd
         if(iquiet.eq.0) write(*,'(''Area Inverse'')')
      end if
      DO 1910 IY=1,NY
      if(system_type.eq.'UNIX') then
*        call lineup
      end if
      if(system_type.eq.'WIN ') then
         if(iquiet.eq.0) then
            if(iy.eq.1) then
               write(alf,'(i3,'' rows['',i2)') ny,iy
            else
               write(alf,'(i3)') iy
            end if
            call soua@(alf)
            if(mod(iy,20).eq.0) then
               call sou@(' ')            !  cause a <new line>
               call coua@('        ')    !  space over to line things up
            end if
         end if
c          check to see if we should abort processing
c          if file exists, abort processing
      if(it_exist(run_directory(1:nch_run)//'\icearea.abt').ne.0) then
            call erase@(run_directory(1:nch_run)//'\icearea.abt',istat)
            iabort=1         !  indicate we have aborted batch processing
            go to 999        !  quit processing
         end if
      if(icancel_batch.ne.0) then
         iabort=1         !  indicate we have aborted batch processing
         go to 999        !  quit processing
      end if
      else
         write(*,1003) iy,ny
1003     format('+Calc row',i3,1h/,i2)
      end if
      DO 1900 IX=1,NX
      call yieldit             !  yield for Windows operations
      if(area.eq.'A') then     !  normal Area Coverage (change Receiver)
         CALL GRIDXY(IX,IY,RLONGD,RLATD)      !  GET LON/LAT of RECEIVER
         if(abs(RLATD-TLAT/D2R).lt..05 .and. 
     +      abs(RLONGD-TLONG/D2R).le..05) then
            RLONGD=TLONG/D2R+.05
            if(RLONGD.ge.360.) RLONGD=RLONGD-360.
         end if
         if(abs(RLATD).gt.89.9) RLONGD=0.    !  at poles, force long=0
         RLONG=RLONGD*D2R
         RLAT =RLATD *D2R
         if(abs(RLATD).gt.89.9) RLONG=0.    !  at poles, force long=0
      else                     !  Inverse Area Coverage (change Transmitter)
         CALL GRIDXY(IX,IY,TLONGD,TLATD)      !  GET LON/LAT of RECEIVER
         if(abs(TLATD-RLAT/D2R).lt..05 .and. 
     +      abs(TLONGD-RLONG/D2R).le..05) then
            TLONGD=RLONG/D2R+.05
            if(TLONGD.ge.360.) TLONGD=TLONGD-360.
         end if
         if(abs(TLATD).gt.89.9) TLONGD=0.    !  at poles, force long=0
         TLONG=TLONGD*D2R
         TLAT =TLATD *D2R
         call dazel0(tlatd,tlongd,rlatd,rlongd,ztaz,dist)
         beammain(1)=ztaz       !  set main beam antenna direction
      end if
      do 1010 i=1,24
1010  allmuf(i)=-1.
      CALL GEOM(NPSL)
      CALL IONPA1(DUM1,DUM2,DUM3,1)
      CALL SETOUT
      IFREQ=FREL(14)
      JT=ihours(1)
      CALL GEOTIM(ITIM,JT)
      CALL IONPA2(1,DUM1)
      CALL IONVAL
      CALL IONSET
      CALL CURMUF(integ)
      IF(IFREQ .gt. 0) then
         FREL(12)=ALLMUF(IT)
      else
         CALL FRQCOM(FREL,IFREQ)
      end if
ccc      write(66,'(''ix,iy='',4i5,2f10.4,f10.2)') 
ccc     +                method,mspec,ix,iy,rlatd,rlongd,gcdkm
c           changed 12/6/2016 from GE to GT to match what is in LUFF for smoothing
      IF(GCDKM .GT. GCDLNG) GO TO 1240
      IF(METHOD .EQ. 21) GO TO 1245           !  forced LONG path model
 1230 CALL LUFF(1)
      GO TO 1300
 1240 IF(METHOD .EQ. 22) GO TO 1230           !  forced SHORT path model
 1245 CALL LUFF(2)
 1300 CONTINUE
      CALL SETLUF
      call outarea(ix,iy)
C==================================================================
1900  CONTINUE
1910  CONTINUE
      if(system_type.eq.'WIN ' .and. iquiet.eq.0) call sou@(']')
9000  CLOSE(8)
      CLOSE(9)
      if(i_S_to_I.ne.0) close(18)     !  close special S/I output file
      if(ndistance.ne.1) then         !  close distance plot files
         close(49)
         close(48)
         if(iquiet.eq.0) call sou@(']')
      end if
c**************************************************************
c          do we need to PLOT the result?
c**************************************************************
      if((area.eq.'A'  .or. area.eq.'I') .and. 
     +   (area_meth.eq.'p' .or. area_meth.eq.'s'))then
         if(iquiet.eq.0) write(*,'('' Plotting:'',a)') ionfot
         nchf=lcount(ionfot,64)
         PROGRAM=run_directory(1:nch_run-3)//
     +             'bin_win\worldwin.exe '//
     +             run_directory(1:nch_run)//' '//ionfot(4:11)//' '//
     +             ionfot(13:nchf)//' '//
     +             area_meth
         nch=lcount(PROGRAM,300)
         call gh_exec(PROGRAM,nch,1)   !  execute and wait for WORLDWIN.EXE
      end if
c**************************************************************
      if(area.eq.'A' .or. area.eq.'I') then!  area coverage, more files?
         ich=ioninp(nch3:nch3)
         if(ich.eq.'9') then    !  no, we are done
            go to 950
         else             !  process next file in order
            ich=char(ichar(ich)+1)
            ioninp(nch3:nch3)=ich     !  new name of input file
            nch=lcount(ionfot,40)
            ionfot(nch:nch)=ich       !  new name of output file
            go to 50      !  calculate another file
         end if
      else if(area.eq.'B') then!  Batch point-point, next circuit
         call batch(38,'ICEPAC',ioninp,icircuit,*999)
         go to 50         !  process next batch circuit
      else if(area.eq.'S') then   !New Batch point-to-point, next circuit
         call batch_S(38,'ICEPAC',ioninp,icircuit,*999)
         go to 50                !  process next batch circuit
      else                !  point-to-point, view results
      end if
      if(ioninp(1:12).eq.'icepacwx.dat' .or.
     +   ioninp(1:12).eq.'icepacwg.dat') then    !  need to process UNWANTED
         ioninp(7:7)='u'
         ionce=0
         ionfot(7:7)='u'
         go to 50
      end if
      go to 999
900   write(*,901) IONINP
901   format(' Could not OPEN file=',a)
      stop 'OPEN error in icepacw at 900'
910   write(*,901) '..\coeffs\CGLALO.DAT'
      stop 'OPEN error in icepacw at 910'
920   write(*,901) 'iceareaw.cir  for BATCH calculations'
      stop 'OPEN error in icepacw at 920'
c***********************************************************************
930   call get_run
      nchd=lenchar(run_directory)
      if(iquiet.eq.0)
     +write(*,'(''run_directory='',a)') run_directory(1:nchd)
      open(71,file=run_directory(1:nchd-3)//'news_win\command.txt',
     +        status='old',err=940)
      rewind(71)
935   read(71,'(a)',end=936) alf80
      nch=lenchar(alf80)
      if(nch.eq.0) nch=1
      if(iquiet.eq.0) write(*,'(a)') alf80(1:nch)
      go to 935
936   close(71)
940   stop 'ICEPACW.EXE not executed properly.'
c***********************************************************************
1930  call get_run
      nchd=lenchar(run_directory)
      if(iquiet.eq.0)
     +write(*,'(''run_directory='',a)') run_directory(1:nchd)
      open(71,file=run_directory(1:nchd-3)//'database\noise_card.txt',
     +        status='old',err=1940)
      rewind(71)
1935  read(71,'(a)',end=1936) alf80
      nch=lenchar(alf80)
      if(nch.eq.0) nch=1
      if(iquiet.eq.0) write(*,'(a)') alf80(1:nch)
      go to 1935
1936  close(71)
1940  stop 'ICEPACW.EXE noise card information.'
c***********************************************************************
950   if(iarea_batch.eq.0) go to 999      !  not area coverage batch run
      if(icancel_batch.ne.0) go to 999
         read(61,'(a)',end=999) ioninp
         iarea_batch=iarea_batch+1
         if(iquiet.eq.0) write(*,39) iarea_batch,narea_batch,ioninp
         write(alf_iarea_batch,'(i4)') iarea_batch
         call window_update@(alf_iarea_batch)
         call seconds_since_1980@(end_time)    !  use to calc time
         elapsed=end_time-start_time
         write(alf_elapsed_time,'(f8.1)') elapsed/60.
         call window_update@(alf_elapsed_time)
         ionfot='iceareax'
         call areamap(area,ioninp,ionfot,area_meth)
         areach=area
         ioninp='iceareax.da1'
         ionfot='..\AREADATA\'
         if(areach.eq.'I') ionfot='..\AREA_INV\'
         go to 40      !  begin next area calculation
999   continue
      if(iarea_batch.ne.0) then      !  batch area finish
         idone=iarea_batch           !  number of files done
         if(iabort.ne.0 .or. icancel_batch.ne.0) then
            write(*,'(1x)')
            idone=idone-1            !  current one was not done
         end if
         iprocess_ctrl=0
         call window_update@(iprocess_ctrl)    !  remove process message
         call seconds_since_1980@(end_time)    !  use to calc time
         elapsed=end_time-start_time
         if(iquiet.eq.0) write(*,997) idone,elapsed/60.
997      format(50(1h*),/,
     +          i5,' BATCH Area calculations done.',f10.1,' minutes',/,
     +          50(1h*))
      end if
      if(area.ne.'B'.and.iarea_batch.eq.0)then!don't destroy BATCH output window
         if(ierase.ne.0) call destroy_window(window_handle)
      else
         if(iabort.ne.0) write(*,998)
998                      format(/,' Batch processing has been aborted.')
      end if
      call underflow_count@(count_underflow)  !  see if any underflows occured
ccc      write(*,'(''underflow='',i8)') count_underflow
      END
c--------------------------------------------------------------
