c# lecden.f
      SUBROUTINE LECDEN(II)
C***********************************************************************
C*         PURPOSE:   THIS SUBROUTINE COMPUTES AN ELECTRON DENSITY     *
C*                    PROFILE BY CALLING SUPPRO.  SEVERAL PARAMETERS   *
C*                    ARE FIRST CALCULATED.  SUPPRO RETURNS AN ARRAY   *
C*                    OF PLASMA DENSITIES WHICH ARE CONVERTED INTO     *
C*                    ELECTRON DENSITIES.                              *
C*         METHOD:  1. CALCULATE SOLAR ZENITH ANGLE AND LOCAL TIME.    *
C*                                                                     *
C*                  2. CALL HTF2 TO DETERMINE THE THICKNESS OF THE F2  *
C*                     LAYER.                                          *
C*                                                                     *
C*                  3. CALL SUPPRO TO DETERMINE THE PLASMA DENSITIES,  *
C*                     WHICH ARE USED AS ELECTRON DENSITIES.           *
C*                                                                     *
C*         CALLED:  HTF2 - TO DETERMINE F2-LAYER THICKNESSSES          *
C*                  SUPPRO- TO DETERMINE DENSITY PROFILES              *
C*                                                                     *
      COMMON /USERP/ IELECT(3), UHI(54,3), UFQ(54,3)
      COMMON /RON /RAT(5),CLCK(5),ABIY(5),ARTIC(5),SIGPAT(5),EPSPAT(5),
     1 FI(3,5),YI(3,5),HI(3,5),FX(3,5),HPRIM(30,3),HTRUE(30,3),
     2 FVERT(30,3),KFX,AFAC(30,3),HTR(54),FNSQ(54)
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
      COMMON / TIME / IT, GMT, UTIME(24), GMTR, XLMT(24), ITIM
C
      COMMON /SOLAR/IYR,IMO,IDA,SSN,EFFQ,EFFKP,JUDAY,CHI(5),
     A TCGMT(5),PBT(5),CENT(5),EBT(5)
C
      DATA R2D/57.295779513/
C
C..................................................................
C     See if Profile was Read in
C..................................................................
C
      IF(IELECT(II) .GT. 0) then
         DO 3 I = 1,54
         HTR(I) = UHI(I,II)
         FNSQ(I) = UFQ(I,II)
    3    CONTINUE
      else
C
C..................................................................
C     DETERMINE THE LOCAL TIME
C..................................................................
C
         timel=gmt+(clong(ii)*r2d)/15.0
         if(timel .ge. 24.0) timel=timel-24.0
         if(timel .lt. 0.0) timel=timel+24.0
C
C..................................................................
C     FIND SEMI-THICKNESS AND HEIGHT OF THE F2 LAYER FROM RADC MODEL
C..................................................................
C
         CALL HTF2(II,HOUT,SHOUT,TIMEL)
C
C..................................................................
C     DETERMINE DENSITY PROFILE (70-1000 KM)
C..................................................................
C
         CALL SUPPRO(II,HOUT,SHOUT)
      endif

ccc      write(9,'(18h In LECDEN for UT=,i3,/,15x,3hHTR)') it
ccc      write(9,'(8f10.1)') (HTR(I),I=1,54)
ccc      write(9,'(15x,4hFNSQ)')
ccc      write(9,'(8f10.5)') (FNSQ(I),I=1,54)
      RETURN
      END
