c# mpath.f
      SUBROUTINE MPATH(IF)
c**********************************************************************
c          As changed 26 March 2009
c          This return the reliability of the next most probable mode
c          that is within the Maximum tolerable time delay (DMP)
c          and whose signal power is greater than PMP below the
c          signal power of the MRM.
c**********************************************************************
C     THIS ROUTINE PERFORMS THE MULTIPATH PROBABILITY AND DETERMINES
C     IF ANY OTHER MODE WILL INTERFERE WITH THE MOST RELIABLE MODE
C
      common /Cmspec/ mspec      !  for Short/Long path smoothing
      COMMON / ION /  IEA, IFQB, IFQE, IGRAPH, IHRE, IHRO, IHRS, JO,
     A LUFP, METHOD, MONPR, NDAY, NES, NOISE, NPAT, NPSL, NRSP, NUMO
      COMMON / DON /  AMIND, DMP, PMP, RSN, ATMNO,
     1                D90R, D50R, D10R, D90S, D50S, D10S
      COMMON /MODES /GHOP, DELMOD (6, 3), HPMOD (6, 3), HTMOD (6, 3), FV
     1MOD (6, 3), ITMOD (6, 3), AFMOD (6, 3)
      COMMON / SON / ANGLE(13), ANGLER(13), CPROB(13), DBLOS(13),
     A DBLOSL(13), DBLOSU(13), DBU(13), DELAY(13),XNDBW(13), NHP(13),
     B XNYNOIS(13), PROBMP(13), RELIAB(13), SNDB(13), SNPR(13),
     C SNRLW(13), SNRUP(13), SPROB(13), VHIGH(13)
      COMMON / ZON / ABPS(7), CREL(7), EFF(7), FLDST(7), GRLOS(7),
     1HN (7), HP (7), PROB (7), RELY (7), RGAIN (7), SIGPOW (7), SN (7),
     2 SPRO (7), TGAIN (7), TIMED (7), TLOSS (7), B (7), FSLOS (7), ADV
     C (7),OBF(7),NMODE(7),NREL,TLLOW(7),TLHGH(7)
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)

      PROBMP(IF) = 0.001
      IF(DMP.le.0. .or. PMP.le.0.) return        !  no multipath requested
c          Is this METHOD=30? If so, not valid>7000km
      if(method.eq.20 .and. mspec.eq.1 .and. gcdkm.gt.7000.) return
      sig_power=sigpow(nrel)         !  signal power of Most-Reliable-Mode
      sig_power_limit=sig_power-PMP  !  ignore signals below this level
      TTIM = timed(nrel)             !  time delay of MRM
      DO 135 IM = 1,6
      IF(IM.EQ.NREL) GO TO 135  ! Don't check mode for MRM -- found already by RELBIL.FOR.
      IF(HP(IM).LE.0.) GO TO 135  ! This mode does not exist.
      IF(ABS(TIMED(IM)-TTIM).LE.DMP) GO TO 135   !  inside acceptable time delay

C        Check on Multipath Power criterion set by operator.
C        The logic of this next part is revised from original code.
c        Ignore signal powers below this limit
      if(sigpow(im).lt.sig_power_limit) go to 135

      PROBMP(IF)=AMAX1(PROBMP(IF),RELY(IM))
  135 CONTINUE
      RETURN
      END
C-------------------------------
