c# noisy.f
      SUBROUTINE NOISY (KJ, XLA, CEG, ANOS)
C     NOISY IS A GENERAL PURPOSE ROUTINE USED TO EVALUATE A FOURIER
C     SERIES IN TWO VARIABLES.
C     KJ --- NUMBER OF FOURIER COEFFICIENT ARRAY TO BE USED
C     XLA --- GEOGRAPHIC LATITUDE, DEGREES,
C     CEG --- GEOGRAPHIC EAST LONGITUDE, DEGREES
C     ANOS --- NOISE VALUE, MEDIAN POWER DB ABOVE KTB
C     ABP --- NORMALIZING FACTORS FOR FOURIER SERIES
C     KJ = 1 TO 6 IS ATMOSPHERIC NOISE, KJ = 7 IS LAND MASS MAP AND
C     KJ = 8 IS RATIO OF F2 HEIGHT OF MAXIMUM TO SEMITHICKNESS
C
C     * NOTE - XLA, CEG, ANOS, ABP ARE NOT ALWAYS AS PREVIOUSLY DEFINED
C     FOURIER VARIABLES AND ATMOSPHERIC RADIO NOISE
C
      COMMON / TWO / F2D(16,6,6), DUD(5,12,5),FAM(14,12),
     A SYS(9,16,6), PERR(9,4,6),P(29,16,8),ABP(2,9)
      COMMON /SWTCH/ INIL,OSSN,OMONTH,OTIME,ODIP,OLAT,OLONG
      DIMENSION SX (15), SY(29), ZZ (29)
      SAVE
      IF (KJ - 8)105, 100, 105
C.....LIMITS OF FOURIER SERIES
 100  LM = 15
      LN = 10
      GO TO 110
C.....LIMITS OF FOURIER SERIES
 105  LM = 29
      LN = 15
C.....HALF ANGLE (IN RADIANS)
 110  Q = .0087266466 * CEG
      IF(CEG .EQ. OLONG .AND. INIL .EQ. 0) GO TO 118
C.....LONGITUDE SINES
      DO 115 K = 1, 15
 115  SX(K)=SIN(Q*K)
      OLONG=CEG
 118  CONTINUE
C.....LONGITUDE SERIES
      DO 125 J = 1, LM
      R = 0.
      DO 120 K = 1, LN
 120  R = R + SX (K) * P (J, K, KJ)
 125  ZZ (J) = R + P (J, 16, KJ)
C.....ANGLE PLUS 90 DEGREES (IN RADIANS)
      Q = .01745329252 * (XLA + 90.)
      IF(XLA .EQ. OLAT .AND. INIL .EQ. 0) GO TO 145
C.....LATITUDE SERIES
      DO 140 J=1,29
  140 SY(J)=SIN(Q*J)
      INIL=0
      OLAT=XLA
 145  CONTINUE
      R = 0.
      DO 130 K = 1, LM
  130 R = R + SY (K) * ZZ (K)
C.....FINAL FOURIER SERIES EVALUATION (NOTE LINEAR NORMALIZATION)
 135  ANOS = R + ABP(1,KJ)+ABP(2,KJ)* Q
      RETURN
      END
