c# outarea.f
      SUBROUTINE OUTarea(ix,iy)
C--------------------------------
C
C     THIS ROUTINE OUTPUTS all variables for area coverage contour plotting
C
      common /carea/ area
         character area*1
      COMMON /RGRID/ IPROJ,PLAT,PLON,XMIN,XMAX,YMIN,YMAX,NX,NY
      common /cQUIET/ iquiet
      common /chours/ nhours,ihours(24)       !  which hours are active
      common /cantenna/ numants,iats(20),anttype(20),antname(20),
     +                  xfqs(20),xfqe(20),designfreq(20),antfile(20),
     +                  beammain(20),offazim(20),cond(20),diel(20),
     +                  array(30,91,20),dumant(60,91),aeff(30,20)
      character anttype*10,antname*70,antfile*24

      common /pantenna/ pwrkw(20),pwrdba(20)
      common /sncom/ snxx(13)
      common /cgains/ gaint(13),gainr(13)
      COMMON /SOLAR/IYR,IMO,IDA,SSN,EFFQ,EFFKP,JUDAY,CHI(5),
     A TCGMT(5),PBT(5),CENT(5),EBT(5)
      COMMON /ALPHA/ IMON(12),IRCVR(2),ITRAN(2),MODE(13),MODER(13)
      CHARACTER IMON*3,IRCVR*10,ITRAN*10,MODE*2,MODER*2
      COMMON / CONTRL /  KTOUT(12), MONTHS(12), SUNSP(12),
     A IANTOU, INTEG, ISOUT, JDASH, JFREQ, JLONG, MAXNAM, MAXMET
      COMMON/FILES/LUO,LUI,LU25,LU26
      COMMON / DON /  AMIND, DMP, PMP, RSN, ATMNO,
     1                D90R, D50R, D10R, D90S, D50S, D10S
      COMMON/LPATH/ GCDLNG,TGML(45),RGML(45),DELOPT,GMIN,YMINx,LTGM,LRGM
      COMMON / ION /  IEA, IFQB, IFQE, IGRAPH, IHRE, IHRO, IHRS, JO,
     A LUFP, METHOD, MONPR, NDAY, NES, NOISE, NPAT, NPSL, NRSP, NUMO
      COMMON/FRQ/FREL(29),FREQ,JMODE
      common /cnfreqs/ nfreqs
      COMMON/MUFS/EMUF(24),F1MUF(24),F2MUF(24),ESMUF(24),ALLMUF(24)
     A ,FOT(24),XLUF(24),HPF(24),ANGMUF(24),MODMUF,SIGL(4),SIGU(4),
     B  DELMUF(4),HPMUF(4),HTMUF(4),FVMUF(4),AFMUF(4),NHOPMF(4),
     C  YFOT(4),YHPF(4),YMUF(4)
      COMMON / OUTFMT / IFMT(9), KLINE(30), NFMT(5)
      character IFMT*6,KLINE*6,NFMT*6
      COMMON /OUTPRT/ LINBOT(30), LINBD(14), LINTOP(15), LINTP(14),
     A JOUT, LINBYP, LINES, LINMAX, LINTYP, LPAGES
      COMMON / SON / ANGLE(13), ANGLER(13), CPROB(13), DBLOS(13),
     A DBLOSL(13), DBLOSU(13), DBU(13), DELAY(13),XNDBW(13), NHP(13),
     B XNYNOIS(13), PROBMP(13), RELIAB(13), SNDB(13), SNPR(13),
     C SNRLW(13), SNRUP(13), SPROB(13), VHIGH(13)
      COMMON /DUDL_NOIS/ DU_NOIS(13),DL_NOIS(13)
      COMMON/TIME/ IT,GMT,UTIME(24),GMTR,XLMT(24),ITIM
C GEOGRAPHIC AND IONSPHERIC DATA AT SAMPLE AREAS,SEE GEOM AND GENION.
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
      COMMON /REC_DEG/ RLATD,RLONGD,TLATD,TLONGD
      COMMON /PCVERS/ VERSN
      CHARACTER  VERSN*8
      CHARACTER path*5
      common /cdaily/ idaily
      character daily*3

      character antbear*12,slew*4
      character alfs(25)*6,alfPwr*10,label*90
      equivalence (alfs,label)
      data SNR88,SNR91/88.,91./

      if(ix.lt.0) go to 100                  !  output header

      do 50 i=2,nfreqs
      if(dbu(i).gt.dbu(1)) dbu(1)=dbu(i)
      if(xndbw(i).gt.xndbw(1)) xndbw(1)=xndbw(i)
      if(sndb(i).gt.sndb(1)) sndb(1)=sndb(i)
      if(reliab(i).gt.reliab(1)) reliab(1)=reliab(i)
      if(sprob(i).gt.sprob(1)) sprob(1)=sprob(i)
      if(snxx(i).gt.snxx(1)) snxx(1)=snxx(i)
50    continue
c          calculate the George Lane % Power Cut
      SNR_LW=SNRLW(1)
      SNR_UP=SNRUP(1)
      SNR50=sndb(1)
      call pwrcut(SNR50,SNR_LW,SNR_UP,SNR88,SNR91,power_cut)

      write(alfs(1),'(f6.2)') xlimit6(frel(12),2)            !  MUF
      write(alfs(2),'(2x,i2,a2)') NHP(1),MODE(1)             !  MODE
      write(alfs(3),'(f6.2)') xlimit6(angle(1),2)            !  ANGLE
      write(alfs(4),'(f6.2)') xlimit6(delay(1),2)            !  DELAY
      write(alfs(5),'(f6.1)') xlimit6(vhigh(1),1)            !  V HITE
      write(alfs(6),'(f6.3)') xlimit6(cprob(1),3)            !  MUF days
      write(alfs(7),'(f6.1)') xlimit6(dblos(1),1)            !  LOSS
      write(alfs(8),'(f6.1)') xlimit6(dbu(1)  ,1)            !  DBU
      write(alfs(9),'(f6.1)') xlimit6(xndbw(1),1)            !  S DBW
      write(alfs(10),'(f6.1)') xlimit6(XNYNOIS(1),1)         !  N DBW
      write(alfs(11),'(f6.1)') xlimit6(sndb(1),1)            !  SNR median
      write(alfs(12),'(f6.1)') xlimit6(snpr(1),1)            !  RPWRG
      write(alfs(13),'(f6.3)') xlimit6(reliab(1),3)          !  REL
      write(alfs(14),'(f6.3)') xlimit6(probmp(1),3)          !  MPROB
      write(alfs(15),'(f6.3)') xlimit6(sprob(1),3)           !  S PRB
      write(alfs(16),'(f6.2)') xlimit6(gaint(1),2)           !  TGAIN
      write(alfs(17),'(f6.2)') xlimit6(gainr(1),2)           !  RGAIN
      write(alfs(18),'(f6.1)') xlimit6(snxx(1),1)            !  SNRxx
      write(alfs(19),'(f6.2)') xlimit6(DU_NOIS(1),2)         !  DU NOISE
      write(alfs(20),'(f6.2)') xlimit6(DL_NOIS(1),2)         !  DL NOISE
      write(alfs(21),'(f6.2)') xlimit6(DBLOSL(1),2)          !  SIG LW
      write(alfs(22),'(f6.2)') xlimit6(DBLOSU(1),2)          !  SIG UP
      write(alfs(23),'(f6.1)') xlimit6(xndbw(1)+30.,1)       !  DBM
      write(alfs(24),'(f6.3)') xlimit6(power_cut,3)          !  PWRCT
      angr=angler(1)
      if(angr.le.0.) angr=angle(1)
      write(alfs(25),'(f6.2)') xlimit6(angr,2)               !  ANGLE
ccc      rlongd=rlong/.01745329
ccc      rlatd=rlat/.01745329
      if(area.eq.'A') then             !  normal Area Coverage
         xlatd=rlatd
         xlongd=rlongd
      else                             !  inverse Area Coverage
         xlatd=tlatd
         xlongd=tlongd
      end if
      if(iproj.ne.7) then    !  Lat/Lon projection, see if Longitude needs adjustment
         if(xmin.lt.0.) then
            if(ix.eq.1 .or. xlongd.gt.180.) xlongd=xlongd-360.
         end if
      end if
      if(xlongd.lt.-359.) xlongd=0.   !  probably North or south pole caused problem
      if(nfreqs.eq.1) then
      write(LUO,'(2i3,2f10.4,25a6)') ix,iy,xlatd,xlongd,alfs
      else
      write(LUO,'(2i3,2f10.4,22a6)') ix,iy,xlatd,xlongd,alfs(1),alfs(8),
     +            alfs(9),alfs(11),alfs(13),alfs(15),alfs(18)
      end if
      return

100   write(LUO,101) VERSN
101   format('ICEPAC Version ',a8)
      itr=1
      call TxPwr(pwrkw(itr),alfPwr,nchp)
      path='     '
      if(NPSL.ne.0) path='/Long'
      daily='   '
      if(idaily.ne.0) write(daily,'(1h.,i2.2)') idaily
c**********************************************************
c         get slew angle for HFCC antennas
      islew=0
      ncha=lcount(antfile(itr),24)
      slew=antfile(itr)(ncha-3:ncha)
      if(slew(1:2).eq.'.m') then    !  -slew angle
         read(slew,'(2x,i2)',err=110) islew
         islew=-islew
      else if(slew(1:2).eq.'.p') then    !  +slew angle
         read(slew,'(2x,i2)',err=110) islew
      end if
110   if(islew.eq.0) then
         write(antbear,'(i3,3hdeg)') nint(beammain(itr))
      else
         mainbeam=nint(beammain(itr))+islew       !  add slew back in
         if(mainbeam.lt.0.) mainbeam=mainbeam+360
         write(antbear,'(1h(,i3,1h,,i3,4h)deg)') mainbeam,islew 
      end if
c**********************************************************
      if(nfreqs.eq.1) then
      write(label,102) ITRAN,antname(itr)(1:10),alfPwr(1:nchp),
     +                 antbear,ihours(1),Frel(1),
     +                 IMON(IMO),daily,nint(SSN),EFFQ,path
102   format(2a10,1h[,a10,2h] ,a,1x,a,i3.2,'ut',f7.3,'MHz ',2a3,
     +       i4,'ssn',f4.1,'Q',a)
      else
      write(label,202) ITRAN,antname(itr)(1:10),alfPwr(1:nchp),
     +                 antbear,ihours(1),nfreqs,
     +                 IMON(IMO),daily,nint(SSN),EFFQ,path
202   format(2a10,1h[,a10,2h] ,a,1x,a,i3.2,'ut',i3,'Freqs ',2a3,
     +       i4,'ssn',f4.1,'Q',a)
      end if
      call squeez(label,90)        !  squeeze blanks out
      nch=lcount(label,90)
      call progress_label(label)
      if(iquiet.eq.0) write(*,'(1x,a)') label(1:nch)
      write(LUO,'(a)') label(1:nch)
      if(nfreqs.eq.1) then
      write(LUO,103) -ix,-iy
103   format(2i3,'  Latitude Longitude',
     +               '   MUF  MODE ANGLE DELAY VHITE MUFda  LOSS',
     +               '   DBU  SDBW  NDBW   SNR RPWRG   REL MPROB',
     +   ' SPROB TGAIN RGAIN SNRxx    DU    DL SIGLW SIGUP   DBM PWRCT',
     +   'ANGLER')
      else
      write(LUO,104) -ix,-iy
104   format(2i3,'  Latitude Longitude',
     +               '   MUF   DBU  SDBW   SNR   REL SPROB SNRxx')
      end if
      RETURN
      END
C--------------------------------
      subroutine progress_label(label)
      include <windows.ins>
      character label*(*)
      common /Cprogress/ iarea_batch,alf_label
         character alf_label*80
      if(iarea_batch.eq.0) return
      alf_label=label
      call window_update@(alf_label)
      RETURN
      END
C---------------------------------
      subroutine pwrcut(snr50,snr_lw,snr_up,SNR88,SNR91,power_cut)
c          calculte Percent Power Cut possible based on George Lane Algorithm
c          An estimate of the number of days on which a power reduction can be
c          used during a given hour and month can be made by computing the
c          area under the assumed normal distribution of Signal-to-Noise
c          ratios over the days of the month.
c
c          SNR50 = SNR from IONCAP, the median S/N ratio
c          SNR_LW = lower decile deviation of SNR
c          SNR_UP = upper decile deviation of SNR
c          SNR88  = 3 dB (half power) SNR limit (nominally 88 dB)
c          SNR91  = 6 dB (quarter power) SNR limit (nominally 91 dB)
c          power_cut = [0 to .75], the calculated fraction power cut available
      dimension snr(11),fact(4)
      data fact/1.28,.84,.525,.255/
      std_lw=snr_lw/1.28              !  convert to standard deviation
      snr(11)=snr50 - fact(1)*std_lw*2.
      snr(10)=snr50 - fact(1)*std_lw
      snr(9)=snr50 - fact(2)*std_lw
      snr(8)=snr50 - fact(3)*std_lw
      snr(7)=snr50 - fact(4)*std_lw
      snr(6)=snr50
      std_up=snr_up/1.28              !  convert to standard deviation
      snr(5)=snr50 + fact(4)*std_up
      snr(4)=snr50 + fact(3)*std_up
      snr(3)=snr50 + fact(2)*std_up
      snr(2)=snr50 + fact(1)*std_up
      snr(1)=snr50 + fact(1)*std_up*2.
ccc      write(72,'('' snr='',11f8.3)') snr
      day3dB=dayinterp(snr,snr88)     !  fract days that exceed SNR88
      day6dB=dayinterp(snr,snr91)     !  fract days that exceed SNR91
      power_cut=1. - (1.-day3dB) - (day3dB-day6dB)/2. - day6dB/4.
ccc      write(72,1) power_cut,day3dB,day6dB
ccc1     format(' power_cut=',f8.3,5x,'day3dB=',f8.3,5x,'day6dB=',f8.3)
      return
      end
c---------------------------------------------------------------
      function dayinterp(snr,snrx)     !  fract days that exceed SNR88
      dimension snr(11)
      dayinterp=0.
      if(snrx.gt.snr(1)) return
      do 10 i=1,10
      if(snrx.le.snr(i) .and. snrx.ge.snr(i+1)) then
	 dayinterp=(float(i-1) + (snr(i)-snrx)/(snr(i)-snr(i+1)))/10.
         return
      end if
10    continue
      dayinterp=1.
      return
      end
c---------------------------------------------------------------
