c# outpar.f
      SUBROUTINE OUTPAR
C
C     THIS ROUTINE OUTPUTS IONOSPHERIC PARAMETERS
c        following definitions added by Greg Hand 12/15/2009
c        FI(1,k)= foE  (E layer critical frequency)
c        FI(2,k)= foF1 (F1 layer critical frequency)
c        FI(3,k)= foF2 (F2 layer critical frequency)
c        XM(k) = M3000
C
      COMMON / CON / D2R, DCL, GAMA, PI, PI2, PIO2, R2D, RZ, VOFL
      COMMON / DON /  AMIND, DMP, PMP, RSN, ATMNO,
     1                D90R, D50R, D10R, D90S, D50S, D10S
      COMMON / ES / FS(3,5), HS(5)
C GEOGRAPHIC AND IONSPHERIC DATA AT SAMPLE AREAS,SEE GEOM AND GENION.
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
      COMMON /OUTLAB/ LABEL(11),LAYTYP(5), LABLI, LABLJ, LABLK
      COMMON / OUTPRT / LINBOT(30), LINBD(14), LINTOP(15), LINTP(14),
     A JOUT, LINBYP, LINES, LINMAX, LINTYP, LPAGES
      COMMON /RON/RAT(5),CLCK(5),ABIY(5),ARTIC(5),SIGPAT(5),EPSPAT(5),
     1 FI(3,5),YI(3,5),HI(3,5),FX(3,5),HPRIM(30,3), HTRUE(30,3),
     2 FVERT(30,3),KFX,AFAC(30,3), HTR(54), FNSQ(54)
      COMMON / TIME / IT, GMT, UTIME(24),GMTR,XLMT(24),ITIM
C SOLAR PARAMETERS
      COMMON /SOLAR/IYR,IMO,IDA,SSN,EFFQ,EFFKP,JUDAY,CHI(5),
     A TCGMT(5),PBT(5),CENT(5),EBT(5)
      COMMON / IPAR / XF2(5),XM3(5),XSL(5),XSM(5),XSU(5),XER(5)
      COMMON/FILES/LUO,LUI,LU25,LU26
      CHARACTER LATSYM*1,LONSYM*1
      CHARACTER LAMSYM*1,LABEL*5,LAYTYP*2,LABLI*5,LABLJ*5,LABLK*5
      DO 160 K=1,KM
      LINES = LINES + 1
      IF(LINES - LINMAX) 110, 110, 100
C.....CALL SUBROUTINE OUTTOP TO OUTPUT HEADER INFORMATION
  100 CALL OUTTOP
      WRITE(LUO,503)
      WRITE(LUO,500) YI(1,1), HI(1,1), HS(1)
      WRITE(LUO,501)
      LINES = LINTOP(15)
  110 GL = ABS(CGLT(K) * R2D)
      XLAT =ABS(CLAT(K) * R2D)
      XLONG =CLONG(K) * R2D
      GYZH = GYZ(K) / 2.
      LATSYM='N'
      IF(GLAT(K) .LT. 0.0)LATSYM='S'
      LONSYM='E'
      IF(XLONG .LE. 180.0) GO TO 130
      XLONG=360.0-XLONG
      LONSYM='W'
  130 LAMSYM='N'
      IF(CGLT(K) .LT. 0.0) LAMSYM='S'
      WRITE(LUO,502) XLAT,LATSYM,XLONG,LONSYM,CLCK(K), GMT, FI(1,K),
     1 FI(2,K), YI(2,K), HI(2,K), GYZH, FI(3,K), YI(3,K), HI(3,K),
     2 pbt(k),cent(k),ebt(k), XM3(K), tcgmt(k), RAT(K), CHI(K),
     3 IFLG(K), GL, LAMSYM
  160 CONTINUE
      RETURN
  500 FORMAT(14X,'YE = ',F5.1,5X,'HE = ',F5.1,5X,'HS = ',F5.1,/)
  501 FORMAT(2X,'LAT',3X,'LONG',4X,'LMT',4X,'UT',4X,'E',5X,'F1',4X,
     A 'Y1',5X,'H1',3X,'FH/2',1X,'F2Z',3X,'Y2',/,4X,'H2',5X,'PB',4X,
     B 'CEN',4X,'EB',1X,'M3000',3X,'TCGM',3X,'RAT',4X,'ZEN',1X,'FLAG',
     C 3X,'MAGL')
  502 FORMAT(F5.1,A1,1X,F5.1,A1,2F6.1,F6.2,1X,2F6.1,F7.1,F5.1,2F6.1,/,
     1 F6.1,1X,F6.1,1X,2F6.1,F6.2,F7.1,F6.1,F7.1,I5,F6.1,A1)
  503 FORMAT(' ')
      END
