c# outtop.f
      SUBROUTINE OUTTOP
C
C     THIS ROUTINE OUTPUTS THE HEADER INFORMATION WHICH INCLUDES THE
C     METHOD, VERSION NUMBER OF THE PROGRAM AND PAGE NUMBER. OTHER
C     OUTPUT CONSISTS OF THE USER DEFINED INPUT INFORMATION AND DEPENDS
C     ON THE METHOD. SUBROUTINE SETOUT SETS THE LINES TO BE OUTPUT IN AN
C     ARRAY CALLED LINTOP(I) WHERE THE INDEX REFERS TO THE FOLLOWING
C     =1 OUTPUT MONTH, YEAR AND SUNSPOT NUMBER
C     =2 OUTPUT INFORMATION ON "LABEL" CONTROL CARD
C     =3 OUTPUT TRANSMITTER AND RECEIVER INFORMATION CONSISTING OF
C        COORDINATES, AZIMUTH AND GREAT CIRCLE DISTANCE
C     =4 OUTPUT MINIMUM TAKE-OFF ANGLE
C     =5 OUTPUT TRANSMITTER ANTENNA INFORMATION
C     =6 OUTPUT RECEIVER ANTENNA INFORMATION
C     =7 OUTPUT POWER, 3 MHZ MAN-MADE NOISE, REQUIRED RELIABILITY AND
C        REQUIRED SNR
C     =8 OUTPUT THE MULTIPATH POWER TOLERANCE AND DELAY TIME TOLERANCE
C
      common /cmodel/ model
      character model*8
      common /ccoeff/ coeff
      character coeff*4
      common /cdaily/ idaily
      common /cantenna/ numants,iats(10),anttype(10),antname(10),
     +                  xfqs(10),xfqe(10),designfreq(10),antfile(10),
     +                  beammain(10),offazim(10),cond(10),diel(10),
     +                  array(30,91,10),dumant(60,91),aeff(30,10)
      character anttype*10,antname*70,antfile*24
      common /pantenna/ pwrkw(10),pwrdba(10)
      COMMON / ALPHA / IMON(12), IRCVR(2), ITRAN(2), MODE(13),
     A MODER(13)
      COMMON/FILES/LUO,LUI,LU25,LU26
C SOLAR PARAMETERS
      COMMON /SOLAR/IYR,IMO,IDA,SSN,EFFQ,EFFKP,JUDAY,CHI(5),
     A TCGMT(5),PBT(5),CENT(5),EBT(5)
      COMMON/CON/D2R,DCL,GAMA,PI,PI2,PIO2,R2D,RZ,VOFL
      COMMON / DON /  AMIND, DMP, PMP, RSN, ATMNO,
     1                D90R, D50R, D10R, D90S, D50S, D10S
C GEOGRAPHIC AND IONSPHERIC DATA AT SAMPLE AREAS,SEE GEOM AND GENION.
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
      COMMON / ION /  IEA, IFQB, IFQE, IGRAPH, IHRE, IHRO, IHRS, JO,
     A LUFP, METHOD, MONPR, NDAY, NES, NOISE, NPAT, NPSL, NRSP, NUMO
      COMMON / OUTPRT / LINBOT(30), LINBD(14), LINTOP(15), LINTP(14),
     A JOUT, LINBYP, LINES, LINMAX, LINTYP, LPAGES
      COMMON/TON/ADJ,ADS,ATMO,GNOS,RCNSE,REL,SL,SLS,SU,SUS
     A ,XEFF,XNOISE,XTLOS,ZNOISE,NF
      COMMON /PCVERS/ VERSN
      CHARACTER IRLAT*1, IRLONG*1, ITLAT*1,
     A ITLONG*1, IRCVR*10, ITRAN*10, IMON*3
      CHARACTER  VERSN*6
      CHARACTER MODE*2, MODER*2, MFORM*1
      CHARACTER path*6
C  PLACE IN COMMON/RTANT/ WHEN ANTENNAS ADDED
      DATA MFORM /''/
      KNTT = 1
      KNTR = 1
      NYR = iyr + 1900
C.....INCREMENT PAGE NUMBER
      LPAGES= LPAGES + 1
      if(idaily.eq.0) then
         WRITE(LUO,1500) MFORM,coeff,METHOD, model,VERSN, LPAGES
 1500    FORMAT(A1,5x,a4,' Coefficients',9x,
     +          'METHOD',I3,3X,A8,'Version ',A6,'W PAGE',I4,/)
      else
         WRITE(LUO,1501) MFORM,'URSI',METHOD, model,VERSN, LPAGES
 1501    FORMAT(A1,5x,a4,' Coeff(Daily)',9x,
     +          'METHOD',I3,3X,A8,'Version ',A6,'W PAGE',I4,/)
      end if
      IF(LINTOP(1).GT.0) then
         if(idaily.eq.0) then
            WRITE(LUO,1502) IMON(IMO), nyr, SSN,EFFQ
 1502       FORMAT(2X,A3,3X,I5,10X,'SSN = ',F4.0,5x,'Qeff=',f4.1)
         else
            WRITE(LUO,1503) IMON(IMO),idaily,nyr,SSN,EFFQ
 1503       FORMAT(2X,A3,1h,,I2.2,I5,' (Daily)  SSN = ',F4.0,
     +                         5x,'Qeff=',f4.1)
         end if
      end if
      path='    '
      if(NPSL.ne.0) path='<Long>'
      if(LINTOP(2).gt.0) WRITE(LUO,1504)  ITRAN,IRCVR,path
 1504 FORMAT(2X,4A10,2X,'AZIMUTHS',2X,a6,2x,'N. MI.',6X,'KM')
      IF(LINTOP(3) .le. 0) GO TO  130
      GCDNMI = GCDKM*0.54
      itlat='N'
      irlat='N'
      if(tlat .lt. 0.0) itlat = 'S'
      TPLAT=ABS(TLAT*r2d)
      if(rlat .lt. 0.0) irlat = 'S'
      RPLAT=ABS(RLAT*r2d)
      TPLON=TLONG*r2d
      RPLON=RLONG*r2d
      itlong='E'
      irlong='E'
      IF( TPLON .GT. 180.0) THEN
        tplon=360.0 - tplon
        itlong='W'
      endif
      IF( RPLON .GT. 180.0) then
        rplon=360.0 - rplon
        irlong='W'
      endif
      WRITE(LUO,1506)TPLAT,ITLAT,TPLON,ITLONG,RPLAT,IRLAT, RPLON,
     A IRLONG,BTRD,BRTD,GCDNMI,GCDKM
  130 continue
      if(LINTOP(4).gt.0) WRITE(LUO,1508) AMIND
 1508 FORMAT(2X,'MINIMUM ANGLE  ',F5.2,'  DEGREES')
c*****************************************************************
      do 50 i=1,numants               !  TRANSMITTER (with power)
      if(iats(i).ne.1) go to 50
      write(LUO,1520) 'XMTR',nint(xfqs(i)),nint(xfqe(i)),
     +         anttype(i),antfile(i)(1:21),
     +         beammain(i),offazim(i),pwrkw(i)
1520  format(2x,a4,i3,'-',i2,1x,a10,1h[,a21,'] Az=',f5.1,
     +       ' OFFaz=',f5.1,f8.3,'kW')
      KNTT=KNTT+1
50    continue
      do 55 i=1,numants                !  RECEIVER (no power)
      if(iats(i).ne.2) go to 55
      write(LUO,1520) 'RCVR',nint(xfqs(i)),nint(xfqe(i)),
     +         anttype(i),antfile(i)(1:21),beammain(i),offazim(i)
      KNTT=KNTT+1
55    continue
c*****************************************************************
      IF(LINTOP(7).gt.0) then
         ZNO = - ZNOISE
         WRITE(LUO,1514) ZNO, LUFP, RSN
 1514    FORMAT(2X,'3 MHZ NOISE = ',F6.1,
     A ' DBW     REQ. REL = .',I2,'    REQ. SNR = ',F4.1,' DB')
      end if
      IF(LINTOP(8).gt.0) WRITE(LUO,1516) PMP,DMP
      KNTT = KNTT - 1
      KNTR = KNTR - 1
      LINES = LINTOP(15) + KNTT + KNTR
      RETURN
 1506 FORMAT(2X,F5.2,1X,A1,2X,F6.2,1X,A1,' - ',F5.2,1X,A1,2X,F6.2,
     A 1X,A1,4X,F6.2,2X,F6.2,3X,F7.1,2X,F7.1)
 1516 FORMAT(2X,'MULTIPATH POWER TOLERANCE = ',F4.1,' DB   ',
     A 'MULTIPATH DELAY TOLERANCE = ',F6.3,' MS')
      END
c-------------------------------------------------------
