c# qoval1.f
      SUBROUTINE QOVAL1(EFFQ,TCGM,PB,CEN,EB)
C***********************************************************************
C* SUBROUTINE NAME:  QOVAL1            CPC:  SS/MOD/RTN/QOVAL1         *
C*         VERSION:  88-II            DATE:  16 MAR 88                 *
C*                                                                     *
C*         PURPOSE:  THIS SUBROUTINE CALCULATES THE POLEWARD AND EQUA- *
C*                   TORIAL BOUNDARIES OF THE AURORAL OVAL.  THIS IS A *
C*                   REVISED VERSION OF QOVAL1. THE CHANGES INCLUDE:   *
C*                                                                     *
C*                   1.  EQUATORWARD BOUNDARY FOR Q=0 AT 2000 CGMT HAS *
C*                   BEEN CHANGED FROM 69.0 TO 70.5                    *
C*                                                                     *
C*                   2.  EQUATORWARD BOUNDARY FOR 0<Q<1 NOW USES SOME  *
C*                   INTERPOLATION                                     *
C*                                                                     *
C*         CALLING                                                     *
C*       ARGUMENTS:  EFFQ, TCGM, PB, CEN, EB                           *
C*                                                                     *
C*  ABBREVIATIONS:  NONE                                               *
C*                                                                     *
C*  COMMON BLOCKS:  NONE ACCESSED                                      *
C*                                                                     *
C* FILES ACCESSED:  NONE                                               *
C*                                                                     *
C*         METHOD:  1.  DETERMINE WHICH QUADRANT THE GRIDPOINT IS IN:  *
C*                  00-04L, 04-08L, 08-12L, 12-16L, 16-20L, 20-24L     *
C*                                                                     *
C*                  2.  LOADS THE POLAR BOUNDARIES FOR 00,04,08,12,16, *
C*                  AND 20LT, FOR Q = 0                                *
C*                                                                     *
C*                  3.  RESHAPES THE POLAR BOUNDARY BASED ON THE REAL Q*
C*                                                                     *
C*                  4.  CALCULATES THE EQUATORWARD BOUNDARY BASED ON   *
C*                  THE REAL Q VALUE AND DETERMINES THE CENTER OF OVAL *
C*                                                                     *
C*        REMARKS:  NONE                                               *
C*                                                                     *
C*     REFERENCES:  1.  ICED-III SYSTEM DOCUMENTATION                  *
C*                  2.  SPERRY FORTRAN-77(ASCII) PRM                   *
C*                  3.  AFGWC FORM 10 DX-50194                         *
C*                  4.  AFGWC FORM 10 DX-60096                         *
C*                                                                     *
C*LOCAL VARIABLES:  INDEX  - IS - INDEX OF WHICH QUADRANT THE GRIDPOINT*
C*                                IS IN                                *
C*                  JNDEX  - IS - INDEX+1                              *
C*                  CEN    - RS - CENTER OF AURORAL ZONE               *
C*                  EB     - RS - EQUATORWARD BOUNDARY                 *
C*                  EFFQ   - RS - AURORAL Q INDEX                      *
C*                  FRAC   - RS - FRACTIONAL PART OF CALCULATION       *
C*                  PB     - RS - POLEWARD BOUNDARY OF OVAL            *
C*                  PI     - RS - 3.14159265                           *
C*                  PIOVR2 - RS - 1.570796                             *
C*                  TCGM   - RS - CORRECTED GEOMAGNETIC LOCAL TIME     *
C*                  EQBNO  - RV - EQUATORWARD BOUNDARY VALUES AT Q=0   *
C*                  POLAR  - RV - POLEWARD BOUNDARY VALUES AT Q=0      *
C*                  POLAR0 - RV - TEMPORARY POLEWARD BOUNDARY AT Q=0   *
C* (I=INTEGER, R=REAL, C=CHARACTER, S=SCALAR, V=VECTOR, A=ARRAY)       *
C*                                                                     *
C*   SETC OPTIONS:  NONE USED                                          *
C*                                                                     *
C*     SUBPROGRAMS                                                     *
C*         CALLED:  NONE                                               *
C*                                                                     *
C*     SUBPROGRAM                                                      *
C*      CALLED BY:  ELAYER, F2LAYR                                     *
C*                                                                     *
C*ROUTINE WRITTEN:  JAN 86 - NATIONAL GEOPHYSICAL DATA CENTER          *
C*        UPDATES:  MAY 86 - AFGWC/SDDE - UPGRADED DOCUMENTATION       *
C*                  AUG 87 - NATIONAL GEOPHYSICAL DATA CENTER (87-I)   *
C*                  MAR 88 - NATIONAL GEOPHYSICAL DATA CENTER (88-II)  *
C*                                                                     *
C***********************************************************************
      INTEGER INDEX
      INTEGER JNDEX
      REAL CEN
      REAL EB
      REAL EFFQ
      REAL FRAC
      REAL PB
      REAL PI
      REAL PIOVR2
      REAL TCGM
      REAL EQBN0(6)
      REAL POLAR(6)
      REAL POLAR0(6)
      DATA POLAR0/72.0,74.0,74.0,77.5,77.0,73.0/
      DATA EQBN0/70.0,70.0,73.0,76.0,75.5,70.5/
      DATA PI/3.141593/,PIOVR2/1.570796/
C................................................................
C     CALCULATE QUADRANT IN WHICH GRIDPOINT LIES                :
C................................................................
      INDEX=TCGM/4.0+1.0
      JNDEX=INDEX+1
      IF (JNDEX.GT.6) JNDEX=1
      FRAC=AMOD(TCGM,4.0)/4.0
C.................................................................
C     IF EFFQ=0, WE HAVE THE VALUES OF OVAL ALREADY IN POLAR0,   .
C     OTHERWISE, WE HAVE TO CALCULATE THE REAL OVAL BASED ON EFFQ.
C.................................................................
      IF (EFFQ.LE.0.001) THEN
        DO 10 I=1,6
          POLAR(I)=POLAR0(I)
10      CONTINUE
      ELSE
C..................................................................
C       MODIFY THE POLEWARD OVAL BOUNDARY BASED ON EFFQ > 0       :
C..................................................................
        POLAR(1)=69.5+(0.6666667*EFFQ)
        IF (EFFQ.LT.1.0) POLAR(1)=71.5-(1.3333333*EFFQ)
        POLAR(2)=74.0-(EFFQ/8.)
        POLAR(3)=78.5-EFFQ
        IF (EFFQ.LE.3.5) POLAR(3)=74.0+0.3*EFFQ
        POLAR(4)=77.5-(EFFQ*EFFQ)/((2.0*EFFQ)+1.)
        POLAR(5)=77.0-(0.6666667*EFFQ)
        POLAR(6)=71.0+(0.5*COS((EFFQ-0.5)*PIOVR2))
      ENDIF
C...............................................................
C     FINAL MODIFICATION OF THE POLEWARD BOUNDARY              :
C...............................................................
      PB=POLAR(INDEX)+(FRAC*(POLAR(JNDEX)-POLAR(INDEX)))
C................................................................
C     IF EFFQ<1,THE EQUATORWARD BOUNDARY IS CALCULATED LIKE THIS:
C................................................................
      IF (EFFQ.LT.1.0) THEN
        EB = EQBN0(INDEX)+(FRAC*(EQBN0(JNDEX)-EQBN0(INDEX)))
        IF (EFFQ.GT.0.001) THEN
          EB = EB + (EFFQ*(71.1-(5.1*COS((PI/12.0)*(TCGM-1.0)))-EB))
        ENDIF
      ELSE
C...................................................................
C       FOR EFFQ>1, EQUATORWARD BOUNDARY IS CALCULATED LIKE THIS   .
C...................................................................
        EB=72.0-(0.9*EFFQ)-5.1*COS(PI/12.0*(TCGM-1.0))
      ENDIF
C.................................................................
C     CENTER OF AURORAL ZONE IS ARITHMETIC AVERAGE OF BOUNDARIES :
C.................................................................
      CEN=(EB+PB)/2.
      RETURN
      END
 
