c# redmap.f
      SUBROUTINE REDMAP(SSN,MONTH)
C     THIS ROUTINE READS THE IONOSPHERIC LONG TERM DATA BASE FILE
C     FOR MONTH AND SUNSPOT NUMBER
C
      common /crun_directory/ run_directory
         character run_directory*50
      common /ccoeff/ coeff
      character coeff*4
      COMMON /ONE/ IKIM(10,6),F2COF(13,76),ESMCOF(7,61),
     A  ESLCOF(5,55),ESUCOF(5,55),
     B  FM3COF(9,49),ERCOF(9,22),DUM(250)
      COMMON /FONE/ ANEW(3),BNEW(3),ACHI(2),BCHI(2)
      COMMON /TWO/ F2D(16,6,6),DUD(5,12,5),FAM(14,12),
     +             SYS(9,16,6),PERR(9,4,6),
     +             FAKP(29,16,6),FAKMAP(29,16),HMYM(29,16),
     +             FAKABP(2,6),ABMAP(2,3)
C.....VARIABLES FROM THE DATA BASE FILE BEFORE SUNSPOT INTERPOLATION
      DIMENSION XESLCF(5,55,2), XESMCF(7,61,2), XESUCF(5,55,2),
     A XFM3CF(9,49,2), XERCOF(9,22,2), XF2COF(13,76,2)
     B ,XPMAP(29,16,2)
      CHARACTER foF2_name*12,coeff_name*12

      nch_run=lcount(run_directory,50)
c*****************************************************************
c          read the foF2 coefficients (CCIR or URSI88)
      write(foF2_name,'(4hfof2,a4,4h.daw)') coeff
      OPEN(27,FILE=run_directory(1:nch_run-3)//'coeffs\'//fof2_name,
     +       STATUS='OLD',
     +       form='unformatted',access='direct',recl=7904,err=900)
      read(27,rec=month) XF2COF
      close(27)
c*****************************************************************
c          read the rest of the coefficients
      write(coeff_name,'(5hcoeff,i2.2,5hw.bin)') MONTH
      OPEN(27,FILE=run_directory(1:nch_run-3)//'coeffs\'//coeff_name,
     +       status='old',form='unformatted',err=910)
      rewind(27)
      READ(27,END=300,ERR=400) IKIM
      READ(27,END=300,ERR=400) FAKP,FAKABP
      READ(27,END=300,ERR=400) DUD,FAM,SYS
      READ(27,END=300,ERR=400) XFM3CF

      READ(27,END=300,ERR=400) F2D,PERR
      READ(27,END=300,ERR=400) ANEW,BNEW,ACHI,BCHI,FAKMAP,ABMAP
      READ(27,END=300,ERR=400) XESMCF,XPMAP
      READ(27,END=300,ERR=400) XESLCF, XESUCF
      READ(27,END=300,ERR=400) XERCOF
c*****************************************************************
      SSN100=100.-SSN
      DO 200 I=1,13
      DO 200 J=1,76
200   F2COF(I,J)=(XF2COF(I,J,1)*SSN100 + XF2COF(I,J,2)*SSN)/100.
      SSN150=150.-SSN
      SSN10=SSN-10.
      DO 210 I = 1,7
      DO 210 J = 1,61
210   ESMCOF(I,J)=(XESMCF(I,J,1)*SSN150 + XESMCF(I,J,2)*SSN10)/140.
      SSN125=125.-SSN
      SSN25=SSN-25.
      DO 220 I=1,29
      DO 220 J=1,16
220   HMYM(I,J)=(XPMAP(I,J,1)*SSN125 + XPMAP(I,J,2)*SSN25)/100.
      DO 230 I = 1,5
      DO 230 J = 1,55
      ESLCOF(I,J)=(XESLCF(I,J,1)*SSN150 + XESLCF(I,J,2)*SSN10)/140.
230   ESUCOF(I,J)=(XESUCF(I,J,1)*SSN150 + XESUCF(I,J,2)*SSN10)/140.
      DO 240 I = 1,9
      DO 240 J = 1,49
240   FM3COF(I,J)=(XFM3CF(I,J,1)*SSN100 + XFM3CF(I,J,2)*SSN)/100.
      DO 250 I = 1,9
      DO 250 J = 1,22
250   ERCOF(I,J)=(XERCOF(I,J,1)*SSN150 + XERCOF(I,J,2)*SSN10)/140.
      GO TO 500
c*****************************************************************
300   PAUSE 'END OF FILE ON DATA BASE in REDMAP'
      GO TO 500
400   PAUSE 'ERROR ON DATA BASE READ in REDMAP'
  500 ITRUN=-2
      CLOSE(27)
      RETURN
900   write(*,901) '..\coeffs\'//fof2_name
901   format(' Could not OPEN file=',a)
      stop 'OPEN error in redmap at 900'
910   write(*,901) '..\coeffs\'//coeff_name
      stop 'OPEN error in redmap at 910'
      END
