c# regmod.f
      SUBROUTINE REGMOD
C
C     THIS ROUTINE FINDS ALL MODES FOR THE CURRENT FREQUENCY AND THE
C     DISTANCE FROM THE IONOGRAM (NO SPORADIC E MODES - SEE SUBROUTINE
C     ESMOD) THIS IS FOR A GIVEN HOP DISTANCE SET IN SUBROUTINE LUFF(1)
C
      COMMON/FILES/LUO,LUI,LU25,LU26
      COMMON/ANOIS/ATNU,ATNY,CC,TM,XEFF,RCNSE,DU,DL,SIGM,SXGU,SXGL,KJ,JK
      COMMON/SIGD/DSL,ASM,DSU,AGLAT,DSLF,ASMF,DSUF,ACAV,FEAV,AFE,BFE
     A ,XVE
      COMMON/MUFS/EMUF(24),F1MUF(24),F2MUF(24),ESMUF(24),ALLMUF(24),FOT
     A(24),XLUF(24),HPF(24),ANGMUF(24),MODMUF,SIGL(4),SIGU(4),DELMUF(4)
     B ,HPMUF(4),HTMUF(4),FVMUF(4),AFMUF(4),NHOPMF(4),YFOT(4),YHPF(4)
     C ,YMUF(4)
      COMMON /CON /D2R, DCL, GAMA, PI, PI2, PIO2, R2D, RZ, VOFL
      COMMON / DON /  AMIND, DMP, PMP, RSN, ATMNO,
     1                D90R, D50R, D10R, D90S, D50S, D10S
      COMMON /RON /RAT(5),CLCK(5),ABIY(5),ARTIC(5),SIGPAT(5),EPSPAT(5),
     1 FI(3,5),YI(3,5),HI(3,5),FX(3,5),HPRIM(30,3),HTRUE(30,3),
     2 FVERT(30,3),KFX,AFAC(30,3),HTR(54),FNSQ(54)
      COMMON /RTANT /TEFF,REFF,KASANT(2)
      COMMON / ZON / ABPS(7), CREL(7), EFF(7), FLDST(7), GRLOS(7),
     1HN (7), HP (7), PROB (7), RELY (7), RGAIN (7), SIGPOW (7), SN (7),
     2 SPRO (7), TGAIN (7), TIMED (7), TLOSS (7), B (7), FSLOS (7), ADV
     C (7),OBF(7),NMODE(7),NREL,TLLOW(7),TLHGH(7)
      COMMON/TON/ADJ,ADS,ATMO,GNOS,XCNSE,REL,SL,SLS
     A ,SU,SUS,ZEFF,XNOISE,XTLOS,ZNOISE,NF
      COMMON / FRQ / FREL(29), FREQ, JMODE
      COMMON /ES /FS (3, 5), HS (5)
C REFLECTRICIES AT FREQ, SEE SUBR. FINDF.
      COMMON /REFLX /DELFX (45, 3), HPFLX (45, 3), HTFLX (45, 3), GDFLX
     1(45, 3), FVFLX (45, 3), DSKPKM (3), DELSKP (3), HPSKP (3), HTSKP (
     23), DMAXKM (3), FVSKP (3), ISKP (3), IMODE (45, 3), AFFLX (45, 3)
     C ,DELPEN(3,3)
      COMMON /MODES /GHOP, DELMOD (6, 3), HPMOD (6, 3), HTMOD (6, 3), FV
     1MOD (6, 3), ITMOD (6, 3), AFMOD (6, 3)
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
      COMMON / RAYS / ANG(40), IFOB(40,30,3), NANG
      COMMON /TIME /IT, GMT, UTIME (24),GMTR,XLMT(24),ITIM
      DIMENSION LX(3)
      DATA LX/1,3,5/
90     CONTINUE
C
C  TEMPORARILY FILL  A SELECTED MODES INTO COMMON/ZON/
C  SHOULD DO THIS BY A EQUAL TAKEOFF ANGLE SEARCH IN COMMON/REFLX/
C  WILL USE  COMMON/MODES/ NOW. THIS IS A ONE SAMPLE AREA FOR CORRECT
C  DISTANCE  AT ALL SAMPLE AREAS. FOR A SHORT PATH THESE RESULTS ARE
C  CORRECT. MODES THAT GO ALL SAMPLE AREAS ARE GOOD. BUT SOME GOOD MODES
C  MAY BE MISSED THIS WAY.
C  SELECT SAMPLE AREA TO BE USED BY CRITICAL FREQUENCIES.
C  SET BY CALL TO SUBROUTINE SANG FROM SUBROUTINE LUFF(1)
C  RELATE 3 IONOSPHERES TO 5 SAMPLE AREAS
      K = JMODE
      L = LX(K)
C.....USE AVERAGE ABSORBTION INDEX FROM SUBROUTINE SIGDIS
      AC = 677.2 * ACAV
      BC = (FREQ + GYZ(L) ) ** 1.98
C.....IHOP IS THE NUMBER OF HOPS (GHOP IS FROM SUBROUTINE LUFF(1))
      IHOP = GCD/GHOP  +.01
      HOP=IHOP
C
C  IS CALL FROM REGMOD OR INMOD
C
      IF(MODMUF)  92,92,94
C
C  MODE IS DETERMINED
C
   92 MODMUF = -MODMUF
      GO TO 96
   94 CONTINUE
C.....FIND UP TO 6 RAYSETS
      CALL FDIST (K)
C  OVER-THE-MUF
C.....CHECK ON THE OVER-THE-MUF MODE
      CALL INMUF( IHOP)
   96 CONTINUE
C  NOW ADD LOSSES
C.....BEGINNING OF PRESET OF COMMON/ZON/
      DO 240 IM = 1,7
      ITRY =1
      OBF(IM) = 1000.
      ADV(IM) = 1000.
      FSLOS(IM)=1000.
      TLOSS(IM)=1000.
      ABPS(IM) =1000.
      EFF(IM)  = 0.0
      GRLOS(IM)=1000.
      RGAIN(IM)=  0.0
      TGAIN(IM)=  0.0
      HN(IM) = -1.
      PROB(IM) = 0.001
      CREL(IM) = 0.001
      RELY(IM) = 0.001
      SPRO(IM) = 0.001
      FLDST(IM) = -1000.0
      SIGPOW(IM)=-1000.
      SN(IM)=-1000.
      TIMED(IM) = -1.
      HP   (IM) = -1.
      B    (IM) = -1.
      NMODE(IM) = 5
      TLLOW(IM) = 10.
      TLHGH(IM) = 10.
C.....ENDING OF PRESET OF COMMON/ZON/
      IF(IM .GE. 7) GOTO 240
      IF(ITRY .LT. 1) GOTO 240
      IF(HPMOD(IM,K) .LE. 0.0) GOTO 240
C   FREE SPACE LOSS LOSS RELATIVE TO AN ISOTROPIC RADIATOR
      DEL = D2R * DELMOD (IM, K)
      DEL = AMIN1(DEL, 89.99*D2R)
      CDEL = COS (DEL)
      PSI = GHOP * 0.5
      PHE = PIO2 - PSI - DEL
      PATH = 2. * (HPMOD(IM,K) + RZ * (1. - COS(PSI))) / COS(PHE)
      PATH=ABS(PATH*HOP)
C.....TIME DELAY
      TIMED(IM)=PATH/VOFL
C.....FREE SPACE LOSSES
      FSLOS (IM) = 32.45 + 20.*ALOG10(PATH*FREQ)
      IF(FI(1,K) .LT. FVMOD(IM,K))  GOTO 125
C  D-E MODE
C.....XNSQ IS THE COLLISION FREQUENCY TERM
      IF(HTMOD(IM,K) .LT. 88.0) THEN
      HNUX= 61. + 3.*(HTMOD(IM,K) - 70.)/18.
      XNSQ=  63.07 * EXP(- 2.*(HNUX-60.)/4.39)
C.....SECANT PHE FOR REFLECTION AREA - THE CLASSICAL HEIGHT OF 100 KM
C.....IS ASSUMED FOR HTMOD .GT. 100 KM
      ELSE
      XNSQ = 10.2
      END IF
      HEFF = AMIN1( 100.,HTMOD(IM,K))
      SINP = RZ*CDEL/(RZ+ HEFF)
      SECP = 1./SQRT(1. -SINP*SINP)
      ABPS(IM) = SECP* AC/(BC + XNSQ)
ccc      write(9,1121) im,abps(im),secp,ac,bc,xnsq
ccc1121  format(' In REGMOD after 120 im=',i5,5e15.7)
C.....ABSORPTION LOSS BUT REMOVE E LAYER BENDING EFFECT
      XV = AMAX1( FVMOD(IM,K)/FI(1,K) , XVE)
      ADX =  AFE + BFE * ALOG(XV)
      SECP= 1./SIN(DEL +PSI)
C.....DEVIATION TERM FOR HIGH ANGLE RAYS, PLUS E LAYER BENDING EFFECT
      ADV(IM) = SECP*AFMOD(IM,K)*((FVMOD(IM,K)+GYZ(L))**1.98 + XNSQ)
     A          / (BC + XNSQ ) + ADX
C.....SET ES OBSCURATION TO 0.0 FOR D - E MODES
      OBF(IM) = 0.0
      OBFU = 0.0
      OBFL = 0.0
      GO TO 160
C   F LAYER MODES
C.....COLLISION FREQUENCY TERM
C.....HTMOD .GT. 100KM FOR F LAYER
  125 XNSQ = 10.2
      SINP = RZ*CDEL/(RZ + 100.)
      SECP = 1./SQRT(1.-SINP*SINP)
C.....ABSORPTION LOSS
      ABPS(IM)= SECP*AC/(BC+ XNSQ)
ccc      write(9,1126) im,abps(im),secp,ac,bc,xnsq
ccc1126  format(' In REGMOD after 125 im=',i5,5e15.7)
      SECP = 1./SIN(DEL + PSI)
C.....DEVIATIVE LOSS TERM FOR HIGH ANGLE MODES
      ADV(IM) = SECP* AFMOD(IM,K)*((FVMOD(IM,K) +GYZ(L))**1.98 + XNSQ)
     A          /(BC + XNSQ)
C  ES OBSCURATION LOSS
      OBF(IM) = 0.0
      OBFU = 0.0
      OBFL = 0.0
      IF(FS(2,K) .LE. 0.0) GOTO 160
C.....FOR LOW FREQUENCIES, INCLUSION OF REGULAR E INTO SPORADIC E CAUSES
C.....PROBLEM, SEE ALSO SUBROUTINE SIGDIS
      FSDEAD = IFOB(1,3,K)
      FSDEAD = FSDEAD/1000.
      FSDEAD = AMIN1(FSDEAD,3.)
      FMHZ = AMAX1(FREQ,FSDEAD)
      SINS = RZ*CDEL/(RZ+ HS(K))
      SECS = 1./SQRT(1.- SINS*SINS)
C.....MEDIAN MUF FOR THIS HOP, NOT FOR THE PATH.
C.....PRBMUF IS THE PROBABILITY FUNCTION
C.....NOTE LIMIT ON LOSS
      ESD  = FS(2,K)*SECS
      DUMMY = YMUF(4)
      PROS = PRBMUF(FMHZ,ESD,DUMMY,4)
      PROS = AMIN1(PROS,.90)
      OBF(IM) = -10.*ALOG10(1.-PROS)
      ESD = FS(1,K)* SECS
C.....UPPER DECILE OBSCURATION AT ES FOT
      DUMMY = YFOT(4)
      PROS = PRBMUF(FMHZ,ESD,DUMMY,4)
      PROS = AMIN1( PROS, 0.90)
      OBFU= -10.*ALOG10(1.- PROS)
C.....LOWER DECILE OBSCURATION AT ES HPF
      DUMMY = YHPF(4)
      PROS = PRBMUF(FMHZ,ESD,DUMMY,4)
      PROS = AMIN1(PROS, 0.9)
      OBFL =  -10.*ALOG10(1.- PROS)
  160 CONTINUE
      Y = 0.0
      DO 185 IG = 1,KM
      IGX = - IG
      CALL GAIN(IGX,1,DEL,FREQ,YG,GEFF)
  185 Y = Y + YG
      XKM = KM
C.....AVERAGE GROUND LOSS
      GRLOS(IM) = Y / XKM
C  ANTENNA GAINS
C.....GAIN AT TRANSMITTER
      CALL GAIN(1,KASANT(1),DEL,FREQ,DUMMY,TEFF)
      TGAIN(IM) = DUMMY
C.....GAIN AT RECEIVER
      CALL GAIN(2,KASANT(2),DEL,FREQ,DUMMY1,DUMMY2)
      RGAIN(IM) = DUMMY1
      EFF(IM) = DUMMY2
C.....NOTE ONLY 2 HOPS FOR THE OBSCURATION
      HOPS = AMIN1( HOP, 2.)
      XTLOS = FSLOS(IM) + HOP * (ABPS(IM) + ADV(IM)) + GRLOS(IM)
     A * (HOP -1.)  + HOPS*OBF(IM) + ASM - RGAIN(IM) - TGAIN(IM)
C.....BEGINNING OF TRANSMISSION LOSS DISTRIBUTION
      ISMOD = ITMOD(IM,K)
      SPHET = RZ * CDEL / (RZ + HTMOD(IM,K))
      CPHET = 1. - SPHET * SPHET
      CPHET = AMAX1(0.000001,CPHET)
      CPHET = SQRT(CPHET)
C.....MUF FOR THIS HOP DISTANCE
c%lc:gsp, change 1a     12 Jan 1995,                        subroutine  regmod
c%lc    "prob()" is the array to be printed as fdays in methods 16-23, and 
c%lc    "MODE PROB" in method 25.  This change is to base fdays on the specific
c%lc    hop muf, not path muf.  This change supercedes fdays code below.  See 
c%lc    change 1b.  Note: the code above for CPHET is problematic and does not
c%lc    give a correct "hop muf." It may be correct for its other uses, though.
c%lc    A better "hop muf" is calculated in this added code.  The original is 
c%lc    preserved for its original uses.
c%lc begin change 
      PSI = GCD/2.
      PSI=PSI/HOP
      CPSI = COS(PSI)
      SPSI = SIN(PSI)
      TANP = SPSI / (1. - CPSI + HPmuf(ismod) / RZ)
      PHE = ATAN(TANP)
      DEL = PIO2 - PHE - PSI
      CDEL = COS(DEL)
      SPHE = RZ*CDEL/(RZ+ HTmuf(ismod))
      xmuf=fvmuf(ismod)/sqrt(1.-sphe*sphe)
      DUMMY = YMUF(ISMOD)
      Prob(im) = PRBMUF(FREQ,XMUF,DUMMY,ISMOD)    !  this is MUFday
c          add more loss when MUFday gets very low but put a limit on it.
c          Extra loss goes from 0 to 24dB for MUFday .0001 to .0000001
c          This was added 11/11/2006 for problems posed by Jim Tabor.
      if(prob(im).lt..0001) then
         xfac=alog10(prob(im))
         if(xfac.gt.-4.) xfac=-4.
         if(xfac.lt.-7.) xfac=-7.
         ghlos=(xfac+4.)*8.
         xtlos=xtlos-ghlos
      end if
c%lc. end change 1a
      XMUF = FVMUF(ISMOD)/CPHET
      DUMMY = YMUF(ISMOD)
      P = PRBMUF(FREQ,XMUF,DUMMY,ISMOD)
ccc      if(p.le..0001) p=.0001      !  put a limit on low probability (GRH 5/12/2005)
      XLS =  -10.*ALOG10(P)/CPHET
C.....MEDIAN
      XTLOS = XTLOS + XLS*HOP
      CPR = FVMUF(ISMOD)/YMUF(ISMOD)
      FVFOT = YFOT(ISMOD)* CPR
      XMUF  = FVFOT/ CPHET
      DUMMY = YFOT(ISMOD)
      PF = PRBMUF(FREQ,XMUF,DUMMY,ISMOD)
      XLSL = -10.*ALOG10(PF)/CPHET
      FVHPF = YHPF(ISMOD)*CPR
      XMUF  =  FVHPF/CPHET
      DUMMY = YHPF(ISMOD)
      PF = PRBMUF(FREQ,XMUF,DUMMY,ISMOD)
      XLSU = -10.*ALOG10(PF)/CPHET
C
C DECILES OF SIGNAL LEVEL
C
c%lc:gsp, comment change 12 Jan 1995,                      subroutine  regmod
c%lc Despite the name, tllow is the signal level - lower decile; tlhgh is the
c%lc signal level - upper decile.
      TLLOW(IM) =  DSL + HOPS *(OBFL -OBF(IM)) + HOP*( XLSL - XLS)
      TLHGH(IM) =  DSU  + HOPS *(OBF(IM) - OBFU) + HOP*(XLS  - XLSU)
      TLLOW(IM) = AMIN1(TLLOW(IM) , 25.)
      TLHGH(IM) = AMIN1(TLHGH(IM) , 25.)
C.....ENDING OF TRANSMISSION LOSS DISTRIBUTION
C
C.....THIS IS F.DAYS (NOT USED ELSEWHERE)
c%lc:gsp, change 1b     12 Jan 1995,                       subroutine  regmod
c%lc      the next two lines have been superceded by change 1a above.
c%lc            DUMMY = YMUF(ISMOD)
c%lc            PROB(IM) = PRBMUF(FREQ,DUMMY,DUMMY,ISMOD)
c%lc. end change 1b
      ITRY = -1
      TLOSS (IM) = XTLOS
C.....FLDST(IM) IS FIELD STRENGTH
C.....SIGPOW(IM) IS SIGNAL
C.....SN(IM) IS SIGNAL TO NOISE
C.....B(IM) IS RADIATION ANGLE
C.....NMODE(IM) IS MODE
C.....HP(IM) IS VIRTUAL HEIGHT
C.....HN(IM) IS NUMBER OF HOPS
      FLDST(IM) = 107.2 + PWRDB(FREQ)+20.*ALOG10(FREQ)-XTLOS-RGAIN(IM)
      SIGPOW (IM) = PWRDB(FREQ) - XTLOS
      SN(IM) = SIGPOW(IM) - RCNSE
      B (IM) = DELMOD(IM,K)
      NMODE(IM) = ISMOD
      HP(IM) = HPMOD(IM,K)
      HN(IM)   = IHOP
 240  CONTINUE
      RETURN
      END
