c# relbil.f
      SUBROUTINE RELBIL (IF)
C
C     THIS ROUTINE COMPUTES THE RELIABILITY FOR EACH MODE AT A
C     PARTICULAR FREQUENCY, SELECTS THE MOST RELIABLE, CALCULATES THE
C     COMBINED DISTRIBUTION FOR ALL MODES AND THE RELIABILITY OF THE
C     COMBINATION, AND THE REQUIRED POWER PLUS GAIN TO ACHIEVE THE
C     REQUIRED RELIABILITY
C
C     SN(IM) = MEAN SIGNAL TO NOISE FOR MODE IM
C
C.....SIGNAL STATISTICS
C DSU =UPPER DECILE SIGNAL LEVEL ADJUSTMENT FROM MEDIAN
C ASM = AURORAL ADJUSTMENT TO MEDIAN SIGNAL LEVEL
C DSL = LOWER DECILE SIGNAL LEVEL ADJUSTMENT FROM MEDIAN
C     ADS = MEAN PREDICTION ERROR
C     SUS = UPPER DECILE PREDICTION ERROR
C     SLS = LOWER DECILE PREDICTION ERROR
C
C.....NOISE STATISTICS
C     RCNSE = MEAN NOISE LEVEL
C     DU = UPPER DECILE NOISE LEVEL
C     DL = LOWER DECILE NOISE LEVEL
C
C     RSN = REQUIRED SIGNAL TO NOISE RATIO
C     DRSN = 2. = RSN PREDICTION ERROR
C     LUFP = GIVEN REQUIRED RELIABILITY
C     IF = FREQUENCY INDEX, FREQ = FREL(IF)
C
C
C     RELIAB(IF) = RELIABILITY
C     SPROB(IF) = SERVICE PROBABILITY
C
      common /sncom/ snxx(13)
      common /cgains/ gaint(13),gainr(13)
      common /Crneff/ rneff(13)
      COMMON / ALPHA / IMON(12), IRCVR(2), ITRAN(2), MODE(13),
     A MODER(13)
      COMMON/ANOIS/ATNU,ATNY,CC,TM,XEFF,RCNSE,DU,DL,SIGM,SXGU,SXGL,KJ,JK
      COMMON /DUDL_NOIS/ DU_NOIS(13),DL_NOIS(13)
      COMMON /CON /D2R, DCL, GAMA, PI, PI2, PIO2, R2D, RZ, VOFL
      COMMON / DON /  AMIND, DMP, PMP, RSN, ATMNO,
     1                D90R, D50R, D10R, D90S, D50S, D10S
      COMMON / FRQ / FREL(29), FREQ,JMODE
      COMMON / ION /  IEA, IFQB, IFQE, IGRAPH, IHRE, IHRO, IHRS, JO,
     A LUFP, METHOD, MONPR, NDAY, NES, NOISE, NPAT, NPSL, NRSP, NUMO
      COMMON/MUFS/EMUF(24),FIMUF(24),F2MUF(24),ESMUF(24),ALLMUF(24),FOT
     A(24),XLUF(24),HPF(24),ANGMUF(24),MODMUF,SIGL(4),SIGU(4),DELMUF(4)
     B ,HPMUF(4),HTMUF(4),FVMUF(4),AFMUF(4),NHOPMF(4),YFOT(4),YHPF(4)
     C ,YMUF(4)
      COMMON / OUTLAB / LABEL(11), LAYTYP(5), LABLI, LABLJ, LABLK
      COMMON/SIGD/DSL,ASM,DSU,AGLAT,DSLF,ASMF,DSUF,ACAV,FEAV,AFE,BFE
     A ,XVE
      COMMON / SON / ANGLE(13), ANGLER(13), CPROB(13), DBLOS(13),
     A DBLOSL(13), DBLOSU(13), DBU(13), DELAY(13),XNDBW(13), NHP(13),
     B XNYNOIS(13), PROBMP(13), RELIAB(13), SNDB(13), SNPR(13),
     C SNRLW(13), SNRUP(13), SPROB(13), VHIGH(13)
      COMMON /TON /ADJ, ADS, ATMO, GNOS, ZCNSE, REL, SL, SLS
     1, SU, SUS, ZEFF, XNOISE, XTLOS, ZNOISE, NF
      COMMON / ZON / ABPS(7), CREL(7), EFF(7), FLDST(7), GRLOS(7),
     1HN (7), HP (7), PROB (7), RELY (7), RGAIN (7), SIGPOW (7), SN (7),
     2 SPRO (7), TGAIN (7), TIMED (7), TLOSS (7), B (7), FSLOS (7), ADV
     C(7),OBF(7),NMODE(7),NREL,TLLOW(7),TLHGH(7)
      DIMENSION TME(10)
      CHARACTER MODE*2, LAYTYP*2
      CHARACTER IMON*3, IRCVR*10, ITRAN*10, MODER*2,
     A  LABEL*5,
     B  LABLI*5, LABLJ*5, LABLK*5
      DOUBLE PRECISION XDSLW,XSIGS,XDSUP,XFLD
C.....NORMAL DISTRIBUTION
      DATA TME/ 0.0,0.1257,0.2533, 0.3853,0.5244,0.6745,0.8416,1.0364,
     A 1.2815,1.6449/
      DATA XEPS/0.05/
      D50R = RSN
      D10R = 20.
       D90R = 20.
ccc      if(if.ne.-10) return
C.....BEGINNING OF RELIABILITY CALCULATION FOR EACH MODE
C
C.....USED TO SELECT 1 OF UP TO 6 MODES FOR EACH HOP
C.....ON THE LAST CALL THE MOST RELIABLE WILL BE OUTPUT
      DO 310 IM = 1,6
      IF( HP(IM) .GT. 70. ) GOTO 110
      CREL(IM) = 0.001
      RELY(IM) = 0.001
      GO TO 310
  110 IS = NMODE(IM)
      DSLF = TLLOW(IM)
      DSUF = TLHGH(IM)
C  REQUIRED SIGNAL TO NOISE DISTRIBUTION
c%lc:gsp 28-DEC-1994:1st change, subroutine RELBIL *********************
c%lc    D10R is the lower distribution variable for the snr; values of snr
c%lc    at this end of the snr distribution reflect high noise & low signal.
c%lc    As such, D10R = f(DU2, DSLF).  Similarly, D90R = f(DL2, DSUF)
      D10R = SQRT(DU*DU + DSLF*DSLF)
      D50R = SN(IM)
      D90R = SQRT( DL*DL + DSUF*DSUF )
c%lc        D10R = SQRT(DL*DL + DSLF*DSLF)
c%lc        D50R = SN(IM)
c%lc        D90R = SQRT( DU*DU + DSUF*DSUF )
c%lc:gsp 28-DEC-1994:end change ***************************************
      Z =  RSN - D50R
      IF( Z .LE. 0.0) THEN
      Z = Z/(D10R/1.28)
      ELSE
      Z = Z/(D90R/1.28)
      ENDIF
      RELY(IM) = 1. - FNORML(Z)
C.....CREL IS NOT USED NOW
      CREL(IM) =  1000.
  310 CONTINUE
C
C.....END OF RELIABILITY CALCULATION FOR EACH MODE
C  MOST RELIABLE  MODE
C
ccc      IRmethod=1         !  original - if RELs are within .05 of each other
      IRmethod=2         !   if RELs are within 5% of each other
ccc      IRmethod=3         !  original, but if MRM REL is < .01 use mode with max
      IRmax=0
c          the original way of looking for the MRM in the 140 loop could
c          produce an improper mode.
c          Thus, first find the max REL mode
      do 10 im=1,6
      IF( HP(IM).LT.0.0 ) GOTO 10   !  mode does not exist
      if(IRmax.eq.0) IRmax=im
      if(RELY(IM).gt.RELY(IRmax)) IRmax=IM   !  IRmax will be the mode with max REL
10    continue

      IR=IRmax
      XREL = RELY(IR)
      XHN  = HN(IR)
      XSN  = SN(IR)
ccc      write(9,311) ir,rely(ir),hn(ir),sn(ir)
ccc311   format('mode=',i5,3f10.5)
       JIN = 1
      DO 140 IM= 1,6
ccc      write(9,311) im,rely(im),hn(im),sn(im)
      IF( HP(IM).LT.0.0 ) GOTO 140   !  mode does not exist
      JIN = JIN +1
C.....MAKE SELECTION BASED ON RELIABILITY FIRST BUT IF CLOSE SELECT ON
C.....LOWER NUMBER OF HOPS (IF THE NUMBER OF HOPS ARE EQUAL SELECT BY
C.....MEDIAN SNR)
      if(xrel.lt..00000001) xrel=.00000001
      RELtest=abs(RELY(IM)-XREL)
      if(IRmethod.eq.2) RELtest=RELtest/XREL        !  use percentage of max REL
      if(RELtest.ge.XEPS) go to 140                 !  REL not close to max REL
c          Close, so test if # hops are equal
      IF(ABS(XHN - HN(IM)) .LE. XEPS) then
c          # hops are equal, so test median SNR
         IF( XSN .LT. SN(IM)) then
            go to 139
         end if
       else if(XHN.gt.HN(IM)) then     !  this one has fewer hops
            go to 139
       end if
      go to 140
  139 IR = IM       !  this mode is better
      XHN=HN(IM)
      XSN=SN(IM)
      XREL = RELY(IM)
  140 CONTINUE
c          if REL is small (<.01) use mode with highest REL
      if(IRmethod.eq.3 .and. RELY(IR).lt..01) IR=IRmax

ccc      write(9,'('' jin='',i3,6(f4.1,f8.2))') jin,(hn(im),hp(im),im=1,6)
      IF( HP(IR) .LE. 0.0) GOTO 355
      NREL = IR
ccc      write(9,141) nrel
ccc141   format('nrel=',i5)
      IS = NMODE(IR)
      IF ( JIN .GT. 1 ) GOTO 365
      RELIAB(IF) = RELY(IR)
      DBLOSL(IF) = TLLOW(IR)
      DBLOSU(IF) = TLHGH(IR)
      DBU(IF) = FLDST(IR)
      SNDB(IF) = SN(IR)
ccc      write(9,'('' in relbil, sndb('',i2,'')=sn('',i2,'')='',f9.3)')
ccc     +       if,ir,sndb(if)
      XNDBW(IF) = SIGPOW(IR)
      GO TO 372
C  ADD THE SIGNALS (RANDOM PHASE APPROXIMATION = ADD THE POWERS IN WATTS
  365 XDSLW = 0.0
      XSIGS = 0.0
      XDSUP = 0.0
      XFLD = 0.
      DO 370 IM = 1,6
      IF( HP(IM) .LT. 0.0) GOTO 370
      ZEXPP = .1*(SIGPOW(IM) - TLLOW(IM) )
      if(ZEXPP.gt.-500.) XDSLW = XDSLW + 10.D0 ** ZEXPP
      ZEXPP = .1*SIGPOW(IM)
      if(ZEXPP.gt.-500.) XSIGS = XSIGS +10.D0 ** ZEXPP
      ZEXPP = .1 * (SIGPOW(IM) + TLHGH(IM))
      if(ZEXPP.gt.-500.) XDSUP = XDSUP + 10.D0 ** ZEXPP
C  MUST DO FIELD STRENGTH SEPARATE  BECAUSE OF RECEIVE ANTENNA
      ZEXPP = .1*FLDST(IM)
      if(ZEXPP.gt.-500.) XFLD = XFLD + 10.D0 **ZEXPP
  370 CONTINUE
      if(XSIGS.le.0.) then
         SIGMED=-500.
      else
         SIGMED = 10.*DLOG10(XSIGS)
      end if
      if(XDSLW.le.0.) then
         DBLOSL(IF)=0.
      else
         DBLOSL(IF) = ABS( SIGMED - 10.*DLOG10(XDSLW) )
      end if
      if(XDSUP.le.0.) then
         DBLOSU(IF)=0.
      else
         DBLOSU(IF) = ABS( 10.*DLOG10(XDSUP) - SIGMED )
      end if
      if(DBLOSL(IF).lt. .2) DBLOSL(IF)=.2    !  set min GRH 8/21/02
      if(DBLOSL(IF).gt.30.) DBLOSL(IF)=30.   !  set max GRH 8/21/02
      if(DBLOSU(IF).lt. .2) DBLOSU(IF)=.2    !  set min GRH 8/21/02
      if(DBLOSU(IF).gt.30.) DBLOSU(IF)=30.   !  set max GRH 8/21/02
      XNDBW(IF) = SIGMED
      DELSIG = SIGMED - SIGPOW(IR)
      if(XFLD.le.0.) then
         DBU(IF)=-500.
      else
         DBU(IF) = 10.*DLOG10(XFLD)
      end if
      SNDB(IF) = SN(IR) + DELSIG
ccc      write(9,'('' in relbil, sndb('',i2,'')=sn('',i2,'')='',2f9.3)')
ccc     +       if,ir,sndb(if),delsig
  372 CONTINUE
C  REDO RELIABILITY FOR SUM OF MODES
c%lc:gsp 22-FEB-1995:change missed earlier, subroutine RELBIL **************
      D10R = SQRT( DU*DU + DBLOSL(IF)*DBLOSL(IF) )
      D50R = SNDB(IF)
      D90R = SQRT( DL*DL + DBLOSU(IF)*DBLOSU(IF) )
      if(D10R.lt. .2) D10R=.2     !  set min GRH 8/21/02
      if(D10R.gt.30.) D10R=30.    !  set max GRH 8/21/02
      if(D90R.lt. .2) D90R=.2     !  set min GRH 8/21/02
      if(D90R.gt.30.) D90R=30.    !  set max GRH 8/21/02
c%lc:      D10R = SQRT( DL*DL + DBLOSL(IF)*DBLOSL(IF) )
c%lc:      D50R = SNDB(IF)
c%lc:      D90R = SQRT( DU*DU + DBLOSU(IF)*DBLOSU(IF) )
c%lc:gsp 22-FEB-1995:end change ***************************************
      gaint(if)=TGAIN(IR)                 !  transmitter gain
      gainr(if)=RGAIN(IR)                 !  receiver    gain
      SNRLW(IF) = D10R
      SNRUP(IF) = D90R
      Z = RSN - D50R
      IF( Z .LE. 0.0) THEN
        Z=Z/(D10R/1.28)
      ELSE
        Z=Z/(D90R/1.28)
      ENDIF
      RELIAB(IF) = 1. - FNORML(Z)
ccc      write(9,777) if,reliab(if)
ccc777   format('if=',i5,'    REL=',f10.6)
ccc      RELIAB(IF) = RELIAB(IF) * PROB(IR)  !  add F DAYS as per Frank Stewart
      ANGLE(IF) =  B(IR)
      CPROB (IF)= PROB (IR)
      DBLOS (IF)= TLOSS(IR)
      DELAY (IF)= TIMED(IR)
      VHIGH (IF)= HP   (IR)
      MODE  (IF)= LAYTYP(IS)
      NHP   (IF)= NINT(HN(IR))
      XNYNOIS(IF)= RCNSE
      DU_NOIS(IF)=DU
      DL_NOIS(IF)=DL
      XEFF = EFF(1)
      ZEFF = EFF(1)
      XEFF = EFF(IR)     !  should these be IR (changed 1/5/2005)
      ZEFF = EFF(IR)
      rneff(if)=EFF(IR)
C  REQUIRED POWER GAIN  FOR SPECIFIED RELIABILITY.
      ITM = IABS( (LUFP - 50))/5 +1
      ITM = MIN0(ITM,10)
      TMX = TME(ITM)/TME(9)
      IF( LUFP .LT. 50) THEN
        SNPR(IF) = -(D50R + TMX * D90R) +RSN
      ELSE
        SNPR(IF) = -(D50R - TMX * D10R) +RSN
      ENDIF
ccc      SN90(IF)=D50R - D10R                !  lower decile SNR (90%)
c          change to calculate SNR at Required Reliability
      snxx(IF)=RSN - SNPR(IF)
  355 CONTINUE
ccc      write(*,358) (hn(im),laytyp(nmode(im)),im=1,6)
ccc358   format(11x,6(f7.0,a2))
ccc      write(*,357) (b(im),im=1,6)
ccc357   format(11x,6f9.2)
ccc      write(*,356) if,(fldst(im),im=1,6),dbu(if)
ccc356   format(' IF=',i2,'  Fs=',6f9.2,'  dbu=',f9.2)
      RETURN
      END
