c# serprb.f
      SUBROUTINE SERPRB(SPROB)
C
C THIS SUBROUTINE CALCULATES THE SERVICE PROBABILITY WHICH IS THE
C PROBABILITY THAT THE GRADE OF SERVICE (GR) DEFINED BY THE REQUIRED
C SIGNAL-TO-NOISE RATIO WILL BE ACHIEVED OR EXCEEDED FOR A SPECIFIED
C TIME AVAILABILITY QR.  IN OTHER WORDS, THE PROBLEM IS TO ASSESS THE
C PROBABILITY THAT THE SPECIFIED GRADE OF SERVICE FOR A GIVEN
C PERCENTAGE OF THE DAYS WITHIN THE MONTH AT SOME SPECIFIED HOUR WILL
C BE PROVIDED BY THE CALCULATED AVAILABLE SIGNAL-TO-NOISE RATIO.
C
C INPUT:
C
C    LUFP      =    THE REQUIRED CIRCUIT RELIABILITY, WHICH IS AN
C                   ESTIMATE OF THE PERCENTAGE OF DAYS WITHIN THE
C                   MONTH THAT THE SIGNAL QUALITY WILL BE
C                   ACCEPTABLE, AND IS SPECIFIED AS TIME
C                   AVAILABILITY FOR SERVICE PROBABILITY
C                   CALCULATION. (NOTE:  LUFP IS EXPRESSED AS A
C                   PERCENTAGE.)  THE PROGRAM USES A DEFAULT VALUE
C                   OF 90 IF THIS PARAMETER IS NOT SET BY THE
C                   USER.
C    RSN       =    REQUIRED SIGNAL TO NOISE RATIO (DECRED)
C    SN(K)     =    Signal-to-Noise Ratio for MODE K (REGMOD, ESMOD)
C    HP(K)     =    Virtual Height of reflection for MODE K (RDMOD, ESMOD)
C    DU        =    UPPER DECILE OF THE TOTAL NOISE (GENOIS)
C    DL        =    LOWER DECILE OF THE TOTAL NOISE (GENOIS)
C    SIGM      =    Standard Deviation of the MEDIAN NOISE
C                   (prediction error) (GENOIS)
C    SIGU      =    Standard Deviation of the Noise UPPER DECILE
C                   (prediction error) (GENOIS)
C    SIGL      =    Standard Deviation of the Noise LOWER DECILE
C                   (prediction error) (GENOIS)
C    TLLOW(K)  =    Lower decile of TRANSMISSION LOSS DISTRIBUTION
C                   for mode K (REGMOD,ESMOD)
C    TLHGH(K)  =    Upper decile of TRANSMISSION LOSS DISTRIBUTION
C                   for mode K (REGMOD,ESMOD)
C    ADS       =    Standard deviation of MEDIAN EXCESS SYSTEM LOSS
C                   (prediction error) (SIGDIS)
C    SUS       =    Standard deviation of UPPER DECILE of EXCESS SYSTEM LOSS
C                   (prediction error) (SIGDIS)
C    SLS       =    Standard deviation of LOWER DECILE of EXCESS SYSTEM LOSS
C                   (prediction error) (SIGDIS)
C
C
C OUTPUT:
C    SPRO(K)   =    Service Probability for mode K for the required
C                   reliability
C    SPROB     =    Maximum of SPRO(K) for all modes K=1,NMMOD.
C    D50S      =    Median Signal-to-Noise ratio deviation of best mode.
C    D10S      =    "Additional" required Signal-to-Noise ratio
C                   for the required reliability
C
C LOCAL VARIABLES
C         DR   =    Standard Deviation of the Required Signal-to-Noise
C                   Ratio (RSN)
C              =    2.0 dB (SET IN DATA STATEMENT)
C        TMX   =    Standard normal deviate corresponding to the 
C                   required circuit reliability (LUFP)
C                   NORMAL DISTRIBUTION
C                   .5 = 0.0,  .55 = 0.1257,..., .9 = 1.2815, .95
C                   = 1.6449
C                   The selection is made on the nearest 5% value of LUFP.
C   FNORML(Z) =     Standard normal deviate cumulative distribution function
C------------------------------------------------------------
C          Start of Common Area 
C------------------------------------------------------------
C
      COMMON/ANOIS/ATNU,ATNY,CC,TM,XEFF,RCNSE,DU,DL,SIGM,SIGU,SIGL,KJ,JK
      COMMON/CON/D2R,DCL,GAMA,PI,PI2,PIO2,R2D,RZ,VOFL
      COMMON / DON /  AMIND, DMP, PMP, RSN, ATMNO,
     1                D90R, D50R, D10R, D90S, D50S, D10S
      COMMON / ION /  IEA, IFQB, IFQE, IGRAPH, IHRE, IHRO, IHRS, JO,
     A LUFP, METHOD, MONPR, NDAY, NES, NOISE, NPAT, NPSL, NRSP, NUMO
      COMMON/TON/ADJ,ADS,ATMO,GNOS,ZCNSE,REL,SL,SLS,SU,SUS
     A ,ZEFF,XNOISE,XTLOS,ZNOISE,NF
      COMMON/ZON/ABPS(7),CREL(7),EFF(7),FLDST(7),GRLOS(7),HN(7),HP(7)
     A ,PROB(7),RELY(7),RGAIN(7),SIGPN(7),SN(7),SPRO(7),TGAIN(7),TIMED
     B(7),TLOSS(7),B(7),FSLOS(7),ADV(7),OBF(7),NMODE(7),NREL
     C , TLLOW(7),TLHGH(7)
      DIMENSION TME(10),d10sa(6),d50sa(6)
C.....NORMAL DISTRIBUTION
      DATA TME/0.0,0.1257,0.2533,0.3853,0.5244,0.6745,0.8416,1.0364
     A , 1.2815, 1.6449 /
C.....DR IS THE PREDICTION ERROR IN RSN, REQUIRED SNR
      DATA DR/2./
C.....LUFP IS THE REQUIRED RELIABILITY
      ITM = IABS( LUFP - 50) /5 +1
      ITM = MIN0(ITM,10)
      TMX = TME(ITM)
C.....BEGINNING OF FINDING THE SERVICE PROBABILITY FOR EACH MODE
      DO 145 K = 1,6
      IF( HP(K).le.70.) then
C.....SET DEFAULT FOR NO MODE
         SPRO(K) = .001
         d10sa(K)=0.
         d50sa(K)=0.
         GO TO 145
      end if
      IF( LUFP.ge.50) then
C.....DN IS THE NOISE
C.....DS IS THE SIGNAL FOR THIS MODE
         DN  = TMX *DU/DCL
         DS  = TMX *TLLOW(K)/DCL
         XLH = -1.
C.....SIGNAL PREDICTION ERROR
         DSO = TMX *SUS
         DNO = TMX * SIGU/DCL
      else
         DN  = TMX *DL/DCL
         DS  = TMX *TLHGH(K)/DCL
         XLH = 1.
         DSO = TMX * SLS
         DNO = TMX *SIGL/DCL
      end if
C.....D50S IS THE MEDIAN
      d50sa(K)=SQRT(DN*DN + DS*DS)
      d10sa(K)=d50sa(K) +
     +        SQRT(SIGM*SIGM + ADS*ADS + DNO*DNO + DSO*DSO + DR*DR)
      d50sa(K) =  SN(K)  + XLH*d50sa(K)
      Z = (RSN - d50sa(K))/d10sa(K)
C.....SERVICE PROBABILITY FOR THIS MODE
      SPRO(K) =  1. - FNORML(Z)
  145 CONTINUE
C.....END OF FINDING THE SERVICE PROBABILITY FOR EACH MODE
C
C.....USE THE MAXIMUM
      imax=1
      do 150 K=1,6
      if(SPRO(K).gt.SPRO(imax)) imax=K
150   continue
      SPROB = SPRO(imax)
      D10S=d10sa(imax)
      D50S=d50sa(imax)
      D90S=d10sa(imax)
      RETURN
      END
