c# sigdis.f
      SUBROUTINE SIGDIS
C
C  ADJUST SIGNAL DISTRIBUTION TABLES FOR THIS PATH AND SET ABSORPTION
C  LOSS PARAMETERS
C
      common /pcvers/ versn
         character versn*8     !  a "H" ignores the absorption fix
      COMMON/CON/D2R,DCL,GAMA,PI,PI2,PIO2,R2D,RZ,VOFL
      COMMON/FRQ/FREL(29),FREQ,JMODE
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
      COMMON/MUFS/EMUF(24),F1MUF(24),F2MUF(24),ESMUF(24),ALLMUF(24),FOT
     A (24),XLUF(24),HPF(24),ANGMUF(24),MODMUF,SIGL(4),SIGU(4),DELMUF(4)
     B ,HPMUF(4),HTMUF(4),FVMUF(4),AFMUF(4),NHOPMF(4),YFOT(4),YHPF(4)
     C ,YMUF(4)
      COMMON /RON /RAT(5),CLCK(5),ABIY(5),ARTIC(5),SIGPAT(5),EPSPAT(5),
     1 FI(3,5),YI(3,5),HI(3,5),FX(3,5),HPRIM(30,3),HTRUE(30,3),
     2 FVERT(30,3),KFX,AFAC(30,3),HTR(54),FNSQ(54)
      COMMON/SIGD/DSL,ASM,DSU,AGLAT,DSLF,ASMF,DSUF,ACAV,FEAV,AFE,BFE
     A ,XVE
      COMMON/TIME/IT,GMT,UTIME(24),GMTR,XLMT(24),ITIM
      COMMON/TON/ADJ,ADS,ATMO,GNOS,RCNSE,REL,SL,SLS,SU,SUS
     A ,XEFF,XNOISE,XTLOS,ZNOISE,NF
      GLAV = 0.0
C.....SET NUMBER OF IONOSPHERES
      XKF  = KFX
      XADJ = 0.0
      XSU  = 0.0
      XSL  = 0.0
      XFMP = 0.0
      XSUP = 0.0
      XSLP = 0.0
      AC = 0.0
      FEAV=0.0
      ND=2
      IF(GCDKM .GE. 2500.0) ND=5
      DO 115 K = 1,KFX
C.....ABSORPTION INDEX
      ABIY(K) =  - 0.04 + EXP(-2.937 + 0.8445*FI(1,K) )
c******  2 Changes added 3/18/93 by Frank Stewart to fix losses problem
      if(iflg(k).eq.5 .or. iflg(k).eq.1) ABIY(K)=0.1
c          this limits ABIY to a lower limit of .1 because that is the
c          lower limit of the curve.
c          IONCAP was wrong when it did not have the lower limit.
c          It was too optimistic with its prediction.
c          this allows the "HAM" version to ignore the absorption fix
c          to activate the "HAM" version, edit the file:
c               ..\database\version.w32
c               change the "W" to "H"
c           this was changed 2/8/2006 for Dean Straw
c           this wa schanged 4/18/2006 to use "I" instead of "H". "I"=IONCAP
      if(versn(7:7).ne.'I') then
         ABIY(K)=MAX(0.1,ABIY(K))
      end if
C.....SYSTEM LOSS TABLE
      DUMMY1 = GLAT(K)
      DUMMY2 = CLCK(K)
      CALL SYSSY(DUMMY1,DUMMY2,ND,ADJ,SU,SL,FMP,SUP,SLP)
C.....MEDIAN
      XADJ = XADJ + ADJ
C.....UPPER DECILE
      XSU  = XSU  + SU
C.....LOWER DECILE
      XSL  = XSL  + SL
C.....PREDICTION ERROR, MEDIAN
      XFMP = XFMP + FMP
C.....UPPER DECILE
      XSUP = XSUP + SUP
C.....LOWER DECILE
      XSLP = XSLP + SLP
C.....E CRITICAL
      FEAV = FEAV + FI(1,K)
C.....ABSORBTION INDEX
      AC   = AC   + ABIY(K)
      ARTIC(K) = ADJ
C.....GEOMAGNETIC LATITUDE
      GLAV = GLAV + ABS(GLAT(K))
  115 CONTINUE
C.....BEGIN SECTION TO SAVE THE AVERAGE VALUES
      GLAV= GLAV/XKF
      AGLAT = GLAV
      ACAV= AC/XKF
      FEAV= FEAV/XKF
      ADJ = XADJ/XKF
      SU  = XSU/XKF
      SL  = XSL/XKF
      ADS = XFMP/XKF
      SUS = XSUP/XKF
      SLS = XSLP/XKF
C.....END SECTION TO SAVE THE AVERAGE VALUES
      K = JMODE
C
C  PARAMETER FOR D-E ABSORTION LOSS.
C  ABIY( )  IS ABSORPTION INDEX. ACAV IS THE AVERAGE FOR THE PATH
C
C.....D - E REGION LOSS ADJUSTMENT FACTOR
      XVE    = XLIN( 90., HTRUE,FVERT,30, K )
      XVE    = XVE/FI(1,K)
      IF(FEAV - 2.0) 125,125,120
C.....ADJUSTMENT TO CCIR 252 (HAYDON,LUCAS) LOSS EQUATION FOR E MODES
  120 AFE  = 1.359
      BFE  = 8.617
      GO TO 140
  125 IF(FEAV - 0. 5) 130,130,135
  130 AFE  = 0.0
      BFE  = 0.0
      GO TO 140
  135 AFE  = 1.359 *(FEAV - 0.5)/1.5
      BFE  = 8.617 *(FEAV - 0.5)/1.5
  140 CONTINUE
C
C  SET SIGNAL DISTRIBUTION TABLES. TABLE IS FOR FREQ = FTAB
C
C.....USE FOT, F2 LAYER
      GLAV = GLAV*R2D
      IF( GLAV - 40.)  145,145,150
  145 FTAB = YFOT(3)
      GO TO 165
  150 IF(GLAV  - 50.)  155,155,160
  155 FTAB = YFOT(3)
C.....INTERPOLATE IN BETWEEN
      FTAB = FTAB  - (GLAV - 40.)*(FTAB - 10.)/ 10.
      GO TO 165
C.....SET TO 10 MHZ (NEAR POLES)
  160 FTAB = 10.
  165 CONTINUE
      ESLSM = 0.0
       IF(YMUF(4) ) 167,167,166
  166 CONTINUE
C   ES CONTRIBUTION TO TABLE( OBSCURTION LOSS).
C
C.....NOW REMOVE ES OBSCURATION AND F2 OVER-THE-MUF AT FTAB FROM TABLES
C.....AND WILL REPLACE FOR EACH MODE AND FREQUENCY AS NECESSARY
      DUMMY = YMUF(4)
      PES = PRBMUF(FTAB,DUMMY,DUMMY,4)
      PES =AMAX1(0.1,PES)
      PES =AMIN1(0.9,PES)
      ESLSM = -10.*ALOG10(1.-PES)
C  F2 OVER-THE-MUF CONTRIBUTION TO TABLE
C.....PROBABILITY CALCULATION
  167 CONTINUE
      DUMMY = YMUF(3)
      PF2 = PRBMUF(FTAB,DUMMY,DUMMY,3)
      PF2 = AMAX1(0.1, PF2)
ccc      PF2 =AMIN1(0.9,PF2)        !  this added 5/12/2005 GRH
      F2LSM = -10.*ALOG10(PF2)
C RESIDUAL (AURORAL) LOSS ADJUSTMENT TO MEDIAN SIGNAL LEVEL.
      ASM = ADJ  - ESLSM - F2LSM
      ASM = AMAX1(ASM, 0.0 )
C  UPPER DECILE
      PES = 0.0
      IF( YFOT(4) ) 169,169,168
  168 CONTINUE
      DUMMY = YFOT(4)
      PES = PRBMUF(FTAB,DUMMY,DUMMY,4)
      PES = AMAX1( 0.1,PES)
      PES = AMIN1( 0.9,PES)
  169 CONTINUE
      DUMMY = YHPF(3)
      PF2 = PRBMUF(FTAB,DUMMY,DUMMY,3)
      PF2 = AMAX1(0.1, PF2)
ccc      PF2 =AMIN1(0.9,PF2)        !  this added 5/12/2005 GRH
C  UPPER DECILE SIGNAL LEVEL ADJUSTMENT TO MEDIAN
      DSU = 1.28* SL  -( +10.*ALOG10(1.- PES) + ESLSM)
     A                -( +10.*ALOG10(PF2) + F2LSM)
      DSU = AMAX1 ( DSU, 0.5)
C  LOWER DECILE.
      PES = 0.0
       IF(YHPF(4) ) 175,175,170
  170 CONTINUE
      DUMMY = YHPF(4)
      PES = PRBMUF(FTAB,DUMMY,DUMMY,4)
      PES= AMAX1(0.1,PES)
      PES= AMIN1(0.9, PES)
  175 CONTINUE
      DUMMY = YFOT(3)
      PF2 = PRBMUF(FTAB,DUMMY,DUMMY,3)
      PF2 = AMAX1( 0.1,PF2)
ccc      PF2 =AMIN1(0.9,PF2)        !  this added 5/12/2005 GRH
C LOWER DECILE SIGNAL LEVEL ADJUSTMENT TO MEDIAN
      DSL = 1.28* SU - (-10.*ALOG10(1.-PES) - ESLSM)
     A               - (-10.*ALOG10(PF2) - F2LSM)
      DSL = AMAX1(1.,DSL)
      RETURN
      END
