c# solpos.f
      SUBROUTINE SOLPOS( IYR,IMO,IDA,TIMLOC,GGLAT,GGLON,CHI,DECLIN,
     +                   SUNRIS,SUNSET )
C***********************************************************************
C* SUBROUTINE NAME :  SOLPOS            CPC:  SS/MOD/RTN/SOLPOS        *
C*          VERSION:  88-II            DATE:  16 MAR 88                *
C*                                                                     *
C*          PURPOSE:  THIS SUBROUTINE COMPUTES THE SOLAR ZENITH ANGLE, *
C*                    DECLINATION, AND TIMES OF SUNRISE AND SUNSET FOR *
C*                    THE SPECIFIED LOCATION AND TIME.                 *
C*                                                                     *
C*          CALLING                                                    *
C*        ARGUMENTS:  IYR,IMO,IDA,TIMLOC,GGLAT,GGLON,CHI,DECLIN,       *
C*                    SUNRIS,SUNSET                                    *
C*                                                                     *
C*    ABBREVIATIONS:  NONE                                             *
C*                                                                     *
C*    COMMON BLOCKS:  NONE ACCESSED                                    *
C*                                                                     *
C*   FILES ACCESSED:  NONE                                             *
C*                                                                     *
C*           METHOD:  BASED ON NEWBERN SMITH'S ALGORITHMS.             *
C*                                                                     *
C*          REMARKS:  NONE                                             *
C*                                                                     *
C*       REFERENCES:  1.  ICED-III SYSTEM DOCUMENTATION                *
C*                    2.  SPERRY FORTRAN-77 (ASCII) PRM                *
C*                    3.  AFGWC FORM 10 DX-50194                       *
C*                    4.  AFGWC FORM 10 DX-60096                       *
C*                                                                     *
C*  LOCAL VARIABLES:  HOUR     IS  LOCAL HOUR AT GRIDPOINT             *
C*                    IDA      IS  DAY OF DATA SET                     *
C*                    IL       IS  TEMPORARY VARIABLE IN TIME EQUATION *
C*                    IMO      IS  MONTH OF DATA SET                   *
C*                    IYR      IS  YEAR OF DATA SET
C*                    LD       IS  LOCAL JULIAN DAY                    *
C*                    LY       IS  LOCAL YEAR ADJUSTED TO FOURIER EPOCH*
C*                    MINUTE   IS  LOCAL MINUTE AT GRIDPOINT           *
C*                    NDO(12)  IV  CUMULATIVE DAYS IN A NON-LEAP YEAR  *
C*                    A        RS  TEMPORARY VARIABLE IN ZENITH CALC.  *
C*                    B        RS  TEMPORARY VARIABLE IN ZENITH CALC.  *
C*                    CH       RS  UNKNOWN VARIABLE IN SUNRISE/SET CALC*
C*                    COSPHI   RS  UNKNOWN VARIABLE IN SUNRISE/SET CALC*
C*                    COSX     RS  TEMPORARY VARIABLE IN ZENITH CALC.  *
C*                    DECLIN   RS  DECLINATION OF GRIDPOINT IN DEGREES *
C*                    DECRAD   RS  DECLINATION OF GRIDPOINT IN RADIANS *
C*                    DT       RS  TEMPORARY VARIABLE IN TIME EQUATION *
C*                    DTR      RS  DEGREE TO RADIAN CONVERSION CONSTANT*
C*                    EQT      RS  TEMPORARY VARIABLE IN TIME EQUATION *
C*                    ET       RS  RESULT OF TIME EQUATION             *
C*                    FA       RS  GEOGRAPHIC LATITUDE IN RADIANS      *
C*                    GGLAT    RS  GEOGRAPHIC LATITUDE OF GRIDPOINT    *
C*                    GGLON    RS  GEOGRAPHIC LONGITUDE OF GRIDPOINT   *
C*                    PHI      RS  TEMPORARY VARIABLE IN ZENITH CALC.  *
C*                    P1       RS  FOURIER COEFFICIENT FOR 1955 EPOCH  *
C*                    P2       RS  FOURIER COEFFICIENT FOR 1955 EPOCH  *
C*                    P3       RS  FOURIER COEFFICIENT FOR 1955 EPOCH  *
C*                    P4       RS  FOURIER COEFFICIENT FOR 1955 EPOCH  *
C*                    P6       RS  FOURIER COEFFICIENT FOR 1955 EPOCH  *
C*                    SECPHI   RS  UNKNOWN VARIABLE IN SUNRISE/SET CALC*
C*                    SRLT     RS  UNKNOWN VARIABLE IN SUNRISE/SET CALC*
C*                    SUNRIS   RS  TIME OF SUNRISE                     *
C*                    SUNSET   RS  TIME OF SUNSET                      *
C*                    T        RS  TIME ADJUSTMENT IN ZENITH CALC.     *
C*                    TD       RS  TEMPORARY VARIABLE IN TIME EQUATION *
C*                    TEMP     RS  SHORTENS EQUATION TO MEET STANDARDS *
C*                    TE       RS  TIME OF EQUINOX FOR SPECIFIED YEAR  *
C*                    TERM     RS  UNKNOWN VARIABLE IN SUNRISE/SET CALC*
C*                    TF       RS  TEMPORARY VARIABLE IN ZENITH CALC.  *
C*                    TIMLOC   RS  LOCAL TIME AT GGLON                 *
C*                    WLON     RS  WEST LONGITUDE AT GRIDPOINT         *
C*                    CHI      RS  SOLAR ZENITH ANGLE IN DEGREES       *
C*  (I=INTEGER, R=REAL, C=CHARACTER, S=SCALAR, V=VECTOR, A=ARRAY)      *
C*                                                                     *
C*     SETC OPTIONS:  NONE USED                                        *
C*                                                                     *
C*       SUBPROGRAMS                                                   *
C*           CALLED:  NONE                                             *
C*                                                                     *
C*       SUBPROGRAM                                                    *
C*       CALLED BY :  MANY ROUTINES IN THE ICED PACKAGE                *
C*                                                                     *
C* PROGRAM WRITTEN:  MAR 88 - NATIONAL GEOPHYSICAL DATA CENTER (88-II) *
C*                                                                     *
C***********************************************************************
      INTEGER HOUR
      INTEGER IDA
      INTEGER IMO
      INTEGER IYR
      INTEGER LY
      INTEGER MINUTE
      INTEGER LD
      INTEGER NDO(12)
      REAL A
      REAL B
      REAL CH
      REAL COSPHI
      REAL COSX
      REAL DECLIN
      REAL DECRAD
      REAL DT
      REAL DTR
      REAL EQT
      REAL ET
      REAL FA
      REAL GGLAT
      REAL GGLON
      REAL PHI
      REAL P1
      REAL P2
      REAL P3
      REAL P4
      REAL P6
      REAL SECPHI
      REAL SRLT
      REAL SUNRIS
      REAL SUNSET
      REAL T
      REAL TD
      REAL TE
      REAL TEMP
      REAL TERM
      REAL TF
      REAL TIMLOC
      REAL WLON
      REAL CHI
 
      DATA NDO / 1,32,60,91,121,152,182,213,244,274,305,335 /
      DATA P1,P2,P3,P4,P6 /
     +   0.017203534,0.034407068,0.051610602,0.068814136,0.103221204 /
 
      DTR = 0.017453292
      LY = IYR - 60
      LD = NDO(IMO) + IDA - 1
 
      HOUR = INT( TIMLOC )
      MINUTE = ( TIMLOC - HOUR ) * 60
C......................................................................
C     SUBROUTINE IS FORMULATED IN TERMS OF WEST LONGITUDE             .
C......................................................................
      WLON = 360. - GGLON
C......................................................................
C     TIME OF EQUINOX FOR THE SPECIFIED YEAR                          .
C......................................................................
      IF ( LY.LE.0 ) THEN
        IL = INT((3.1 - LY)/4.)
      ELSE
        IL = - INT((LY + 0.1)/4.)
      ENDIF
      DT = -0.7819 + 0.24225*LY + IL
      TD = LD + (HOUR + MINUTE/60. + WLON/15.) / 24.
      TE = TD - DT
C......................................................................
C     DECLINATION OF THE SUN                                          .
C......................................................................
      DECLIN = 23.256*SIN(P1*(TE-82.242)) + 0.381*SIN(P2*(TE-44.855))
      TEMP =  0.167*SIN(P3*(TE-23.355)) - 0.013*SIN(P4*(TE+11.97))
      DECLIN = DECLIN + TEMP
      TEMP =  0.011*SIN(P6*(TE-10.410)) + 0.339137
      DECLIN = DECLIN + TEMP
      DECRAD = DECLIN * DTR
C......................................................................
C     THE EQUATION OF TIME                                            .
C......................................................................
      TF = TE - 0.5
      EQT = -7.38*SIN(P1*(TF-4.)) - 9.87*SIN(P2*(TF+9.))
      TEMP = 0.27*SIN(P3*(TF-53.)) - 0.2*COS(P4*(TF-17.))
      EQT = EQT + TEMP
      ET = EQT * DTR / 4.
C......................................................................
C     COMPUTE SOLAR ZENITH ANGLE                                      .
C......................................................................
      FA = GGLAT * DTR
      T = HOUR + MINUTE/60.
      PHI = 0.26179939 * ( T - 12.) + ET
      A = SIN(FA) * SIN(DECRAD)
      B = COS(FA) * COS(DECRAD)
      COSX = A + B * COS(PHI)
      CHI = ACOS(COSX) / DTR
 
C......................................................................
C     CALCULATE SUNRISE AND SUNSET TIMES --  AT THE GROUND            .
C     SEE EXPLANATORY SUPPLEMENT TO THE EPHEMERIS (1961) PG 401       .
C     SUNRISE AT HEIGHT H METRES IS AT                                .
C     CHI(H) = 90.83 + 0.0347 * SQRT(H)                               .
C     THIS INCLUDES CORRECTIONS FOR HORIZONTAL REFRACTION AND         .
C     SEMI-DIAMETER OF THE SOLAR DISK                                 .
C......................................................................
      CH = COS(90.83 * DTR)
      COSPHI = (CH - A) / B
C......................................................................
C     IF ABS(SECPHI) > 1., SUN DOES NOT RISE/SET                      .
C     ALLOW FOR SUN NEVER SETTING - HIGH LATITUDE SUMMER              .
C......................................................................
      SECPHI = 999999.
      IF(COSPHI.NE.0.) SECPHI = 1./COSPHI
      SUNSET = 99.
      SUNRIS = 99.
      IF(SECPHI.GT.-1.0.AND.SECPHI.LE.0.) RETURN
C......................................................................
C     ALLOW FOR SUN NEVER RISING - HIGH LATITUDE WINTER               .
C......................................................................
      SUNSET = -99.
      SUNRIS = -99.
      IF(SECPHI.GT.0.0.AND.SECPHI.LT.1.) RETURN
C......................................................................
C     COMPUTE SUNRISE AND SUNTIME TIMES                               .
C......................................................................
      PHI = ACOS(COSPHI)
      ET = ET / 0.26179939
      SRLT = 12. - PHI / 0.26179939
      TERM = ET
      SUNRIS = SRLT - TERM
      SUNSET = 24. - SRLT - TERM
      IF(SUNRIS.LT.0.) SUNRIS = SUNRIS + 24.
      IF(SUNRIS.GE.24.) SUNRIS = SUNRIS - 24.
      IF(SUNSET.LT.0.) SUNSET = SUNSET + 24.
      IF(SUNSET.GE.24.) SUNSET = SUNSET - 24.
 
      RETURN
      END
 
 
