c# suppro.f
      SUBROUTINE SUPPRO(II,HOUT,SHOUT)
C***********************************************************************
C*         PURPOSE: THIS SUBROUTINE IS THE PROFILER FOR THE PROGRAM.   *
C*                  IT CREATES THREE BASIC PROFILE TYPES:              *
C*      1)  ALL LAYERS (2 OR 3) ARE CHAPMAN LAYERS                     *
C*      2)  NO F1, CHAPMAN F2, EXPONENTIAL E LAYER WITH SCALE HEIGHT   *
C*          OF 50 KM (NIGHT TIME AURORAL E PRESENT)                    *
C*      3)  CHAPMAN F1 AND F2 LAYERS, EXPONENTIAL E LAYER WITH SCALE   *
C*          HEIGHT OF 25 KM (DAYTIME AURORAL E PRESENT)                *
C*                                                                     *
C*   ONE ADDITIONAL WRINKLE IS INTRODUCED IN THE CREATION OF A TROUGH  *
C*   PROFILE BY INCREASING THE F2 CHAPMAN SCALE HEIGHT.                *
C*         METHOD:  1. ADJUST SCALE HEIGHT TO SMOOTH FIT OF CLIMATO-   *
C*                     LOGICAL DATA.                                   *
C*                  2. DETERMINE IF TROUGH IS PRESENT; IF SO, MAKE     *
C*                     NECESSARY ADJUSTMENTS.                          *
C*                  3. ALTER SCALE HEIGHT FOR F2 CHAPMAN LAYER.        *
C*                  4. CALL TOPSID TO DETERMINE PROFILE ABOVE 500KM.   *
C*                  5. BUILD PROFILES BY CALLING EITHER CHAPMN OR      *
C*                     EXPON, DEPENDING UPON TYPES OF PROFILE.         *
C*                                                                     *
C*         CALLED:  TOPSID - DETERMINES TOPSIDE (ABOVE 500 KM)         *
C*                  CHAPMN - COMPUTES A CHAPMAN ELECTRON DENSITY       *
C*                           PROFILE                                   *
C*                  EXPON  - COMPUTES AN EXPONENTIAL PROFILE           *
C***********************************************************************
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
      COMMON / IPAR / XF2(5),XM3(5),XSL(5),XSM(5),XSU(5),XER(5)
C
      COMMON /RON /RAT(5),CLCK(5),ABIY(5),ARTIC(5),SIGPAT(5),EPSPAT(5),
     1 FI(3,5),YI(3,5),HI(3,5),FX(3,5),HPRIM(30,3),HTRUE(30,3),
     2 FVERT(30,3),KFX,AFAC(30,3),HTR(54),FNSQ(54)
C
      DATA FQ2DEN/1.24E4/
      DATA SHE/16./
      DATA EXP3/25./
      DATA EXP2/50./
      HTR(1)=70.0
      HTR(2)=80.0
C.......................................................................
C     DETERMINE FLAGS                                                  .
C.......................................................................
      IFLAG=IFLG(II)
      ITROF = 0
      IF ( IFLAG.GE.100 ) ITROF = 1
      IFL = MOD( IFLAG,2 )
      IF ( FI(2,II) .GT. FI(1,II) ) IFL = 0
C
C......................................................................
C     CONVERT SCALE HEIGHT TO ONES APPROPRIATE FOR GIVEN HMAX(S) BY
C     USING THE WROBEL SCALE HEIGHT FACTORS
C......................................................................
C
      AHOUT=ALOG(HOUT)/0.02186-203.447
      SHF2=SHOUT*(ALOG(HI(3,II))/0.02186-203.447)/AHOUT
      SHOUT=SHF2
      IF (HI(2,II).NE.0.0) SHF1=SHOUT*(ALOG(HI(2,II))/0.02186-
     a 203.447)/AHOUT
      FNE=FQ2DEN*FI(1,II)**2
      FNF1=FQ2DEN*FI(2,II)**2
      FNF2=FQ2DEN*FI(3,II)**2
      FNF2SV=FNF2
C
C......................................................................
C     IF TROUGH PROFILE, INCREASE SCALE HEIGHT TO ELONGATE THE F2
C     LAYER.  TWO CHAPMAN SCALE HEIGHTS BELOW F2 PEAK WILL FALL AT
C     240 KM OR BELOW
C......................................................................
C
      IF (ITROF.EQ.0) GO TO 10
      TRY=(HI(3,II)-240.0)/2.0
      IF (TRY.GT.SHF2) SHF2=TRY
      SHOUT=SHF2
      GO TO 20
C
C......................................................................
C     CHECK TO SEE IF CHAPMAN LAYER FROM F2 LAYER WILL GROSSLY OVER
C     SHOOT FOF1 AND ALTER SCALE HEIGHT IF NECCESSARY TO PREVENT THIS
C......................................................................
C
10    SHF2X2=2.0*SHF2
      DIFF=HI(3,II)-HI(2,II)
      IF ( DIFF.LE.0.0 ) DIFF = 1.0
      IF (SHF2X2.GT.DIFF) SHF2=DIFF/2.0
20    NPROF=1
C
C......................................................................
C     DETERMINE TOPSIDE PARAMETERS
C......................................................................
C
      CALL TOPSID(II,SHOUT,HI(3,II),ZCHT,A2S2,ATZC,S2,EDZC,FNF2)
C
C......................................................................
C     IF F1 LAYER PRESENT, DECREASE DENSITY AT F2 AND E LAYER PEAKS BY
C     THE CONTRIBUTION FROM THE CHAPMAN F1 LAYER
C......................................................................
C
      IF (FNF1.EQ.0.2) GO TO 30
      FNF2=FNF2-CHAPMN(FNF1,HI(2,II),SHF1,0.5,HI(3,II))
      FNE=FNE-CHAPMN(FNF1,HI(2,II),SHF1,0.5,HI(1,II))
      IF (FNE.LT.0.6) FNE=0.6
      IF (IFL.NE.0) NPROF=3
30    IF (IFL.NE.0.AND.FNF1.LE.0.2) NPROF=2
      F1=0.0
      DO 110 I=3,54
         H=(I-2)*10+80
         IF(I.GT.44)H=500+(I-44)*50
         IF (H.LE.ZCHT) GO TO 40
         AT1=ATAN(A2S2*H)
         FNSQ(I)=EDZC*dexp(dble(-S2*(AT1-ATZC)))
         GO TO 100
40       IF (H.LT.HI(3,II))GO TO 50
         FNSQ(I)=CHAPMN(FNF2SV,HI(3,II),SHOUT,1.0,H)
         GO TO 100
50       F2=CHAPMN(FNF2,HI(3,II),SHF2,1.0,H)
         IF (FNF1.NE.0.0) F1=CHAPMN(FNF1,HI(2,II),SHF1,0.5,H)
         IF (H.LT.HI(1,II)) GO TO 60
         GO TO (60,70,80),NPROF
60       FE=CHAPMN(FNE,HI(1,II),SHE,0.5,H)
         GO TO 90
70       FE=EXPON(FNE,HI(1,II),EXP2,H)
         GO TO 90
80       FE=EXPON(FNE,HI(1,II),EXP3,H)
90       FNSQ(I)=FE+F1+F2
100      IF ( FNSQ(I).LT.0.0 ) FNSQ(I) = 0.0
         FNSQ(I) =FNSQ(I)/FQ2DEN
         HTR(I) = H
110   CONTINUE
         FNSQ(2) = FNSQ(3)-(FNSQ(3)-0.1)/2.0
         FNSQ(1) =0.1
      RETURN
      END
