c# syssy.f
      SUBROUTINE SYSSY(G, P, NN, FM, SU, SL, FMP, SUP, SLP)
C     SYSSY IS A TABLE LOOK-UP FOR DECILE VALUES OF THE DISTRIBUTION OF
C     EXCESS SYSTEM LOSS AND THE LIKELY PREDICTION OF ERRORS OF THE
C     SYSTEM LOSS IS DETERMINED.
C     G --- GEOMAGNETIC LATITUDE OF THE REFLECTION AREA
C     P --- REFLECTION AREA LOCAL TIME
C     NN --- DISTANCE INDEX (2 FOR <2500  5 FOR >= 2500)
C     FM --- EXCESS SYSTEM LOSS
C     SU --- UPPER DECILE OF DISTRIBUTION OF SYSTEM LOSS
C     SL --- LOWER DECILE OF DISTRIBUTION OF SYSTEM LOSS
C     FMP --- PREDICTION ERRORS IN EXCESS SYSTEM LOSS
C     SUP --- UPPER DECILE LIMIT ASSOCIATED WITH PREDICTION ERROR IN
C     EXCESS SYSTEM LOSS
C     SLP --- LOWER DECILE LIMIT ASSOCIATED WITH PREDICTION ERROR IN
C     EXCESS SYSTEM LOSS
      COMMON / TWO / F2D(16,6,6), DUD(5,12,5),FAM(14,12),
     A  SYS(9,16,6), PERR(9,4,6),C(29,16,8),ADP(2,9)
      LJ = 1
      J = P + .5
      GG = ABS (G) * 5.729577E1
      KJ = ((GG - 40.) / 5.) + 1.5
      IF(KJ .LE. 0) KJ=1
      IF(KJ .GT. 9) KJ=9
      KK = 0
      ND = 0
      IF(G .GE. 0.0) GOTO 130
      KK = 8
      ND = 3
 130  LJ = FLOAT (J) / 3. + .67
      IF(LJ .LT. 1) LJ=8
      LOL = LJ + KK
      LD = FLOAT(J) / 6. + .67
      IF(LD .LT. 1) LD=4
      FM = SYS (KJ, LOL, NN)
      DU = SYS (KJ, LOL, NN + 1)
      DL = SYS (KJ, LOL, NN - 1)
      FMP = PERR (KJ, LD, ND + 1)
      SUP = PERR (KJ, LD, ND + 2)
      SLP = PERR (KJ, LD, ND + 3)
      SU = DU / 1.28
      SL = DL / 1.28
      RETURN
      END
