c# tatr.f
      FUNCTION TATR(TINF,HGHT,DTDR)
C***********************************************************************
C*         PURPOSE: THIS FUNCTION CALCULATES A FIRST ESTIMATE OF THE   *
C*                  F2 LAYER THICKNESS.                                *
C*         METHOD:  1. ESTIMATE THICKNESS USING CLIMATOLOGICAL HEIGHTS *
C*                  2. ADJUST THIS VALUE USING THE TOTAL ELECTRON      *
C*                     CONTENT VALUE                                   *
C***********************************************************************
C
      DIMENSION C90(4)
C
      DATA C1,C2,C3,C4/371.6678,0.0518806,-294.3505,-0.00216222/
      DATA T90,Z90,Z125,C90/183.,90.,125.,1.90,0.,-1.70,-0.80/
      DATA BX,BETA,PIBY2/4.5E-6,2.5,1.5707963268/
      DATA T0/300./
C
C....................................................................
C     BEGIN EXECUTION
C....................................................................
C
      F2=dexp(dble(C4*TINF))
      TB=C1+(C2*TINF)+(C3*F2)
      F1=TB-T90
      F3=C90(1)/35.
      GX=F1*F3
      IF(HGHT.GT.Z90) then
         DZI=HGHT-Z125
         IF(DZI.LT.0.) THEN
            DZI=DZI/35.
            F4=DZI*(C90(1)+DZI*(C90(2)+DZI*(C90(3)+DZI*C90(4))))
            TATR=TB+F1*F4
            TEMP=(3.*C90(3))+(DZI*4.*C90(4))
            DTDR=F1*(C90(1)+DZI*(2.*C90(2)+DZI*TEMP))/35.
         ELSE IF(DZI.EQ.0.) THEN
C
            TATR=TB
            DTDR=GX
         ELSE IF(DZI.GT.0.) THEN
C
            AX=(TINF-TB)/PIBY2
            DZEX=BX*(DZI**BETA)
            ARG=(GX/AX)*DZI*(1.+DZEX)
            GXR=GX*((1.+DZEX)+(BETA*DZEX))
            F4=ATAN(ARG)
            TATR=TB+AX*F4
            TAYLOR=1.+ARG*ARG
            DTDR=GXR/TAYLOR
         ENDIF
         return
      endif
C
      DTDR=(T90-T0)/Z90
      TATR=T0+DTDR*HGHT
      RETURN
      END
 
