c# topsid.f
      SUBROUTINE TOPSID(II,SHOUT,HMF2,ZCHT,A2S2,ATZC,S2,EDZC,FNF2)
C***********************************************************************
C*         PURPOSE: COMPUTES PARAMETERS NEEDED FOR THE TOPSIDE         *
C*                  PROFILE.                                           *
C*         METHOD:  1. DETERMINE COEFFICIENTS FOR POLYNOMIAL TO FIND   *
C*                     BEST FIT CURVE OF IONOSPHERE ABOVE F2 PEAK.     *
C*                  2. USE ITERATIVE METHOD TO DETERMIN RELEVANT       *
C*                     TOPSIDE PARAMETERS.                             *
C***********************************************************************
      COMMON /GEOG/TLAT,TLONG,RLAT,RLONG,CLAT(5),CLONG(5),GLAT(5),
     A             CGLT(5),CGLN(5),GMDIP(5),GYZ(5),RD(5),KM,BTR,BTRD,
     B             BRTD,GCD,GCDKM,IFLG(5)
      COMMON /SOLAR/IYR,IMO,IDA,SSN,EFFQ,EFFKP,JUDAY,CHI(5),
     A TCGMT(5),PBT(5),CENT(5),EBT(5)
C
      DATA A2/3.15E-4/
      DATA PI/3.1415926536/
      DATA D2R/0.0174532925/
C
C..................................................................
C     BEGIN EXECUTION
C..................................................................
C
      DCGLT=CGLT(II)/D2R
      DAY=FLOAT(JUDAY)
      BULL=(0.41*(COS(PI*(DAY+11.)/182.5)))*SIN(CLAT(II))
      S2=5.88-0.015*DCGLT*COS(CHI(II)*D2R)+BULL-(0.14*EFFKP)
      A2S2=A2*S2
C...................................................................
C     BEGIN ITTERATIVE PROCESS   'SUGGESTED BY MIKE REILLY'
C...................................................................
      XR1 = 37.0
  100 CONTINUE
      S = XR1 / SHOUT
      W= A2S2 * (XR1+HMF2)
      W2 = W*W
      E = dexp( dble(-S) )
      F0 = ((1.-E)/SHOUT) - ((S2*A2S2)/(1.+W2))
      F1 = E/(SHOUT**2)+(2.*S2*(XR1+HMF2)*(A2S2**3))/((1.+W2)**2)
      D = -F0/F1
      XR1 = XR1 + D
      IF ( ABS(D) .GT. 5.0E-4 ) GO TO 100
C
C..................................................................
C     END OF ITTERATION
C..................................................................
C
      ZCHT=XR1+HMF2
      SZC=XR1/SHOUT
      EDZC = FNF2*dexp(dble(1. - SZC - dexp(dble(-SZC))))
      ATZC=ATAN(A2S2*ZCHT)
      RETURN
      END
 
