      subroutine nsa_noise1(xnois,znoise,freq)
c          calculate man-made noise if input from NSA data (noise_type=1)
      common /Cnsa_noise/ noise_type,iband_width,Enoise(6),Fa_nsa(6) !  NSA noise entry
c          noise_type = 1 = man-made noise
c                     = 2 = total noise
c          iband_width= bandwidth (KHz) of measurement antenna
c          En = noise field strength (really En + Gr)
c          Fa_nsa = En - 20LogF - 10Logb +96.8   (En is really En + Gr)
      COMMON / FILES / LUO, LUI,LU25,LU26
ccc      EnGr=xnois + 20.*alog10(freq)-66.8  ! (10LOGb -96.8)
ccc      write(luo,2) freq,xnois,znoise,EnGr
ccc2     format('nsa_noise1=',4f10.3)
      if(noise_type.ne.1) return     !  only calculate if noise_type=1 (man-made)
      Fa=get_Fa(freq)
      En=Fa + 20.*alog10(freq) -66.8
      xnois=Fa
ccc      write(luo,3) Fa,En
ccc3     format('Fa=',f10.3,'    En=',f10.3)
ccc      write(luo,1) freq,204.+Fa,204.+En,204.+atnos,204.+gnos,204.+xnmm
ccc1     format('nsa_noise=',6f10.3)
      return
      end
c-----------------------------------------------------------------------------
      subroutine nsa_noise2(xrnse,freq,atnos,gnos,xnmm)
c          calculate total noise if input from NSA data (noise_type=2)
      common /Cnsa_noise/ noise_type,iband_width,Enoise(6),Fa_nsa(6) !  NSA noise entry
c          noise_type = 1 = man-made noise
c                     = 2 = total noise
c          iband_width= bandwidth (KHz) of measurement antenna
c          En = noise field strength
c          Fa_nsa = En - 20LogF - 10Logb +96.8   (En is really En + Gr)
      COMMON / FILES / LUO, LUI,LU25,LU26
ccc      Fa=xrnse+204.
ccc      EnGr=Fa + 20.*alog10(freq)-66.8  ! (10LOGb -96.8)
  
ccc      write(luo,2) freq,xrnse,atnos,gnos,xnmm,Fa,EnGr
ccc2     format('nsa_noise2=',7f9.3)
      if(noise_type.ne.2) return     !  only calculate if noise_type=2 (total)
      Fa=get_Fa(freq)
      En=Fa + 20.*alog10(freq) -66.8
      xrnse=Fa-204.
ccc      write(luo,3) Fa,En
ccc3     format('Fa=',f10.3,'    En=',f10.3)
ccc      En=Fa + 20.*alog10(freq) -66.8
ccc      write(luo,1) freq,204.+Fa,204.+En,204.+atnos,204.+gnos,204.+xnmm
ccc1     format('nsa_noise=',6f10.3)
      return
      end
c-----------------------------------------------------------------------------
      function get_Fa(freq)
      COMMON / FILES / LUO, LUI,LU25,LU26
      common /Cnsa_noise/ noise_type,iband_width,Enoise(6),Fa_nsa(6) !  NSA noise entry
c          noise_type = 1 = man-made noise
c                     = 2 = total noise
c          iband_width= bandwidth (KHz) of measurement antenna
c          En = noise field strength (really En + Gr)
c          Fa_nsa = En - 20LogF - 10Logb +96.8   (En is really En + Gr)
      dimension freqs(6)
      data freqs/2.5,5.,7.5,10.,20.,30./
      if(freq.gt.freqs(1)) go to 5
      get_Fa=Fa_nsa(1)      !  use value for 2.5 MHz
      return
5     do 10 i=2,6
      if(freq.gt.freqs(i)) go to 10
      frac=(freq-freqs(i-1))/(freqs(i)-freqs(i-1))
      frac=(alog10(freq)-alog10(freqs(i-1)))/
     +                (alog10(freqs(i))-alog10(freqs(i-1)))
      get_Fa=Fa_nsa(i-1) + frac*(Fa_nsa(i)-Fa_nsa(i-1))
ccc      write(luo,1) freq,i,frac,get_Fa
ccc1     format('get_Fa=',f8.3,i5,f8.5,f10.3)
      return
10    continue
      get_Fa=Fa_nsa(6)      !  use value for 30. MHz
      return
      end
c-----------------------------------------------------------------------------
      subroutine read_nsa_noise
      common /Cnsa_noise/ noise_type,iband_width,Enoise(6),Fa_nsa(6) !  NSA noise entry
c          noise_type = 1 = man-made noise
c                     = 2 = total noise
c          iband_width= bandwidth (KHz) of measurement antenna
c          En = noise field strength
c          Fa_nsa = En - 20LogF - 10Logb +96.8   (En is really En + Gr)
      COMMON / FILES / LUO, LUI,LU25,LU26
      dimension freqs(6)
      data freqs/2.5,5.,7.5,10.,20.,30./
      noise_type=2
      iband_width=1
      if(noise_type.eq.1) then
         Enoise(1)=-2.664
         Enoise(2)=-4.982
         Enoise(3)=-6.338
         Enoise(4)=-7.3
         Enoise(5)=-9.618
         Enoise(6)=-10.974
      else
         Enoise(1)=5.294
         Enoise(2)=4.096
         Enoise(3)=.812
         Enoise(4)=-3.471
         Enoise(5)=-9.336
         Enoise(6)=-10.683
      end if
      b=float(iband_width)*1000.    !  convert KHz to Hz
      do 10 i=1,6
10    Fa_nsa(i)=Enoise(i) - 20.*alog10(freqs(i)) - 10.*alog10(b) +96.8
ccc      write(luo,1) freqs
ccc1     format('NSA noise, Freqs=',6f9.3)
ccc      write(luo,2) Enoise
ccc2     format('           En   =',6f9.3)
ccc      write(luo,3) Fa_nsa
ccc3     format('           Fa   =',6f9.3)
      return
      end
c-----------------------------------------------------------------------------
